<?php

namespace App\Imports;

use App\Helpers\LeadDistributeHelper;
use App\Lead;
use App\PriceList;
use App\Task;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Validators\Failure;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\WithValidation;

class LeadsImport implements ToModel, WithStartRow, WithValidation
{
    use Importable;
    use SkipsFailures;



    /**
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {


        $check = false;
        $check_email = false;

        $check_mobile_task = false;
        $check_email_task = false;
        $fifteenDays = now()->subDays(15);
        $sixMonthBefore = now()->subMonths(3);


        $phone_code = $row[2];
        $mobile = $row[3];

        $duplicate_entry = 'no';
        $sales_head_approval = NULL;
        $is_attended = 0;

        if (!empty($mobile)) {
            // $check = Lead::where('phone_code', $phone_code)->where('mobile', $mobile)->first();

            $check = Lead::where('mobile', $mobile)->get()->last();

            // $task = Task::where('lead_id', $check->id)->get()->last();
            if (!$check) {
                $mbb = $phone_code . $mobile;
                $check = Lead::where('mobile', $mbb)->get()->last();
                if (!$check) {
                    $check = Lead::where('phone_code', $phone_code)->where('mobile', $mobile)->get()->last();

                    if (!$check) {

                        $n = 10;

                        if (strlen($mobile) == 9) {

                            $n = 9;
                        }

                        if (strlen($mobile) == 8) {

                            $n = 8;
                        }

                        $start = strlen($mobile) - $n;
                        $last_str = substr($mobile, $start);
                        if ($start >= 0) {
                            $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                        }
                    }
                }
            }
        }
        if (!empty($email)) {
            $check_email = Lead::where('email', $email)->get()->last();
        }

        if ($check) {
            $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
        }
        if ($check_email) {
            $check_email_task = Task::where('lead_id', $check_email->id)->get()->last();
        }





        if ($check && $check->created_at >= $sixMonthBefore) {
            $duplicate_entry = 'yes';
            $sales_head_approval = 0;
        } elseif ($check_email && $check_email->created_at >= $sixMonthBefore) {
            $duplicate_entry = 'yes';
            $sales_head_approval = 0;
        } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {
            $duplicate_entry = 'yes';
            $sales_head_approval = 0;
        } elseif ($check_email_task && $check_email_task->created_at >= $fifteenDays) {
            $duplicate_entry = 'yes';
            $sales_head_approval = 0;
        }



        if (auth()->user()->hasRole('executive')) {
            $is_attended = 1;
        }



        if (auth()->user()->hasRole('super-admin') || auth()->user()->hasRole('admin') || auth()->user()->hasRole('ceo') ||auth()->user()->hasRole('sbm') || auth()->user()->hasRole('sales-support')) {
            $attended_by = null;
        } elseif (empty(auth()->user()->reporting_to)) {
            $attended_by = null;
        } else {
            $attended_by = auth()->user()->id;
        }

        $lead = new  Lead();

        $lead->enquirer_name =  $row[0];
        $lead->email = $row[1];

        $lead->phone_code = $row[2];

        $lead->mobile = $row[3];

        $lead->alt_mobile = $row[4];

        $lead->source = $row[5];

        $lead->project_type = $row[6];

        $lead->preferred_project = $row[7];

        $lead->budget = $row[8];

        $lead->location = $row[9];

        $lead->lead_date = $row[10] ? $row[10] : date('Y-m-d');

        $lead->remarks = $row[11];

        $lead->duplicate_entry = $duplicate_entry;

        $lead->sales_head_approval = $sales_head_approval;

        $lead->created_by = auth()->user()->id;

        $lead->attended_by = $attended_by;

        $lead->is_attended = $is_attended;
        // $lead = new Lead([

        //     'id' => '',

        //     'enquirer_name' => $row[0],

        //     'email' => $row[1],

        //     'phone_code' => $row[2],

        //     'mobile' => $row[3],

        //     'alt_mobile' => $row[4],

        //     'source' => $row[5],

        //     'project_type' => $row[6],

        //     'preferred_project' => $row[7],

        //     'budget' => $row[8],

        //     'location' => $row[9],

        //     'lead_date' => $row[10] ? $row[10] : date('Y-m-d'),

        //     'remarks' => $row[11],

        //     'duplicate_entry' => $duplicate_entry,

        //     'sales_head_approval' => $sales_head_approval,

        //     'created_by' => auth()->user()->id,

        //     'attended_by' => $attended_by,

        //     'is_attended' => $is_attended,

        // ]);

        if ($lead->save()) {

            $uId = 'HiLEAD/' . date('Y') . '/' . $lead->id;
            $lead->unique_id = $uId;
            $lead->save();
        }



        return $lead;
    }

    public function startRow(): int
    {
        return 2;
    }

    public function rules(): array
    {
        return [
            '0' => ['required'],
            '1' => ['nullable', 'required_without:*.3'],

            '2' => ['nullable'],

            '3' => ['nullable', 'required_without:*.1'],

            '4' => ['nullable'],
            '5' => ['required'],
            '6' => ['nullable'],
            '7' => ['nullable'],
            '8' => ['nullable'],
            '9' => ['nullable'],
            '10' => ['nullable'],
            '11' => ['nullable'],



        ];
    }
    public function customValidationMessages()
    {
        return [
            '0.required' => 'Enquirer Name field is required.',
            '1.required_without' => 'Email field is required when mobile is not present.',
            '3.required_without' => 'Phone Number field is required when email is not present.',
            '5.required' => 'Source field is required.',

        ];
    }
    public function onFailure(Failure ...$failures)
    {
        // Handle the failures how you'd like.
    }

    public function onError(\Throwable $e)
    {
        // Handle the exception how you'd like.
        throw $e;
    }
}
