<?php

namespace App\Imports\PMD;

use App\ProjectSchedule;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Validators\Failure;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\WithValidation;

class ProjectScheduleImport implements ToModel, WithStartRow, WithValidation
{

    use Importable;
    use SkipsFailures;


    public function model(array $row)
    {

        return new ProjectSchedule([


            'parent' => $row[0],

            'email' => $row[1],

            'phone_code' => $row[2],

            'mobile' => $row[3],

            'alt_mobile' => $row[4],

            'source' => $row[5],

            'project_type' => $row[6],

            'preferred_project' => $row[7],

            'budget' => $row[8],

            'location' => $row[9],

            'lead_date' => $row[10] ? $row[10] : date('Y-m-d'),

            'remarks' => $row[11],

        ]);
    }

    public function startRow(): int
    {
        return 2;
    }

    public function rules(): array
    {
        return [
            '0' => ['required'],
            '2' => ['required'],
            '3' => ['required'],
            '4' => ['required'],
            '5' => ['required'],
            '6' => ['required'],
        ];
    }
    public function customValidationMessages()
    {
        return [
            '0.required' => 'this field is required.',
            '1.required' => 'this field is required.',
            '2.required' => 'this field is required.',
            '3.required' => 'this field is required.',
            '4.required' => 'this field is required.',
            '5.required' => 'this field is required.',
        ];
    }
    public function onFailure(Failure ...$failures)
    {
        // Handle the failures how you'd like.
    }

    public function onError(\Throwable $e)
    {
        // Handle the exception how you'd like.
        throw $e;
    }
}
