<?php

namespace App\Imports;

use App\PhoneBill;
use App\User;
use Carbon\Carbon;
use Illuminate\Validation\Rule;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Validators\Failure;

class PhoneBillImport implements ToModel, WithStartRow, WithValidation
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        $unixTimestamp = ($row[6] - 25569) * 86400;

        // Convert Unix timestamp to Carbon date
        $date = Carbon::createFromTimestamp($unixTimestamp);

        // Format the date as needed
        $formattedDate = $date->format('Y-m');

        $user = User::where('mobile', $row[1])->first();
        if ($user) {
            $phoneBill = new PhoneBill();
            $phoneBill->account_number = $row[0];
            $phoneBill->mobile_no = $row[1];
            $phoneBill->monthly_rentals = $row[2];
            $phoneBill->usage = $row[3];
            $phoneBill->one_time_charges = $row[4];
            $phoneBill->user_id = $user->id;
            $phoneBill->amount = $row[5];
            $phoneBill->period = $formattedDate;
            $amountToBePaid = ($phoneBill->amount * 1.18) - 500;
            $phoneBill->amount_to_be_paid = $amountToBePaid;
            $phoneBill->save();
        }
    }

    public function startRow(): int
    {
        return 2;
    }

    public function rules(): array
    {
        return [
            '0' => ['required'],
            '1' => ['required'],
            '2' => ['required'],
            '3' => ['required'],
            '4' => ['required'],
            '5' => ['required'],
            '6' => ['required'],
        ];
    }
    public function customValidationMessages()
    {
        return [
            '0.required' => 'Account Number field is required.',
            '1.required' => 'Mobile Number field is required.',
            '2.required' => 'Monthly Rentals field is required.',
            '3.required' => 'Usage field is required.',
            '4.required' => 'One Time Charges field is required.',
            '5.required' => 'Total field is required.',
            '6.required' => 'Period field is required.',
        ];
    }
    public function onFailure(Failure ...$failures)
    {
        // Handle the failures how you'd like.
    }

    public function onError(\Throwable $e)
    {
        // Handle the exception how you'd like.
        throw $e;
    }
}
