<?php

namespace App\Imports;

use App\PriceList;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Validators\Failure;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\SkipsOnFailure;
use Maatwebsite\Excel\Concerns\WithValidation;

class ProjectUnitImport implements ToModel, WithStartRow, WithValidation
{
    use Importable;
    use SkipsFailures;

    protected $projectId;

    public function __construct($projectId)
    {
        $this->projectId = $projectId;
    }

    /**
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {

        // dd($row);
        PriceList::updateOrCreate(
            ['ap_no' => $row[2], 'project_id' => $this->projectId],

            [
                'floor' => $row[0],

                'apartment_type' => $row[1],

                'carpet_area' => $row[3],

                'sba_area' => $row[4],

                'extended_balcony_area' => $row[5],

                'car_parking' => $row[6],

                'carparking_amount' => $row[7],

                'sale_value' => $row[8],

                'taxable_amount' => $row[9],

                'parking_number' => $row[10],

                'rate_per_sqft' => $row[11],

                'grand_total' => $row[12],

            ]
        );
    }

    public function startRow(): int
    {
        return 2;
    }

    public function rules(): array
    {
        return [
            '0' => ['required'],
            '1' => ['required'],
            '2' => ['required'],
            '3' => ['required'],
            '4' => ['required'],
            '5' => ['required'],
            '6' => ['required'],
            '7' => ['required'],
            '8' => ['nullable'],
            '9' => ['required'],
            '10' => ['required'],
            '11' => ['required'],
            '12' => ['required'],


        ];
    }
    public function customValidationMessages()
    {
        return [
            '0.required' => 'Floor field is required.',
            '1.required' => 'Apartment Type field is required.',
            '2.required' => 'Ap No field is required.',
            '3.required' => 'Carpet Area field is required.',
            '4.required' => 'Area Of Appartment field is required.',
            '5.required' => 'Extended Balcony Area field is required.',
            '6.required' => 'Parking Number field is required.',
            '7.required' => 'Car Parking Amount field is required.',
            '8.required' => 'Sale Value field is required.',
            '9.required' => 'GST field is required.',
            '10.required' => 'Parking Number field is required.',
            '11.required' => 'Rate Per (sq.ft) field is required.',
            '12.required' => 'Grand Total field is required.',
        ];
    }
    public function onFailure(Failure ...$failures)
    {
        // Handle the failures how you'd like.
    }

    public function onError(\Throwable $e)
    {
        // Handle the exception how you'd like.
        throw $e;
    }
}
