<?php

namespace App\Imports;

use App\WhatsAppContact;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Validators\Failure;

class WhatsAppImport implements ToModel, WithStartRow, WithValidation
{
    use Importable;
    use SkipsFailures;



    /**
     * @return \Illuminate\Database\Eloquent\Model|null
     */

     protected $project;
    protected $user;

    public function __construct($project, $user)
    {
        $this->project = $project;
        $this->user = $user;
    }
    public function model(array $row)
    {

    $mobile = $row[1];

    if (!empty($mobile)) {
        $duplicate = 'no';
        $check = WhatsAppContact::where('mobile', $mobile)->get()->last();


        if (!$check) {
            $mbb = $mobile;
            $check = WhatsAppContact::where('mobile', $mbb)->get()->last();
            if (!$check) {
                $check = WhatsAppContact::where('mobile', $mobile)->get()->last();

                if (!$check) {

                    $n = 11;
                    if (strlen($mobile) == 10) {

                        $n = 10;
                    }

                    if (strlen($mobile) == 9) {

                        $n = 9;
                    }

                    if (strlen($mobile) == 8) {

                        $n = 8;
                    }

                    $start = strlen($mobile) - $n;
                    $last_str = substr($mobile, $start);
                    if ($start >= 0) {
                        $check = WhatsAppContact::where('mobile', 'LIKE', '%' . $last_str . '%')->get()->last();
                    }
                }
            }
        }
    }
    if($check) {
        $duplicate = 'yes';
    }

    $whatsApp = new  WhatsAppContact();

    $whatsApp->enquirer_name =  $row[0];
    $whatsApp->mobile = $row[1];
    $whatsApp->duplicate_entry	 = $duplicate;
    $whatsApp->preferred_project	 = $this->project;
    $whatsApp->attended_by = $this->user;
    $whatsApp->lead_date = now()->format(
        'Y-m-d'
    );


    $whatsApp->save();




        return $whatsApp;
    }

    public function startRow(): int
    {
        return 2;
    }

    public function rules(): array
    {
        return [
            '0' => ['required'],
            '1' => ['required'],

         

           
         



        ];
    }
    public function customValidationMessages()
    {
        return [
            '0.required' => 'Enquirer Name field is required.',
            '1.required' => 'Mobile field is required',
          

        ];
    }

    public function chunkSize(): int
    {
        return 100;
    }
    public function onFailure(Failure ...$failures)
    {
        // Handle the failures how you'd like.
    }

    public function onError(\Throwable $e)
    {
        // Handle the exception how you'd like.
        throw $e;
    }
   
}
