<?php

namespace App\Jobs\DataMigration;

use App\LeadBank;
use App\WhatsAppContact;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;

class WhatsappLeadsMigrationJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        WhatsAppContact::where('migrated', 0)->chunk(100, function ($leads) {
            foreach ($leads as $lead) {
                $length = -10;

                if (strlen($lead->mobile) == 9) {
                    $length = -9;
                }
                if (strlen($lead->mobile) == 8) {
                    $length = -8;
                }
                $mobileNumber = substr($lead->mobile, $length);
                $existingLead = LeadBank::where('mobile',  $mobileNumber)->first();
                if (!$existingLead || $lead->mobile == null) {
                    LeadBank::create([
                        'lead_id' => $lead->id,
                        'enquirer_name' => $lead->enquirer_name,
                        'mobile' => $lead->mobile,
                        'duplicate_entry' => $lead->duplicate_entry,
                        'preferred_project' => $lead->preferred_project,
                        'attended_by' => $lead->attended_by,
                        'lead_date' => $lead->lead_date,
                        'type' => 'whatsapp',
                        'source' => 48,
                    ]);
                }
                $lead->update(['migrated' => 1]);
            }
        });
    }
}
