<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class LeaseRentalAgreement extends Model
{
    protected $table = 'lease_rental_agreements';
    protected $primaryKey = 'id';
    public $timestamps = false;
    protected $guarded = [];

    public function getProjectName()
    {
        return $this->belongsTo(Project::class, 'project_id', 'id');
    }

    public function getProjectUnit()
    {
        return $this->belongsTo(UnitDefinition::class, 'project_units_id', 'id');
    }

    public function getFloor()
    {
        return $this->belongsTo(Floor::class, 'floor_id', 'id');
    }

    public function getType()
    {
        return $this->belongsTo(UnitType::class, 'type_id', 'id');
    }

    public function getLesseeName()
    {
        return $this->belongsTo(LesseEntry::class, 'lessee_id', 'id');
    }

    public function getRateItem()
    {
        return $this->belongsTo(RateItemDefinition::class, 'rate_definition_id', 'id');
    }

}
