<?php

namespace App\Mail\CRM;

use App\Customer;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class CustomerCredentialMail extends Mailable
{
    use Queueable, SerializesModels;

    private Customer $customer;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Customer $customer, $password)
    {
        $this->customer = $customer;
        $this->password = $password;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('HiLITE Builders - Customer Credentials')
            ->view('CRM.client.Mails.MailTemplates.customerCredentialMail')->with(['customer' => $this->customer, 'password' => $this->password]);
    }
}
