<?php

namespace App\Mail\CRM;

use App\Receipt;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class PaymentReceivedMail extends Mailable
{
    use Queueable, SerializesModels;

    private Receipt $receipt;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Receipt $receipt)
    {

        $this->receipt = $receipt;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {


        return $this->subject('HiLITE Builders - Payment Confirmation')
            ->view('CRM.client.Mails.MailTemplates.paymentReceivedMail')->with(['receipt' => $this->receipt]);
    }
}
