<?php

namespace App\Mail\CRM;

use App\Receipt;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PaymentReminderMail extends Mailable
{
    use Queueable;
    use SerializesModels;

    private  $request;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($request)
    {

        $this->request = $request;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {



        return $this->subject($this->request->subject)
            ->view('CRM.client.Mails.MailTemplates.paymentReminder')->with(['request' => $this->request]);
    }
}
