<?php

namespace App\Mail\Leads;

use App\Customer;
use App\PreferredProject;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class ProjectMail extends Mailable
{
    use Queueable, SerializesModels;


    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(PreferredProject $project,  $request, $registration, $proposal)
    {

        $this->project = $project;
        $this->request = $request;
        $this->registration = $registration;
        $this->proposal = $proposal;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('HiLITE Builders - Project Details')
            ->view('dashboard.preferred_projects.mail')->with(['request' => $this->request, 'project' => $this->project, 'registration' => $this->registration, 'proposal' => $this->proposal]);
    }
}
