<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use NotificationChannels\OneSignal\OneSignalChannel;
use NotificationChannels\OneSignal\OneSignalMessage;

class TeamLeaderRejectedNotification extends Notification
{
    use Queueable;
    protected $user;
    protected $createTaskId;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($user, $createTaskId)
    {
        $this->user = $user;
        $this->createTaskId = $createTaskId;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return [OneSignalChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    // public function toMail($notifiable)
    // {
    //     return (new MailMessage)
    //                 ->line('The introduction to the notification.')
    //                 ->action('Notification Action', url('/'))
    //                 ->line('Thank you for using our application!');
    // }

    public function  toOneSignal($notifiable)
    {
        $body = "Your $this->createTaskId task has been declined by the team leader";
        return OneSignalMessage::create()
        ->setBody($body)
        ->setSound('IncomingMessage.wav')
        ->setParameter('android_channel_id','df2da822-661e-4507-8318-3e3a466077c2')
        ->setPriority(10);

    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
