<?php

namespace App;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Permission extends Model
{
    use SoftDeletes;

    public function roles()
    {
        return $this->belongsToMany(Role::class,'roles_permissions');
    }
    public function isPermissionAttachToRole($roleID)
    {
        $count = DB::table('role_permissions')
            ->where('role_id', '=', $roleID)
            ->where('permission_id', '=', $this->id)
            ->count();

        return $count > 0 ? TRUE : FALSE ;
    }
}
