<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PreferredProject extends Model
{
    use SoftDeletes;

    protected $table = 'preferred_projects';
    public function getProjectType()
    {
        return $this->belongsTo('App\ProjectType', 'project_type', 'id');
    }
    public function getImages()
    {
        return $this->hasMany('App\PreferredProjectImage', 'preferred_project_id', 'id');
    }

    public function getUnits()
    {
        return $this->hasMany(PriceList::class, 'project_id', 'id');
    }

    public function getReceipts()
    {
        return $this->hasMany(Receipt::class, 'project_id');
    }

    public function getSaleActivity()
    {
        return $this->hasMany(SalesActivity::class, 'project');
    }

    public function getProjectTemplate()
    {
        return $this->hasOne(ProjectTemplate::class, 'project_id');
    }
}
