<?php

namespace App\Providers;

use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {

     
        
        View::composer('*', function ($view) {
            if (Auth::check()) {
                $teamMembers = User::where('reporting_to', auth()->user()->id)->where('status', 1)->get();
                $view->with('teamMembers', $teamMembers);
            }
        });
    }
}
