<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Registration extends Model
{
    use SoftDeletes;

    protected $table = 'registrations';

    protected $guarded = [];


    public function preferredProject()
    {
        return $this->hasOne(PreferredProject::class, 'id', 'project_id');
    }
    public function unit()
    {
        return $this->hasOne(PriceList::class, 'id', 'unit_id');
    }
}
