<?php

namespace App\Traits;

use Illuminate\Http\JsonResponse;

trait ApiResponseTrait
{
    public function success(

        $message = 'Ok',
        $data = [],
        $httpStatus = 200
    ): JsonResponse {
        return response()->json(
            [

                'message' => $message,
                'data' => $data,
            ],
            $httpStatus
        );
    }

    public function error(

        $message = 'Error',
        $errors = [],
        $httpStatus = 422
    ): JsonResponse {
        return response()->json(
            [

                'message' => $message,
                'errors' => $errors,
            ],
            $httpStatus
        );
    }
}
