<?php

namespace App\Traits;

use App\Lead;

trait DuplicateLeadCheck
{

    public function checkDuplicateEmail($email, $leadId)
    {
        $check = Lead::where('email', $email)->where('id', '<>', $leadId)->first();


        if ($check) {

            return true;
        }
        return false;
    }


    public function checkDuplicateMobile($phoneCode, $mobile, $leadId)
    {

        $check = Lead::where('mobile', $mobile)->where('id', '<>', $leadId)->first();

        if (!$check) {
            $check = Lead::where('mobile', $phoneCode . $mobile)->where('id', '<>', $leadId)->first();

            if (!$check) {
                $check = Lead::where('phone_code', $phoneCode)->where('mobile', $mobile)->where('id', '<>', $leadId)->first();

                if (!$check) {
                    $n = 10;
                    $start = strlen($mobile) - $n;
                    $last_str = substr($mobile, $start);
                    if ($start >= 0) {
                        $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->where('id', '<>', $leadId)->first();
                    }
                }
            }
        }

        if ($check) {
            return true;
        }
        return false;
    }



    public function leadsListTest()
    {

        $leads = Lead::select('id', 'email', 'mobile')->get();

        if ($leads) {
            return $leads;
        }

        return collect([]);
    }
}
