<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UnitChangeRequest extends Model
{
    use SoftDeletes;

    protected $table = 'unit_change_requests';
    protected $primaryKey = 'id';
    protected $guarded = [''];

    public function getCurrentUnit()
    {
        return $this->belongsTo(PriceList::class, 'current_unit_id', 'id');
    }

    public function getRequestedUnit()
    {
        return $this->belongsTo(PriceList::class, 'requested_unit_id', 'id');
    }

    public function getRequestedProject()
    {
        return $this->belongsTo(PreferredProject::class, 'requested_project_id', 'id');
    }
    public function getRequestedBy()
    {
        return $this->belongsTo(User::class, 'request_by', 'id');
    }
}
