<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class UnitDefinition extends Model
{
    protected $table = 'unit_definitions';
    protected $primaryKey = 'id';
    public $timestamps = false;
    protected $guarded = [];

    public function getProjects()
    {
        return $this->belongsTo(Project::class, 'project_id', 'id');
    }

    public function getFloors()
    {
        return $this->belongsTo(Floor::class, 'floor_id', 'id');
    }

    public function getTypes()
    {
        return $this->belongsTo(UnitType::class, 'type_id', 'id');
    }
    public function getBlocks()
    {
        return $this->belongsTo(Block::class, 'block_id', 'id');
    }
}
