<?php

namespace App;

use App\Traits\HasRolesAndPermissions;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Collection;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use Notifiable;
    use HasRolesAndPermissions;
    use SoftDeletes;
    use HasApiTokens;

    protected $guarded=[];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    // public $sections;
    // public function __construct(){
    //     $this->sections = new Collection();
    // }
    public function getCrmLastActivityLog()
    {
        $data = \App\ActivityLog::where('user_id', $this->id)->where('activity_type', 'crm')->get()->last();
        return $data;
    }

    public function getLeadsLastActivityLog()
    {
        $data = \App\ActivityLog::where('user_id', $this->id)->where('activity_type', 'leads')->get()->last();
        return $data;
    }

    public function getReportingTo()
    {
        return $this->belongsTo('\App\User', 'reporting_to', 'id');
    }

    public function getCreatedBy()
    {
        return $this->belongsTo('\App\User', 'created_by', 'id');
    }

    public function getReportingUsers()
    {
        $data = \App\User::where('reporting_to', \Auth::user()->id)->pluck('id')->toArray();

        return $data;
    }

    public function reportingUsers()
    {
        $data = \App\User::where('reporting_to', $this->id)->get();

        return $data;
    }

    public function getAllReportingUsersObj()
    {
        $sections = new Collection();

        $c_data = $this->reportingUsers();
        if (count($c_data) > 0) {
            foreach ($c_data as $section) {
                $sections->push($section);
                $c_data_ = $section->reportingUsers();
                if (count($c_data_) > 0) {
                    $cc = $section->getAllReportingUsersObj();
                    $sections = $sections->merge($cc);
                } else {
                    // $this->sections = $this->sections->merge($section->getAllChildren(1));
                }
            }
        }

        return $sections;
    }

    public function getAllReportingUsersIds()
    {
        $sections = new Collection();

        $c_data = $this->reportingUsers();
        if (count($c_data) > 0) {
            foreach ($c_data as $section) {
                $sections->push($section->id);
                $c_data_ = $section->reportingUsers();
                if (count($c_data_) > 0) {
                    $cc = $section->getAllReportingUsersIds();
                    $sections = $sections->merge($cc);
                } else {
                    // $this->sections = $this->sections->merge($section->getAllChildren(1));
                }
            }
        }

        return $sections->toArray();
    }

    public function getAllReportingUsersIdsForAllocation()
    {
        $sections = new Collection();

        $c_data = $this->reportingUsers()->where('status', 1);
        if (count($c_data) > 0) {
            foreach ($c_data as $section) {
                $sections->push($section->id);
                $c_data_ = $section->reportingUsers();
                if (count($c_data_) > 0) {
                    $cc = $section->getAllReportingUsersIds();
                    $sections = $sections->merge($cc);
                } else {
                    // $this->sections = $this->sections->merge($section->getAllChildren(1));
                }
            }
        }

        return $sections->toArray();
    }

    public function roles()
    {
        return $this->belongsToMany(Role::class, 'users_roles', 'user_id', 'role_id');
    }

    public function sentNotifications()
    {
        return $this->hasMany(Notification::class);
    }

    public function receivedNotifications()
    {
        return $this->belongsToMany(Notification::class, 'sent_notifications')
            ->withTimestamps()
            ->withPivot('viewed_at');
    }

    public function getBranch()
    {
        return $this->belongsTo(Branch::class, 'branch_id', 'id');
    }

    public function routeNotificationForOneSignal()
    {
        return [$this->push_token];
    }

}
