<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddNewFieldsToAllotmentLettersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('allotment_letters', function (Blueprint $table) {
            $table->date('date')->after('address')->nullable();
            $table->string('stamped_receipt_bearing_no')->after('date')->nullable();
            $table->double('receipt_amount', 10, 2)->after('stamped_receipt_bearing_no')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('allotment_letters', function (Blueprint $table) {
        });
    }
}
