@extends('dashboard.layouts.app')
@section('css')
<style>
  .invalid-feedback{ color: #f00;}
 
</style>
@endsection
@section('content')
<div class="page-titles">
  <div class="d-flex align-items-center">
      <h5 class="font-medium m-b-0">Change Password</h5>
      <div class="custom-breadcrumb ml-auto">
          <a href="{{url('/dashboard')}}" class="breadcrumb">Home</a>
          <a href="{{url('/dashboard/users/change-password')}}" class="breadcrumb">Change Password</a>
      </div>
  </div>
</div>
<div class="container-fluid">
  <div class="row">
      <div class="col s12 l12">
          <div class="card">
              <div class="card-content">
                  {{-- <h5 class="card-title activator">Add User</h5> --}}
                  @if ($message = Session::get('success'))
                  <div class="success-alert-bar p-15 m-b-20 green white-text">
                    {{ $message }}
                </div>
            
              @endif
              @if (count($errors) > 0)
        
        <div class="error-alert-bar p-15 m-b-20 red white-text">
          <strong>Whoops!</strong> There were some problems with your input.<br><br>
          <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
      </div>
      @endif
      <div class="row">
      <form method="post" action="{{url('dashboard/change-password/update')}}" enctype="multipart/form-data" class="formValidate" id="formValidate">
        <div class="col s12 l6">
        {{csrf_field()}}
                      <div class="row">
                          <div class="input-field col s4">
                              <input id="current_password" type="text" name="current_password" value="" required>
                              <label for="current_password">Current Password</label>
                              @error('current_password')
                              <span class="invalid-feedback" role="alert">
                                  <strong>{{ $message }}</strong>
                              </span>
                          @enderror
                          </div>
                          <div class="input-field col s3">
                            <input id="new_password" type="password" name="new_password" value="" minlength="8" required>
                            <label for="new_password">New Password</label>
                            @error('new_password')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                        </div>
                        <div class="input-field col s5">
                            <input id="new_confirm_password" type="password" name="new_confirm_password" value="" minlength="8" required>
                            <label for="new_confirm_password">Confirm New Password</label>
                            @error('new_confirm_password')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                        </div>
                      </div>
                   
                      
                      
                      <div class="row">
                          <div class="input-field col s12">
                              <button class="btn cyan waves-effect waves-light right" type="submit" name="action">Submit
                              </button>
                          </div>
                      </div>
        </div>
        
                  </form>
                </div>
              </div>
          </div>
      </div>
  </div>
</div>
@endsection
