@extends('dashboard.layouts.app')
@section('content')

    <style>
        label {
            top: -34px !important;
        }

        label.active {
            transform: translate(10px, 10px) !important;
        }

        input {
            width: 100%;
            height: 3rem;
        }

        /* .dropdown-content {
                                                                                                                                                                                                                                    width: 130px;
                                                                                                                                                                                                                                } */


        .select2-container--material .select2-results>.select2-results__options {
            max-height: 100px;
            overflow-y: auto;
        }

        .best-perf-div {
            min-height: 380px;
            height: auto;
        }

        .invalid-feedback {
            color: rgb(231, 54, 54);
        }

        .chip {

            transition: transform .2s;
            box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;

        }

        .chip:hover {
            -ms-transform: scale(1.1);
            /* IE 9 */
            -webkit-transform: scale(1.1);
            /* Safari 3-8 */
            transform: scale(1.1);
        }

        .min-w-120 {
            min-width: 120%;
        }
    </style>

    <div class="card info-gradient m-t-0 m-b-0">
        <div class="card-content">
            <div class="">
                <h3 class="white-text m-b-5">Welcome {{ \Auth::user()->name }}!</h3>
                <p class="white-text op-7 m-b-0">Make Today Count !</p>
            </div>
        </div>
    </div>




    <div class="container-fluid">
        <!-- ============================================================== -->
        <!-----------------------------LEAD SCREENER DASHBOARD COUNTS SECTION START ------------------>


        <!-----------------------------LEAD SCREENER DASHBOARD COUNTS SECTION END ------------------>


        <!-- Sales Summery -->


        <!-- ============================================================== -->


        <!-- ============================================================== -->


        {{-- @if (!auth()->user()->checkPermission('lead-screening-verify') &&
    !auth()->user()->checkPermission('lead-screening-delete')) --}}

        {{--  --}}

        <div class="row">

            <div class="col l10 m8 s12 pad-0 grf-left" style="margin-top:50px;">

                <div class="col l9 m12 s12">
                    <div class="card">


                        <div class="card-content">

                            <!--demo-svg-start-->
                            <div class="round-chart-wrap">



                                <div class="round-chart-artes-right">
                                    @foreach ($leads_by_type as $type)
                                        <a href="{{ url('dashboard/leads/listing/all?project_type_id=' . $type['id']) }}"
                                            class="{{ strtolower($type['name']) }}">{{ $type['count'] }}
                                            {{ $type['name'] }}</a>
                                    @endforeach
                                </div>


                                <div class="round-chart-left">


                                    <div id="leads_by_type_donut_chart">
                                    </div>

                                </div>




                            </div>

                            <!--demo-svg-end-->

                        </div>

                    </div>

                </div>


                <div class="col l3 m12 s12">

                    <div class="card">

                        <div class="card-content">
                            <div class="links-hm-cnter">

                                @foreach ($create_tasks as $index => $type)
                                    @if ($index <= 3)
                                        <a href="{{ url('dashboard/leads/taskindex?task_id=' . $type->id) }}"><span>{{ $allTasks->where('create_task_id', $type->id)->count() }}</span>{{ $type->name }}
                                        </a>
                                    @endif
                                @endforeach
                                {{--
                                <a href="#" class=""><span>10</span> Follow-Up</a>

                                <a href="#" class=""><span>5</span> Site Visit</a>

                                <a href="#" class=""><span>15</span> Appointment</a>

                                <a href="#" class=""><span>10</span> Callback</a> --}}


                            </div>

                        </div>
                    </div>

                </div>


                @if (auth()->user()->hasRole('executive') ||
                    auth()->user()->hasRole('team-leader'))
                    @if ($quarterlyTarget && $quarterlyTarget->my_target)
                        <div class="col l12 m12 s12">


                            <div class="card">

                                <div class="card-content">
                                    {{-- @if (auth()->user()->hasRole('executive') ||
    auth()->user()->hasRole('team-leader'))
                            @if ($quarterlyTarget && $quarterlyTarget->my_target) --}}
                                    {{-- <h3 class="chart-h3">{{ $diffDate }} Days to go</h3> --}}

                                    @if ($achieved < $quarterlyTarget->my_target)
                                        
                                            <?php
                                            $val = ($quarterlyTarget ? $quarterlyTarget->my_target - $achieved : 0) / 10000000;
                                            $val = round($val, 2);
                                            $finalval = $val . 'Cr';
                                            ?>
                                            <h2 class="chart-h2">Achieve {{ $finalval }} More </h2>
                                            <h3 class="chart-h3" >in {{ $diffDate }} Days to hit your target!</h3>
                                    @else
                                        <h2 class="chart-h2">Bravo,You did it ! </h2>
                                    @endif
                                    {{-- <a class="btn modal-trigger" href="#set-target"
                                        style="position: relative;z-index: 2;"><b>Set
                                            Target</b></a>
                             --}}


                                    <div class="graph-bg-wrap">


                                        <div class="graph-bg {{ $chartBg }} ">
                                            <div class="graph-men {{ $achivedMenIcon }}" style="z-index: 2;">
                                                <img src="{{ asset('/images/men-run.png') }}" alt="">
                                                <span>
                                                    <?php
                                                    $valCr = ($achieved ? $achieved : 0) / 10000000;
                                                    $valCr = round($valCr, 2);
                                                    $finalvalCr = $valCr . 'Cr';
                                                    ?>
                                                    {{ $finalvalCr }}

                                                </span>
                                            </div>

                                            <div class="graph-flag {{ $targetFlag }}">
                                                <img src="{{ asset('/images/flag-men.png') }}" alt="">
                                            </div>
                                        </div>

                                    </div>
                                    {{-- @endif
                            @endif --}}
                                </div>

                            </div>
                        </div>
                    @endif
                @endif




                @if (!auth()->user()->hasRole('screener') &&
                    !auth()->user()->hasRole('lead-bank'))
                    <div class="col l12 m12 s12 {{ $quarterlyTarget && $quarterlyTarget->my_target ? 'min-w-120' : '' }}">


                        <div class="card">

                            <div class="card-content"
                                style="{{ $quarterlyTarget && $quarterlyTarget->my_target ? '' : 'min-height: 600px;' }}">


                                <div class="d-flex align-items-center">
                                    <div>
                                        <h5 class="card-title">Unattended Leads</h5>
                                        <!-- <h6 class="card-subtitle">Sales on products we have</h6>-->
                                    </div>

                                    <div class="ml-auto">



                                    </div>


                                </div>

                                @if ($message = Session::get('success'))
                                    <div class="success-alert-bar p-15 m-b-20 green white-text">
                                        {{ $message }}
                                    </div>
                                @endif
                                @if ($message = Session::get('error'))
                                    <div class="error-alert-bar p-15 m-b-20 red white-text">
                                        {{ $message }}
                                    </div>
                                @endif

                                <div class="success-alert-bar p-15 m-b-20 green white-text status unAttendedLeadsTbl_success_msg"
                                    style="display: none;"></div>
                                <div class="error-alert-bar p-15 m-b-20 red white-text status unAttendedLeadsTbl_error_msg"
                                    style="display: none;"></div>
                                {{-- <div class="table-responsive m-b-20"> --}}
                                <table id="unAttendedLeadsTbl" class="responsive-table display nowrap" style="width:100%">
                                    <thead class="tleadview">
                                        <tr>
                                            {{-- <th>
                                                Sl.No
                                            </th> --}}
                                            <th>
                                                Name of Lead
                                            </th>
                                            <th>
                                                Date of Enquiry
                                                {{-- <th>
                                                Email
                                            </th> --}}
                                            <th>
                                                Contact No.
                                            </th>
                                            <th>Stage</th>
                                            <th>
                                                Category
                                            </th>

                                            <th>
                                                Comment
                                            </th>

                                            <th>
                                                Update
                                            </th>
                                            {{-- @endif --}}

                                        </tr>
                                    </thead>
                                    {{-- <tbody id="unAttendedLeadsBody">
    
    
                                    </tbody> --}}
                                </table>
                                {{-- </div> --}}

                                {{-- @if (auth()->user()->checkPermission('listing-lead'))
                                    <a href="{{ url('/dashboard/leads/') }}"><i class="fas fa-angle-right"></i> View All
                                        Leads</a>
                                @endif --}}





                            </div>




                        </div>


                    </div>



                    {{-- <div class="row">
                    <div class="col {{ $quarterlyTarget ? 's12' : 's10' }}" style="margin-top: 0px;">
    
    
                        <div class="card">
    
                            <div class="card-content">
    
    
                                <div class="d-flex align-items-center">
    
    
                                    <div>
    
    
                                        <h5 class="card-title">Todays Tasks</h5>
    
    
    
    
                                    </div>
    
    
                                    <div class="ml-auto">
    
                                        <div style="min-width: 235px;" class="m-b-30">
                                            <select class="browser-default select2" onchange="todayTaskDateFilter()"
                                                id="today_task_date_filter">
                                                <option value="today" class="">Today
                                                </option>
                                                <option value="week" class="">This
                                                    Week</option>
                                                <option value="month" class="">This
                                                    Month</option>
                                                <option value="year" class="">This
                                                    Year</option>
                                            </select>
                                        </div>
    
                                    </div>
    
    
                                </div>
                                <table id="todaysTasksTbl" class="responsive-table display" style="width:100%;">
                                    <thead class="dtleadview">
                                        <tr>
                                        
                                            <th>
                                                Name of Lead
                                            </th>
                                            <th>
                                                Contact No.
                                            </th>
                                            <th>
                                                Date
                                            </th>
    
                                            <th>
                                                Type
                                            </th>
                                            <th>
                                                Project
                                            </th>
    
                                            <th>
                                                Stage
                                            </th>
                                            <th>
                                                Status
                                            </th>
    
    
    
                                        </tr>
                                    </thead>
                                    <tbody>
                     
    
                                    </tbody>
    
    
                                </table>
    
    
                            </div>
    
    
    
    
                        </div>
    
    
                    </div>
    
                </div> --}}
                @endif


                {{-- <div class="col l12 m12 s12 {{ $quarterlyTarget && $quarterlyTarget->my_target ? 'min-w-120' : '' }}"
                    style="margin-top: 0px;">


                    <div class="card">

                        <div class="card-content">


                            <div class="d-flex align-items-center">


                                <div>


                                    <h5 class="card-title">Todays Tasks</h5>



                                </div>


                                <div class="ml-auto">

                                    <div style="min-width: 235px;" class="m-b-30">
                                        <select class="browser-default select2" onchange="todayTaskDateFilter()"
                                            id="today_task_date_filter">
                                            <option value="today" class="">Today
                                            </option>
                                            <option value="week" class="">This
                                                Week</option>
                                            <option value="month" class="">This
                                                Month</option>
                                            <option value="year" class="">This
                                                Year</option>
                                        </select>
                                    </div>

                                </div>


                            </div>
                            <table id="todaysTasksTbl" class="responsive-table display" style="width:100%;">
                                <thead class="dtleadview">
                                    <tr>

                                        <th>
                                            Name of Lead
                                        </th>
                                        <th>
                                            Contact No.
                                        </th>
                                        <th>
                                            Date
                                        </th>

                                        <th>
                                            Type
                                        </th>
                                        <th>
                                            Project
                                        </th>

                                        <th>
                                            Stage
                                        </th>
                                        <th>
                                            Status
                                        </th>



                                    </tr>
                                </thead>
                                <tbody>


                                </tbody>


                            </table>


                        </div>




                    </div>


                </div> --}}




            </div>


            @if (auth()->user()->hasRole('executive') ||
                auth()->user()->hasRole('team-leader'))
                <!--modal-start-->

                <div id="set-target" class="modal">

                    <div class="modal-content">
                        {{-- <h5>Add Lead</h5> --}}
                        <div class="modal-header">
                            <h5 class="modal-title">Set Target for Quarter
                                {{ $quarterlyTarget ? $quarterlyTarget->sales_quarter_name : '' }} -
                                {{-- {{  $quarterlyTarget->quarterly_end_date ? date('Y', strtotime($quarterlyTarget->quarterly_end_date)) : '' }} --}}
                                {{ $quarterlyTarget ? date('Y', strtotime($quarterlyTarget->quarterly_end_date)) : '' }}

                            </h5>
                        </div>

                        <div class="modal-body m-t-30">


                            <form method="post" enctype="multipart/form-data" class="formValidate"
                                id="setMyTargetUpdateForm">
                                {{ csrf_field() }}


                                <input type="hidden" value="{{ $quarterlyTarget ? $quarterlyTarget->id : '' }}"
                                    name="sale_quarter_id" id="sale_quarter_id">
                                <input type="hidden" value="{{ auth()->user()->id }}" name="user_id">






                                <div class="row m-t-40 m-b-20">
                                    <div class="input-field col s12 m-t-30">
                                        <input id="my_target" name="my_target" type="number" class="num"
                                            value="{{ $quarterlyTarget ? $quarterlyTarget->my_target : '' }}">

                                        <label for="my_target" class="active">My Target</label>

                                        <span class="invalid-feedback" role="alert" id="target_my_target_error">

                                        </span>

                                    </div>
                                </div>








                            </form>
                        </div>


                        <div class="modal-footer">
                            <span class="success-alert-bar p-15 m-b-20 green white-text status" style="display: none;"
                                id="success-target"></span>

                            <button class="btn cyan waves-effect waves-light right sub-btn m-l-5" type="submit"
                                name="action" id="setMyTargetSubmitBtn">Update
                                <span class="loading " style="display:none"><img
                                        src="{{ asset('assets/images/loading.gif') }}" class="m-t-10">
                                </span></button>
                            <a href="#!" class="btn modal-action modal-close waves-effect waves-light new-yellow"
                                id="addLeadClearFormData">Cancel</a>
                        </div>
                    </div>
                </div>
                <!--modal-end-->
            @endif


            {{-- {{ $bestTeam['team_leader']->name }} --}}

            <div class="col l2 m4 s12 best-wrp" style="margin-top:50px;">



                <div class="card ">


                    <div class="card-content center-align">
                        <div class="row">

                            @if (!auth()->user()->hasRole('executive'))
                                <div class="col s12">
                                    <ul class="tabs">
                                        <li class="tab col s6"><a
                                                class="{{ auth()->user()->hasRole('executive')? '': 'active' }}"
                                                href="#bestTeamTab" style=";">Team</a></li>

                                        <li class="tab col s6"><a href="#bestUserTab"
                                                class="{{ auth()->user()->hasRole('executive')? 'active': '' }}"
                                                style="">Executives</a>
                                        </li>





                                    </ul>
                                </div>
                            @endif
                            <div id="bestUserTab" class="col s12">
                                <div class="card best-perf">


                                    <div class="card-content center-align">
                                        <span class="card-title activator grey-text text-darken-4">Best Performer</span>

                                        <div class="profile-pic">

                                            @if ($bestPerformer['image'])
                                                <img src="{{ asset('uploads/' . $bestPerformer['image']) }}"
                                                    width="150" height="150px" class="circle"
                                                    alt="best-performer-img">
                                                <span><i class="fas fa-trophy"></i></span>
                                            @else
                                                <img src="{{ asset('uploads/users/profile.jpg') }}" width="150px"
                                                    height="150px" class="circle" alt="best-performer-img">
                                                <span><i class="fas fa-trophy"></i></span>
                                            @endif
                                        </div>
                                        <h5 class="m-t-15 m-b-0 font-medium">{{ $bestPerformer['name'] }}
                                        </h5>
                                        <?php
                                        $val = $bestPerformer['total'] / 100000;
                                        $val = ceil($val);
                                        $finalval = $val . ' lakh';
                                        ?>
                                        <a href="#">{{ $finalval }}</a>


                                    </div>

                                </div>



                                <div class="card perf-emplo">
                                    <div class="card-content">
                                        <div class="message-box">
                                            <div class="message-widget message-scroll">
                                                <!-- Message -->
                                                <div class="comment-widgets scrollable ps ps--theme_default ps--active-y"
                                                    style="{{ auth()->user()->hasRole('executive')? 'height:545px;': 'height:600px;' }}"
                                                    data-ps-id="21132906-9398-d736-3872-e725ffc2159f">
                                                    @foreach ($employeesListByRank as $employee)
                                                        @if ($employee['id'] != auth()->user()->id)
                                                            <a href="javascript:void(0)"
                                                                class="{{ $employee['id'] == auth()->user()->id ? 'active-employee' : '' }}">
                                                                <div class="rank-sml">{{ $loop->index + 2 }}</div>
                                                                @if ($employee['image'])
                                                                    <div class="user-img"> <img
                                                                            src="{{ asset('uploads/' . $employee['image']) }}"
                                                                            alt="user" class="circle"> <span
                                                                            class="profile-status  pull-right"></span>
                                                                    </div>
                                                                @else
                                                                    <div class="user-img"> <img
                                                                            src="{{ asset('uploads/users/profile.jpg') }}"
                                                                            class="circle" alt="user">
                                                                    </div>
                                                                @endif

                                                                <div class="mail-contnet">
                                                                    <h5>{{ $employee['name'] }}</h5>
                                                                    <?php
                                                                    $val = $employee['total'] / 100000;
                                                                    $val = ceil($val);
                                                                    $finalval = $val . ' lakh';
                                                                    
                                                                    ?>
                                                                    @if ($finalval == '0 lakh')
                                                                        <span class="time">
                                                                            <h5>-</h5>
                                                                        </span>
                                                                    @else
                                                                        <span class="time">
                                                                            <h5>{{ $finalval }}</h5>
                                                                        </span>
                                                                    @endif

                                                                </div>
                                                            </a>
                                                        @endif
                                                    @endforeach


                                                    <div class="ps__scrollbar-x-rail" style="left: 0px; bottom: -70px;">
                                                        <div class="ps__scrollbar-x" tabindex="0"
                                                            style="left: 0px; width: 0px;">
                                                        </div>
                                                    </div>
                                                    <div class="ps__scrollbar-y-rail"
                                                        style="top: 70px; height: 560px; right: 0px;">
                                                        <div class="ps__scrollbar-y" tabindex="0"
                                                            style="top: 63px; height: 497px;">
                                                        </div>
                                                    </div>
                                                </div>



                                                @foreach ($employeesListByRank as $employee)
                                                    @if ($employee['id'] === auth()->user()->id)
                                                        <a href="javascript:void(0)" class="active-employee">
                                                            <div class="rank-sml">{{ $loop->index + 2 }}</div>
                                                            @if ($employee['image'])
                                                                <div class="user-img"> <img
                                                                        src="{{ asset('uploads/' . $employee['image']) }}"
                                                                        alt="user" class="circle">
                                                                </div>
                                                            @else
                                                                <div class="user-img"> <img
                                                                        src="{{ asset('uploads/users/profile.jpg') }}"
                                                                        class="circle" alt="user">
                                                                </div>
                                                            @endif

                                                            <div class="mail-contnet">
                                                                <h5>{{ $employee['name'] }}</h5>
                                                                <?php
                                                                $val = $employee['total'] / 100000;
                                                                $val = ceil($val);
                                                                $finalval = $val . ' lakh';
                                                                
                                                                ?>
                                                                @if ($finalval == '0 lakh')
                                                                    <span class="time">
                                                                        <h5>-</h5>
                                                                    </span>
                                                                @else
                                                                    <span class="time">
                                                                        <h5>{{ $finalval }}</h5>
                                                                    </span>
                                                                @endif

                                                            </div>
                                                        </a>
                                                    @endif
                                                @endforeach



                                                {{-- <a href="javascript:void(0)" >
                                            <div class="rank-sml">48</div>
                                            <div class="user-img"> <img src="{{ asset('uploads/users/profile.jpg') }}"
                                                    class="circle" alt="user">
                                            </div>
        
                                            <div class="mail-contnet">
                                                <h5>Miras Hussain</h5>
                                                <span class="time">
                                                    <h5>200 lakh</h5>
                                                </span>
        
                                            </div>
                                        </a> --}}


                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            @if (!auth()->user()->hasRole('executive'))
                                <div id="bestTeamTab" class="col s12">
                                    <div class="card best-perf">


                                        <div class="card-content center-align">
                                            <span class="card-title activator grey-text text-darken-4">Best Team</span>



                                            <div class="profile-pic">



                                                @if ($bestTeamLeader['image'])
                                                    <img src="{{ asset('uploads/' . $bestTeamLeader['image']) }}"
                                                        width="150" height="150px" class="circle"
                                                        alt="best-performer-img">
                                                    <span><i class="fas fa-trophy"></i></span>
                                                @else
                                                    <img src="{{ asset('uploads/users/profile.jpg') }}" width="150px"
                                                        height="150px" class="circle" alt="best-performer-img">
                                                    <span><i class="fas fa-trophy"></i></span>
                                                @endif
                                            </div>
                                            <h5 class="m-t-15 m-b-0 font-medium">{{ $bestTeamLeader['team_leader_name'] }}

                                            </h5>
                                            <?php
                                            $bestTeamVal = $bestTeamLeader['team_dsr'] / 100000;
                                            $bestTeamVal = ceil($bestTeamVal);
                                            $finalbestTeamVal = $bestTeamVal . ' lakh';
                                            ?>
                                            <a href="#">{{ $finalbestTeamVal }}</a>


                                        </div>

                                    </div>


                                    <div class="card perf-emplo">
                                        <div class="card-content">
                                            <div class="message-box">
                                                <div class="message-widget message-scroll">
                                                    <!-- Message -->
                                                    <div class="comment-widgets scrollable ps ps--theme_default ps--active-y"
                                                        style="height:600px;"
                                                        data-ps-id="21132906-9398-d736-3872-e725ffc2159f">
                                                        @foreach ($allOtherLeaders as $leader)
                                                            <a href="javascript:void(0)" class="">
                                                                {{-- {{ $leader['id'] == auth()->user()->id ? 'active-employee' : '' }} --}}
                                                                <div class="rank-sml">{{ $loop->index + 2 }}</div>
                                                                @if ($leader['image'])
                                                                    <div class="user-img"> <img
                                                                            src="{{ asset('uploads/' . $leader['image']) }}"
                                                                            alt="user" class="circle"> <span
                                                                            class="profile-status  pull-right"></span>
                                                                    </div>
                                                                @else
                                                                    <div class="user-img"> <img
                                                                            src="{{ asset('uploads/users/profile.jpg') }}"
                                                                            class="circle" alt="user">
                                                                    </div>
                                                                @endif

                                                                <div class="mail-contnet">
                                                                    <h5>{{ $leader['team_leader_name'] }}</h5>
                                                                    <?php
                                                                    $leaderVal = ($leader['team_dsr'] ? $leader['team_dsr'] : 0) / 100000;
                                                                    $leaderVal = ceil($leaderVal);
                                                                    $finalLeaderVal = $leaderVal . ' lakh';
                                                                    
                                                                    ?>
                                                                    {{-- {{ $leader->getDsr ? $leader->getDsr->agreement_sale_value : 0 }} --}}
                                                                    @if ($finalLeaderVal == '0 lakh')
                                                                        <span class="time">
                                                                            <h5>-</h5>
                                                                        </span>
                                                                    @else
                                                                        <span class="time">
                                                                            <h5>{{ $finalLeaderVal }}</h5>
                                                                        </span>
                                                                    @endif

                                                                </div>
                                                            </a>
                                                        @endforeach


                                                        <div class="ps__scrollbar-x-rail"
                                                            style="left: 0px; bottom: -70px;">
                                                            <div class="ps__scrollbar-x" tabindex="0"
                                                                style="left: 0px; width: 0px;">
                                                            </div>
                                                        </div>
                                                        <div class="ps__scrollbar-y-rail"
                                                            style="top: 70px; height: 560px; right: 0px;">
                                                            <div class="ps__scrollbar-y" tabindex="0"
                                                                style="top: 63px; height: 497px;">
                                                            </div>
                                                        </div>
                                                    </div>


                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        </div>


                        {{-- 
                <div class="card best-perf">
                    

                    <div class="card-content center-align">
                        <span class="card-title activator grey-text text-darken-4">Best Performer</span>

                        <div class="profile-pic">

                            @if ($bestPerformer['image'])
                                <img src="{{ asset('uploads/' . $bestPerformer['image']) }}" width="150"
                                    height="150px" class="circle" alt="best-performer-img">
                                <span><i class="fas fa-trophy"></i></span>
                            @else
                                <img src="{{ asset('uploads/users/profile.jpg') }}" width="150px" height="150px"
                                    class="circle" alt="best-performer-img">
                                <span><i class="fas fa-trophy"></i></span>
                            @endif
                        </div>
                        <h5 class="m-t-15 m-b-0 font-medium">{{ $bestPerformer['name'] }}
                        </h5>
                        <?php
                        $val = $bestPerformer['total'] / 100000;
                        $val = round($val, 2);
                        $finalval = $val . ' lakh';
                        ?>
                        <a href="#">{{ $finalval }}</a>


                    </div>

                </div>


                <div class="card perf-emplo">
                    <div class="card-content">
                        <div class="message-box">
                            <div class="message-widget message-scroll">
                                <!-- Message -->
                                <div class="comment-widgets scrollable ps ps--theme_default ps--active-y"
                                    style="height:610px;" data-ps-id="21132906-9398-d736-3872-e725ffc2159f">
                                    @foreach ($employeesListByRank as $employee)
                                        @if ($employee['id'] != auth()->user()->id)
                                            <a href="javascript:void(0)"
                                                class="{{ $employee['id'] == auth()->user()->id ? 'active-employee' : '' }}">
                                                <div class="rank-sml">{{ $loop->index + 2 }}</div>
                                                @if ($employee['image'])
                                                    <div class="user-img"> <img
                                                            src="{{ asset('uploads/' . $employee['image']) }}"
                                                            alt="user" class="circle"> <span
                                                            class="profile-status  pull-right"></span>
                                                    </div>
                                                @else
                                                    <div class="user-img"> <img
                                                            src="{{ asset('uploads/users/profile.jpg') }}" class="circle"
                                                            alt="user">
                                                    </div>
                                                @endif

                                                <div class="mail-contnet">
                                                    <h5>{{ $employee['name'] }}</h5>
                                                    <?php
                                                    $val = $employee['total'] / 100000;
                                                    $val = round($val, 2);
                                                    $finalval = $val . ' lakh';
                                                    
                                                    ?>
                                                    @if ($finalval == '0 lakh')
                                                        <span class="time">
                                                            <h5>-</h5>
                                                        </span>
                                                    @else
                                                        <span class="time">
                                                            <h5>{{ $finalval }}</h5>
                                                        </span>
                                                    @endif

                                                </div>
                                            </a>
                                        @endif
                                    @endforeach


                                    <div class="ps__scrollbar-x-rail" style="left: 0px; bottom: -70px;">
                                        <div class="ps__scrollbar-x" tabindex="0" style="left: 0px; width: 0px;">
                                        </div>
                                    </div>
                                    <div class="ps__scrollbar-y-rail" style="top: 70px; height: 560px; right: 0px;">
                                        <div class="ps__scrollbar-y" tabindex="0" style="top: 63px; height: 497px;">
                                        </div>
                                    </div>
                                </div>



                                @foreach ($employeesListByRank as $employee)
                                    @if ($employee['id'] === auth()->user()->id)
                                        <a href="javascript:void(0)" class="active-employee">
                                            <div class="rank-sml">{{ $loop->index + 2 }}</div>
                                            @if ($employee['image'])
                                                <div class="user-img"> <img
                                                        src="{{ asset('uploads/' . $employee['image']) }}" alt="user"
                                                        class="circle">
                                                </div>
                                            @else
                                                <div class="user-img"> <img
                                                        src="{{ asset('uploads/users/profile.jpg') }}" class="circle"
                                                        alt="user">
                                                </div>
                                            @endif

                                            <div class="mail-contnet">
                                                <h5>{{ $employee['name'] }}</h5>
                                                <?php
                                                $val = $employee['total'] / 100000;
                                                $val = round($val, 2);
                                                $finalval = $val . ' lakh';
                                                
                                                ?>
                                                @if ($finalval == '0 lakh')
                                                    <span class="time">
                                                        <h5>-</h5>
                                                    </span>
                                                @else
                                                    <span class="time">
                                                        <h5>{{ $finalval }}</h5>
                                                    </span>
                                                @endif

                                            </div>
                                        </a>
                                    @endif
                                @endforeach



                            </div>
                        </div>
                    </div>
                </div> --}}


                    </div>
                </div>

            </div>








        </div>






        @if (!auth()->user()->hasRole('screener') &&
            !auth()->user()->hasRole('lead-bank'))
            <div class="row">
                <div class="col s12" style="margin-top: 0px;">


                    <div class="card">

                        <div class="card-content">


                            <div class="d-flex align-items-center">


                                <div>


                                    <h5 class="card-title">Todays Tasks</h5>




                                </div>


                                <div class="ml-auto">

                                    <div style="min-width: 235px;" class="m-b-30">
                                        <select class="browser-default select2" onchange="todayTaskDateFilter()"
                                            id="today_task_date_filter">
                                            <option value="today" class="">Today
                                            </option>
                                            <option value="week" class="">This
                                                Week</option>
                                            <option value="month" class="">This
                                                Month</option>
                                            <option value="year" class="">This
                                                Year</option>
                                        </select>
                                    </div>

                                </div>


                            </div>
                            <table id="todaysTasksTbl" class="responsive-table display" style="width:100%;">
                                <thead class="dtleadview">
                                    <tr>

                                        <th>
                                            Name of Lead
                                        </th>
                                        <th>
                                            Contact No.
                                        </th>
                                        <th>
                                            Date
                                        </th>

                                        <th>
                                            Type
                                        </th>
                                        <th>
                                            Project
                                        </th>

                                        <th>
                                            Stage
                                        </th>
                                        <th>
                                            Status
                                        </th>



                                    </tr>
                                </thead>
                                <tbody>


                                </tbody>


                            </table>


                        </div>




                    </div>


                </div>

            </div>
        @endif


    </div>


    </div>
    <div id="taskCompletionModal" class="modal">
        <div class="modal-dialog">
            <form method="post" action="" enctype="multipart/form-data" class="formValidate"
                id="todayTaskCompletionForm">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Task Completion Status</h5>
                        <br>
                    </div>
                    <div class="modal-body">


                        <input type="hidden" value="" id="task_id">

                        <div class="row">
                            <div class="input-field col 112 s12">
                                <select name="task_completed_status" id="task_completed_status"
                                    class="browser-default select2">
                                    <option value="">Choose your option</option>
                                    <option value="1" selected>Completed</option>
                                    <option value="0">Not Completed</option>

                                </select>
                                <label for="task_completed_status" id="" class=""> Status<span
                                        class="red-star">*</span></label>
                                <span id="task_completed_status_error" class="error"></span>
                            </div>
                        </div>

                        <div class="row m-t-10">


                            <div class="input-field col s12">
                                <textarea name="task_completion_remarks" id="task_completion_remarks" class="materialize-textarea"></textarea>
                                <label for="task_completion_remarks">Remarks<span class="red-star">*</span></label>
                                <span id="task_completion_remarks_error" class="error"></span>
                            </div>


                        </div>




                    </div>


                    <div class="modal-footer">
                        <span class="success-alert-bar p-15 m-b-20 green white-text status-task-completion-home"
                            style="display: none;"></span>

                        <button class="btn cyan waves-effect waves-light right sub-btn-task-completion m-l-5"
                            type="submit">Submit
                            <span class="loading" style="display:none"><img
                                    src="{{ asset('assets/images/loading.gif') }}" class="m-t-10">
                            </span>
                        </button>
                        <a href="#!"
                            class="btn modal-action modal-close waves-effect waves-light grey darken-4">Cancel</a>
                    </div>
            </form>
        </div>
    </div>
    <!--Lead Verify  Modal Start---->
    <div id="verifyLeadModal" class="modal">
        <div class="modal-dialog">
            <form method="post" action="{{ route('lead.verify') }}" enctype="multipart/form-data"
                class="formValidate">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Verify Lead</h5>
                        <br>
                    </div>
                    <div class="modal-body">
                        <div id="agent_modal_body">


                        </div>
                    </div>


                    <div class="modal-footer">
                        <span class="success-alert-bar p-15 m-b-20 green white-text status" style="display: none;"></span>

                        <button class="btn cyan waves-effect waves-light right sub-btn-sales m-l-5" type="submit">Submit
                            <span class="loading" style="display:none"><img
                                    src="{{ asset('assets/images/loading.gif') }}" class="m-t-10">
                            </span>
                        </button>
                        <a href="#!"
                            class="btn modal-action modal-close waves-effect waves-light grey darken-4">Cancel</a>
                    </div>
            </form>
        </div>
    </div>
    <div id="addNewTaskLeadMakerModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Create Task</h5>
                <br>
            </div>

            <div class="row">

                <form method="post" action="" enctype="multipart/form-data" class="formValidate" id="taskForm"
                    name="taskForm">
                    {{ csrf_field() }}

                    <input type="hidden" name="lead_id" id="lead_id" value="">
                    {{-- <div class="row"> --}}

                    <div class="input-field col 16 m6 s12">
                        <label for="f_create_task_id">Select Task<span class="red-star">*</span></label>
                        <select name="f_create_task_id" id="f_create_task_id" class="browser-default select2 create_task"
                            onchange="taskTypeChange()">
                            <option value="">Choose your option</option>
                            @foreach ($create_tasks as $ct)
                                <option value="{{ $ct->id }}">
                                    {{ $ct->name }}
                                </option>
                            @endforeach
                        </select>
                        <span id="f_create_task_id_error" class="error"></span>
                    </div>


                    <div class="input-field col 16 m6 s12" id="followUpByDiv">
                        <select name="f_followup_by" id="f_followup_by" class="browser-default select2">
                            <option value="">Choose your option</option>
                            @foreach ($salesperson as $sp)
                                <option value="{{ $sp->id }}">
                                    {{ $sp->name }}
                                </option>
                            @endforeach
                        </select>
                        <label for="f_followup_by">Follow-up By<span class="red-star">*</span></label>
                        <span id="f_followup_by_error" class="error"></span>
                    </div>


                    <div class="input-field col 16 m6 s12" id="leadCategoryDiv">
                        <select name="f_lead_category" id="f_lead_category" class="browser-default select2">
                            <option value="">Choose your option</option>
                            @foreach ($lead_categories as $lc)
                                <option value="{{ $lc->id }}">
                                    {{ $lc->name }}
                                </option>
                            @endforeach
                        </select>
                        <label for="f_lead_category">Lead Category<span class="red-star">*</span></label>
                        <span id="f_lead_category_error" class="error"></span>
                    </div>


                    {{-- </div> --}}

                    {{-- <div class="row"> --}}
                    <div class="input-field col 16 m6 s12" id="intrestedProjectDiv">
                        <select name="f_project" id="f_project" class="browser-default select2">
                            <option value="">Choose your option</option>
                            @foreach ($pref_projects as $pp)
                                <option value="{{ $pp['id'] }}">
                                    {{ $pp['project_name'] }}
                                </option>
                            @endforeach
                        </select>
                        <label for="f_project">Project Interested<span class="red-star">*</span></label>
                        <span id="f_project_error" class="error"></span>
                    </div>

                    <div class="input-field col 16 m6 s12" id="followUpTypeDiv">
                        <select name="f_followup_type" id="f_followup_type" class="browser-default select2">
                            <option value="">Choose your option</option>
                            @foreach ($followup_types as $ft)
                                <option value="{{ $ft->id }}">
                                    {{ $ft->name }}
                                </option>
                            @endforeach
                        </select>
                        <label for="f_followup_type">Follow-up Type<span class="red-star">*</span></label>
                        <span id="f_followup_type_error" class="error"></span>
                    </div>

                    <div class="input-field col 16 m6 s12" id="scheduleDateDiv">
                        <input id="f_schedule_date" name="f_schedule_date" type="text" class="datepicker1">
                        <label for="f_schedule_date">Schedule Date<span class="red-star">*</span></label>
                        <span id="f_schedule_date_error" class="error"></span>
                    </div>


                    {{-- </div> --}}

                    {{-- <div class="row"> --}}

                    <div class="input-field col 16 m6 s12" id="scheduleTimeDiv">
                        <input id="f_schedule_time" name="f_schedule_time" type="text" class="pickatime timepicker">
                        <label for="f_schedule_time">Time<span class="red-star">*</span></label>
                        <span id="f_schedule_time_error" class="error"></span>
                    </div>


                    <div class="input-field col 16 m6 s12" id="reminderDateDiv">
                        <input id="f_reminder_date" name="f_reminder_date" type="text" class="datepicker1">
                        <label for="f_reminder_date">Reminder Date
                            {{-- <span
                                class="red-star">*</span> --}}
                        </label>
                        <span id="f_reminder_error" class="error"></span>
                    </div>


                    <div class="input-field col 16 m6 s12" id="leadStageDiv">
                        <select name="f_lead_stage" id="f_lead_stage" class="browser-default select2">
                            <option value="">Choose your option</option>
                            @foreach ($lead_stages as $ls)
                                <option value="{{ $ls->id }}">
                                    {{ $ls->name }}
                                </option>
                            @endforeach
                        </select>
                        <label for="f_lead_stage">Lead Stage<span class="red-star">*</span></label>
                        <span id="f_lead_stage_error" class="error"></span>
                    </div>


                    <div class="input-field col l6 m6 s12" id="budgetDiv">
                        <select name="f_budget" id="f_budget" class=" browser-default select2">fmplo
                            <option value="">Select</option>
                            @foreach ($budgets as $b)
                                <option value="{{ $b->id }}">
                                    {{ $b->name }}
                                </option>
                            @endforeach
                        </select>
                        <label for="f_budget">Budget</label>
                        <span id="f_budget_error" class="error"></span>
                    </div>

                    {{-- </div> --}}

                    <div class="row" id="remarksDiv" style="margin:0px 2px 0px 2px;">
                        <div class="input-field col s12">
                            <textarea name="f_remarks" id="f_remarks" class="materialize-textarea"></textarea>
                            <label for="f_remarks">Description<span class="red-star">*</span></label>
                            <span id="f_remarks_error" class="error"></span>
                        </div>
                    </div>

                </form>


                <div class="modal-footer">
                    <span class="success-alert-bar p-15 m-b-20 green white-text status-t" style="display: none;"></span>

                    <button class="btn cyan waves-effect waves-light right sub-btn-task-leads-maker m-l-5" type="submit"
                        name="action">Submit
                        <span class="loading" style="display:none"><img src="{{ asset('assets/images/loading.gif') }}"
                                class="m-t-10"></span>
                    </button>
                    <a href="#!"
                        class="btn modal-action modal-close waves-effect waves-light grey darken-4">Cancel</a>
                </div>


            </div>
        </div>

    </div>
    <div id="leadDeleteModal" class="modal">
        <div class="modal-dialog">
            <form method="post" action="" enctype="multipart/form-data" class="formValidate">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Delete Lead</h5>
                        <br>
                    </div>
                    <div class="modal-body">
                        <div id="lead_delete_modal_body">


                        </div>
                    </div>


                    <div class="modal-footer">
                        <span class="success-alert-bar p-15 m-b-20 green white-text status leadDelMsg"
                            style="display: none;"></span>

                        <button class="btn cyan waves-effect waves-light right sub-btn m-l-5" type="button"
                            id="deleteLeadId">Submit
                            <span class="loading" style="display:none" id="leadDeleteLoading"><img
                                    src="{{ asset('assets/images/loading.gif') }}" class="m-t-10">
                            </span>
                        </button>
                        <a href="#!"
                            class="btn modal-action modal-close waves-effect waves-light grey darken-4">Cancel</a>
                    </div>
            </form>
        </div>
    </div>



    <!--Lead Verify Modal End --->



    {{-- @if (!\Auth::user()->hasRole('maker') || !\Auth::user()->hasRole('screener')) --}}
    {{-- @if (!auth()->user()->checkPermission('leads-maker') &&
    !auth()->user()->checkPermission('lead-screening-verify') &&
    !auth()->user()->checkPermission('lead-screening-delete')) --}}

    @if (!auth()->user()->hasRole('screener') &&
        !auth()->user()->hasRole('maker'))
        <div class="row">


            <div class="col s12">


                <div class="card">


                    <div class="card-content">


                        <div class="d-flex align-items-center">


                            <div>


                                <h5 class="card-title">Sales Quarter</h5>


                            </div>
                        </div>


                        {{-- <div class="table-responsive m-b-20"> --}}
                        <table id="zero_config_s" class="responsive-table display" style="width:100%; ">
                            <thead class="dtleadview">
                                <tr>

                                    @if (!\Auth::user()->hasRole('user') && \Auth::user()->id != 12)
                                        <th>
                                            AGM Monthly Target
                                        </th>
                                        <th>
                                            AGM Quarterly Target
                                        </th>
                                    @endif
                                    <th>
                                        Sales Officer Monthly Target
                                    </th>
                                    <th>
                                        Sales Officer Quarterly Target
                                    </th>
                                    <th>
                                        Name
                                    </th>


                                </tr>
                            </thead>
                            <tbody>
                                @if ($currentSalesQuarter)
                                    <tr id="s_{{ $currentSalesQuarter->id }}">
                                        @if (!\Auth::user()->hasRole('user'))
                                            <td>{{ $currentSalesQuarter->team_leader_monthly_target }}</td>
                                            <td>{{ $currentSalesQuarter->team_leader_yearly_target }}</td>
                                        @endif
                                        <td>{{ $currentSalesQuarter->user_monthly_target }}</td>
                                        <td>{{ $currentSalesQuarter->user_yearly_target }}</td>

                                        <td>{{ $currentSalesQuarter->sales_quarter_name }}</td>


                                    </tr>
                                @endif

                            </tbody>
                        </table>
                        {{-- </div> --}}


                    </div>


                </div>


            </div>


        </div>
    @endif
    {{-- @endif --}}


    <!-- ============================================================== -->


    <!-- Recent comment and chats -->


    <!-- ============================================================== -->


    </div>





    <!--incentive calculator-start--->


    @if (auth()->user()->checkPermission('incentive-calculator'))
        <a href="#modal3"
            class="sidenav-trigger right-side-toggle btn-large waves-effect waves-light new-yellow modal-trigger p-b-30 p-t-0"
            data-target="modal3" style="background-color: #be9833;">Incentive calculator</a>



        <div id="modal3" class="modal bottom-sheet">
            <div class="modal-content">
                <h5 class="header">Quarterly Incentive Calculation</h5>

                <div class="row m-t-30">
                    {{-- <div class="input-field col s2">
                       <label>
                           <input name="group1" type="radio" onchange="getUserTarget(this)"
                               value="monthly" />
                           <span>Monthly</span>
                       </label>
                   </div> --}}
                    <div class="input-field col s2" style="display: none;">
                        <label>
                            <input name="group1" type="radio" onchange="getUserTarget(this)" value="quarterly"
                                id="qtry_value" />
                            <span>Quarterly </span>
                        </label>
                    </div>


                    <span id="no_target_amount_error" style="color: rgb(214, 28, 28)"></span>

                </div>



                <div class="row m-t-10">

                    <div class="input-field col s12 m12">

                        <input id="target_amount" type="number" name="target" required autocomplete="off" readonly>
                        <label for="target">Quarterly Target<span class="red-star"></span></label>

                        <span class="invalid-feedback" role="alert" id="incentive_target_amount_error"
                            style="color: rgb(214, 28, 28)">
                        </span>

                    </div>


                </div>

                <div class="row">
                    <div class="input-field col s12 m12">
                        <input id="achieved_amount" type="number" name="achieved" required autocomplete="off">
                        <label for="achieved">Expected amount to be achieve<span class="red-star"></span></label>
                        <span class="invalid-feedback" role="alert" id="incentive_achieved_amount_error"
                            style="color: rgb(214, 28, 28)">
                        </span>
                    </div>
                </div>

                <div class="row m-l-10 p-t-5">
                    <h6 class="" style="font-weight: bold; color:rgb(8, 95, 8)"><span id="incentive_amount"></span>
                    </h6>
                </div>




                <div class="row">
                    <span id="failed_error_message" style="color: rgb(214, 28, 28)" class="m-l-10"></span>
                    <div class="input-field col s12" style="top: -10px; bottom:0px;">
                        <button class="btn new-yellow waves-effect waves-light right "
                            onclick="calculateIncentive()">Calculate
                        </button>
                    </div>
                </div>

            </div>


        </div>
    @endif

    <!--incentive calculator-end--->









@endsection
@section('js')
    <script>
        $(document).ready(function() {
            $('#f_project').val(1).change();



            var quarterlyTarget = {!! json_encode($quarterlyTarget) !!}

            if (quarterlyTarget && !quarterlyTarget.my_target) {
                $('#set-target').modal('open');
            }






            $('.dropdown-trigger').dropdown();


            $('.select2').each(function() {
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent()
                });
            });

            $('.datepicker1').datepicker({
                // format: "dd-mm-yyyy",
                format: "yyyy-mm-dd",
                // maxDate: today,
                showClearBtn: true,

                container: 'body',
            });

            $('#qtry_value').val('quarterly').change();


            taskTable.draw();

            getUnAttendedLeadsTbl.draw();










        });




        var taskTable = $('#todaysTasksTbl').DataTable({



            processing: true,



            serverSide: true,
            lengthChange: false,
            searching: false,
            // info: false,



            paging: false,

            searching: false,
            info: false,

            order: [
                [6, 'asc']
            ],



            ajax: {



                url: "{{ route('dashboard.todayTaskList') }}",


                data: function(d) {
                    var filter_dates = $('#today_task_date_filter').val();


                    d.filter_dates = filter_dates;


                }

            },


            columns: [



                // {
                //     data: 'DT_RowIndex',
                //     name: 'DT_RowIndex',
                //     orderable: false,
                //     searchable: false
                // },



                {
                    data: 'name_of_lead',
                    name: 'getLead.enquirer_name',
                    orderable: false,

                },

                {
                    data: 'phone_no',
                    name: 'getLead.mobile',
                    orderable: false,


                },



                {
                    data: 'schedule_date',
                    name: 'schedule_date'
                },



                {
                    data: 'task_type',
                    name: 'getTaskType.name'
                },



                {
                    data: 'project',
                    name: 'getProject.project_name'
                },



                {
                    data: 'lead_stage',
                    name: 'getLeadStage.name',

                },










                {
                    data: 'task_completed_status',
                    name: 'task_completed_status',

                    searchable: false
                },



            ],



            "drawCallback": function(settings) {



                $('.dropdown-trigger').dropdown();



            }



        });





        function getUserTarget(src) {
            $('#incentive_amount').text('');
            $('#no_target_amount_error').text('');
            $('#failed_error_message').text('');

            $('#achieved_amount').val('');

            $('#incentive_target_amount_error').text('');
            $('#incentive_achieved_amount_error').text('');

            var type = src.value;
            $.ajax({
                url: "{{ route('incentive.getTarget') }}",
                type: "get",
                data: {
                    type: type,
                },
                success: function(response) {

                    if (response == '') {
                        $('#no_target_amount_error').text('No targets found !');
                    }
                    if (type == "monthly") {
                        $('#target_amount').val(response.monthly_target_amount)
                    } else if (type == "quarterly") {
                        $('#target_amount').val(response.quarterly_target_amount)
                    } else {
                        $('#target_amount').val('')
                    }
                },
                error: function(xhr) {

                }
            });


        }


        function calculateIncentive() {
            var target_amount = $('#target_amount').val();
            var achieved_amount = $('#achieved_amount').val();
            $('#failed_error_message').text('');

            $.ajax({
                url: "{{ route('incentive.calculate') }}",
                type: "POST",
                data: {
                    _token: '{{ csrf_token() }}',
                    target_amount: target_amount,
                    achieved_amount: achieved_amount,
                },
                success: function(response) {

                    if (response.status == true) {
                        $('#incentive_amount').text('Your incentive amount will be RS.  ' + response
                            .incentiveAmount + '/-');
                    } else if (response.status == false) {
                        $('#failed_error_message').text(response.message);
                        $('#incentive_amount').text('');
                    } else {
                        $('#incentive_amount').text('');
                    }

                },
                error: function(xhr) {

                    $.each(xhr.responseJSON.errors, function(key, value) {
                        $("#incentive_" + key + "_error").text(value[0]);
                    });

                }
            });


        }


        //task-type-change-action
        function taskTypeChange() {

            $('#f_remarks').val('');
            $('#f_budget').val('').change();
            $('#f_lead_stage').val('').change();
            $('#f_schedule_time').val('').change();
            $('#f_schedule_date').val('').change();
            $('#f_reminder_date').val('').change();
            $('#f_followup_type').val('').change();
            $('#f_project').val('').change();
            $('#f_lead_category').val('').change();
            $('#f_followup_by').val('').change();


            //1-follow-up
            //2-Site-Vist
            //3-Appointment
            //4-Callback
            //5-Lost
            var task_type = $('#f_create_task_id').val();

            //Site-Vist
            if (task_type == 2) {
                $('#followUpTypeDiv').hide();
                $('#followUpByDiv').show();
                $('#leadCategoryDiv').show();
                $('#intrestedProjectDiv').show();
                $('#leadStageDiv').show();
                $('#budgetDiv').show();
                $('#scheduleTimeDiv').show();
                $('#scheduleDateDiv').show();
                $('#reminderDateDiv').show();


                $('#remarksDiv').show();

                // $('#intrestedProjectDiv').toggleClass('l4 m4 l6 m6');
                // $('#scheduleDateDiv ').toggleClass('l4 m4 l6 m6');

            } else if (task_type == 3 || task_type == 4) {

                $('#followUpTypeDiv').hide();
                $('#followUpByDiv').hide();
                $('#leadStageDiv').hide();
                $('#budgetDiv').hide();
                $('#leadCategoryDiv').hide();
                $('#intrestedProjectDiv').hide();


                $('#scheduleTimeDiv').show();
                $('#scheduleDateDiv').show();
                $('#reminderDateDiv').show();
                $('#remarksDiv').show();

            } else if (task_type == 5) {


                $('#followUpTypeDiv').hide();
                $('#followUpByDiv').hide();
                $('#leadCategoryDiv').hide();
                $('#intrestedProjectDiv').hide();
                $('#leadStageDiv').hide();
                $('#budgetDiv').hide();
                $('#scheduleTimeDiv').hide();
                $('#scheduleDateDiv').hide();
                $('#reminderDateDiv').hide();

                $('#remarksDiv').show();

            } else {
                $('#followUpTypeDiv').show();
                $('#followUpByDiv').show();
                $('#leadCategoryDiv').show();
                $('#intrestedProjectDiv').show();
                $('#leadStageDiv').show();
                $('#budgetDiv').show();
                $('#scheduleTimeDiv').show();
                $('#scheduleDateDiv').show();
                $('#reminderDateDiv').show();
                $('#remarksDiv').show();
            }

        }



        $(".card").on('click', '#addNewTaskLeadMaker', function(e) {

            var ele = $(this);


            $('#lead_id').val(ele.attr("data-id"));

        });


        $('.sub-btn-task-leads-maker').on('click', function(e) {


            $('.status-t').hide();


            $('.error').html('');


            e.preventDefault();


            $.ajax({


                url: '{{ url('/dashboard/leads/tasks/store') }}',


                method: "post",


                // data: $('#taskForm').serialize(),
                data: {
                    _token: '{{ csrf_token() }}',
                    lead_id: $('#lead_id').val(),
                    create_task_id: $('#f_create_task_id').val(),
                    followup_by: $('#f_followup_by').val(),
                    lead_category: $('#f_lead_category').val(),
                    followup_type: $('#f_followup_type').val(),
                    schedule_date: $('#f_schedule_date').val(),
                    reminder: $('#f_reminder_date').val(),
                    schedule_time: $('#f_schedule_time').val(),
                    project: $('#f_project').val(),
                    lead_stage: $('#f_lead_stage').val(),
                    remarks: $('#f_remarks').val(),
                    budget: $('#f_budget').val(),

                },


                dataType: "json",


                beforeSend: function() {


                    $('.loading').show();

                    $('.sub-btn-task-leads-maker').prop('disabled', true);


                },


                success: function(response) {

                    console.log(response);


                    $('.loading').hide();

                    $('.sub-btn-task-leads-maker').prop('disabled', false);


                    // $("#taskForm")[0].reset();

                    $('.status-t').show();

                    $('.status-t').html(response.message);
                    window.location.reload();


                },


                error: function(response) {

                    $('.loading').hide();

                    $('.sub-btn-task-leads-maker').prop('disabled', false);

                    $.each(response.responseJSON.errors, function(key, value) {
                        $("#f_" + key + "_error").text(value[0]);
                        console.log(key);
                    });


                }


            });


        });


        function sendToAllocation(id) {
            if (confirm("Are you sure Send lead for Allocation ?")) {
                $.ajax({
                    url: '{{ route('leads-maker.sendToAllocation') }}',
                    method: "POST",
                    data: {
                        _token: '{{ csrf_token() }}',
                        id: id,
                    },

                    success: function(response) {
                        $('#success_message').html('');
                        $('#error_message').html('');
                        if (response.status == true) {
                            $('#error_message').html('');
                            $('#success_message').html('');
                            $('#success_message').html(
                                '<div class="error-alert-bar p-15 m-b-20 green white-text">' +
                                response.message + '</div>');

                            window.location.reload();
                        } else {
                            $('#error_message').html(
                                '<div class="error-alert-bar p-15 m-b-20 red white-text">' +
                                response.message + '</div>');
                        }
                    }
                });
            }
        }


        function deleteLeadModal(id) {
            // $('#TicketAssignModal').modal('open');
            jQuery.ajax({
                url: "{{ url('dashboard/leads/deleteLeadModal') }}/" + id,
                method: 'get',
                dataType: "json",
                success: function(result) {
                    $('#lead_delete_modal_body').html(result.data);
                    $('#leadDeleteModal').modal('open');

                },
                error: function(error) {
                    console.log(error);
                }
            });
        }



        function deleteLeadMakerModal(id) {
            // $('#TicketAssignModal').modal('open');
            jQuery.ajax({
                url: "{{ url('dashboard/leads/deleteLeadModal') }}/" + id,
                method: 'get',
                dataType: "json",
                success: function(result) {
                    $('#lead_delete_modal_body').html(result.data);
                    $('#leadDeleteModal').modal('open');

                },
                error: function(error) {
                    console.log(error);
                }
            });
        }


        $('#deleteLeadId').on('click', function(e) {
            e.preventDefault();

            var remarks = $('#delete_remarks').val();
            var id = $('#leadId').val();
            // if(remarks != ''){
            $.ajax({
                url: '{{ url('/dashboard/leads/delete-lead') }}',
                method: "DELETE",
                data: {
                    _token: '{{ csrf_token() }}',
                    id: id,
                    delete_remarks: remarks,
                },

                beforeSend: function() {
                    $('#leadDeleteLoading').show();
                    $('#deleteLeadId').prop('disabled', true);
                },

                error: function(xhr) {
                    $('#delete_remarks_error').html('');
                    $.each(xhr.responseJSON.errors, function(key, value) {
                        $('#delete_remarks_error').append('<div class="alert alert-danger">' +
                            value + '</div');
                    });

                    $('#leadDeleteLoading').hide();
                    $('#deleteLeadId').prop('disabled', false);
                },
                success: function(response) {

                    $('#leadDeleteLoading').hide();
                    $('#deleteLeadId').prop('disabled', false);

                    $('.leadDelMsg').show();
                    $('.leadDelMsg').html(response.msg);
                    window.location.reload();
                }
            });

            // }else{
            //     alert('Please provide remarks/reason for lead delete !');
            // }
        })
        $(document).on('click', '.changeLeadTaskStatus', function(e) {
            e.preventDefault();
            $('.status-task-completion-home').hide();
            $('.status-task-completion-home').html('');







            $('#taskCompletionModal').modal('open')
            $('#task_id').val($(this).attr("data-id"));

            var status = $(this).attr("status");
            $('#task_completed_status').val(status).change();


            var remarks = $(this).attr("remarks");
            $('#task_completion_remarks').val(remarks);

        });


        // function test(id) {
        //     $('#taskCompletionModal').modal('open')
        //     $('#task_id').val(id);
        // }

        $('.sub-btn-task-completion').on('click', function(e) {
            var id = $('#task_id').val();



            e.preventDefault();


            $.ajax({

                url: '{{ url('/dashboard/leads/tasks/update-task-completed-status') }}',

                method: "post",

                data: {
                    _token: '{{ csrf_token() }}',
                    task_id: id,
                    task_completed_status: $('#task_completed_status').val(),
                    task_completion_remarks: $('#task_completion_remarks').val(),
                },

                dataType: "json",

                beforeSend: function() {

                },

                success: function(response) {



                    $('.status-task-completion-home').show();

                    $('.status-task-completion-home').html(response.message);
                    // window.location.reload();

                    // alert(response.msg);

                    // $('#task_table').DataTable().ajax.reload();

                    $('#taskCompletionModal').modal('close');
                    $("#todayTaskCompletionForm")[0].reset();
                    taskTable.draw();




                }

            });


        })



        function verifyLead(id) {
            // $('#TicketAssignModal').modal('open');
            jQuery.ajax({
                url: "{{ url('dashboard/leads/leadVerifyModal') }}/" + id,
                method: 'get',
                dataType: "json",
                success: function(result) {
                    $('#agent_modal_body').html(result.data);
                    $('#verifyLeadModal').modal('open');

                },
                error: function(error) {
                    console.log(error);
                }
            });
        }

        // $('#zero_config2').dataTable({
        //     "paging": true,
        //     "searching": true,
        //     "info": false,
        //     "columnDefs": [{
        //         "orderable": true,
        //         "targets": [0, 1, 2, 3]
        //     }]
        // });




















        $('#zero_config3').dataTable({
            "paging": false,
            "searching": false,
            "info": false,
            "columnDefs": [{
                "orderable": false,
                "targets": [0, 1, 2, 3]
            }]
        });
        $('#zero_config_t').dataTable({
            "paging": true,
            "searching": true,
            "info": true,
            "columnDefs": [{
                "orderable": false,
                "targets": [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
            }]
        });
        $('#zero_config_s').dataTable({
            "paging": true,
            "searching": true,
            "info": true,
            "columnDefs": [{
                "orderable": false,
                "targets": [0, 1, 2, 3, 4]
            }]
        });

        function todayTaskDateFilter() {

            // var dates = $('#today_task_date_filter').val();
            taskTable.draw();


        }


        $(document).on('click', '.is_attended_btn', function(e) {


            // $('.is_attended_btn').on('click', function(e) {

            var id = $(this).attr('data-id');


            e.preventDefault();
            $.ajax({
                url: "{{ route('lead.addComment') }}",
                method: "post",
                data: {
                    _token: '{{ csrf_token() }}',

                    lead_id: id,

                    ua_category: $('#ua_category' + id).val(),
                    ua_stage: $('#ua_stage' + id).val(),
                    ua_comment: $('#ua_comment' + id).val(),



                },
                dataType: "json",
                // beforeSend: function() {

                // },
                success: function(response) {


                    if (response.status == true) {
                        $('.unAttendedLeadsTbl_success_msg').show();
                        $('.unAttendedLeadsTbl_success_msg').html(response.message);
                        getUnAttendedLeadsTbl.draw();


                        $('.unAttendedLeadsTbl_success_msg').delay(1000).fadeOut();

                    }

                    if (response.status == false) {
                        $('.unAttendedLeadsTbl_error_msg').show();
                        $('.unAttendedLeadsTbl_error_msg').html(response.message);
                        getUnAttendedLeadsTbl.draw();


                        $('.unAttendedLeadsTbl_error_msg').delay(1000).fadeOut();

                    }






                },

                error: function(response) {

                    $.each(response.responseJSON.errors, function(key, value) {
                        $("#unAttented_" + key + "_error").text(value[0]);
                    });

                },

            });

        });



        var getUnAttendedLeadsTbl =

            $('#unAttendedLeadsTbl').DataTable({

                processing: true,
                serverSide: true,
                // pageLength: 5,
                paging: false,
                lengthChange: false,
                responsive: true,
                scrollX: false,
                searching: false,
                info: false,

                ajax: {
                    url: "{{ route('lead.getUnAttendedLeads') }}",

                },
                columns: [
                    // {
                    //     data: 'DT_RowIndex',
                    //     name: 'DT_RowIndex',
                    //     orderable: false,
                    //     searchable: false
                    // },
                    {
                        data: 'enquirer_name',
                        name: 'enquirer_name'
                    },
                    {
                        data: 'created_at',
                        name: 'created_at'
                    },
                    {
                        data: 'mobile',
                        name: 'mobile'
                    },
                    {
                        data: 'stage',
                        name: 'stage'
                    },
                    {
                        data: 'category',
                        name: 'category'
                    },
                    {
                        data: 'comment',
                        name: 'comment'
                    },

                    {
                        data: 'action',
                        name: 'action',
                        searchable: false,
                        orderable: false,
                    },
                ],
                "drawCallback": function(settings) {
                    //alert( 'DataTables has redrawn the table' );
                    $('.dropdown-trigger').dropdown();
                },
                lengthMenu: [5, 10, 25, 50, 75, 100]
            });






        $('#setMyTargetSubmitBtn').on('click', function(e) {

            e.preventDefault();
            $.ajax({
                url: '{{ route('salequarter.updatesale') }}',
                method: "post",
                data: {
                    _token: '{{ csrf_token() }}',
                    sale_quarter_id: $('#sale_quarter_id').val(),
                    my_target: $('#my_target').val(),

                },
                dataType: "json",
                // beforeSend: function() {

                // },
                success: function(response) {


                    $("#setMyTargetUpdateForm")[0].reset();
                    $("#success-target").show();
                    $("#success-target").text(response.msg);

                    // setTimeout(function() {
                    //     $('#set-target').modal('close');
                    //     $("#success-target").hide();

                    // }, 500);
                    window.location.reload();

                },

                error: function(response) {

                    $.each(response.responseJSON.errors, function(key, value) {
                        $("#target_" + key + "_error").text(value[0]);
                    });

                },

            });
        });




        //donut-chart-start



        google.charts.load('current', {
            'packages': ['corechart', 'bar']
        });
        google.charts.setOnLoadCallback(drawChart);


        function drawChart() {
            // Define the chart to be drawn.
            var data = new google.visualization.DataTable();
            data.addColumn('string', 'Browser');
            data.addColumn('number', 'Percentage');
            data.addRows(
                // [['Firefox', 45.0],
                // ['IE', 26.8],
                // ['Chrome', 12.8],
                // ['Safari', 8.5]],

                {!! json_encode($donutChartData) !!}

            );

            // Set chart options
            var options = {
                //    'title':'Browser market shares at a specific website, 2014',
                'width': 500,
                'height': 400,
                pieHole: 0.5,
                legend: 'none',
                pieSliceText: "none",
                colors: ['#152b52', '#bb922e', '#b1a076', '#4569a9'],
                //  is3D: true

            };

            // Instantiate and draw the chart.
            var chart = new google.visualization.PieChart(document.getElementById('leads_by_type_donut_chart'));
            chart.draw(data, options);
        }
        google.charts.setOnLoadCallback(drawChart);

        //donut-chart-end
    </script>
@endsection
