@extends('dashboard.layouts.app')
@section('css')
    {{-- <style>
  .hide{ display: none;}
  label{ width:100%;}
</style> --}}




    <style>
        .golden {
            background-color: #123A5C;
        }

        .showcase {
            background-color: #E6E6E8;
        }

        .showcase:hover {
            background-color: #123A5C;

            color: rgb(255, 255, 255) !important;
            transition: all 300ms ease-in-out;
        }

        .showcase:hover .golden {
            background-color: #bb922e;
        }
    </style>
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">

            @if (request()->type == 1)
                <h5 class="font-medium m-b-0">Residential Projects</h5>
            @elseif(request()->type == 2)
                <h5 class="font-medium m-b-0">Commercial Projects</h5>
            @elseif(request()->type == 3)
                <h5 class="font-medium m-b-0">Retail Projects</h5>
            @else
                <h5 class="font-medium m-b-0">All Projects</h5>
            @endif


            <div class="custom-breadcrumb ml-auto">
                {{-- @if (auth()->user()->checkPermission('project-registration-form'))
                <a href="{{ route('registration.form.index') }}" class="btn">Registrations</a>
                @endif --}}
                @if (request()->type == 1 && \Auth::user()->checkPermission('project-proposal-form'))
                <a href="{{ route('proposal.form.index') }}" class="btn">Proposals</a>
                @endif

                {{-- <a href="{{ url('/dashboard/preferred-projects') }}" class="breadcrumb">Project</a> --}}
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card"style="margin-top:20px;">
                    <div class="card-content">
                        @if (\Auth::user()->checkPermission('create-project'))
                            <h5 class="card-title activator"><a class="waves-effect waves-light btn"
                                    href="{{ url('/dashboard/preferred-projects/create?type=' . $type . '') }}">Add Project</a>
                            </h5>
                        @endif
                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif


                        <div class="row-flex">
                            <!-- Column -->
                            @foreach ($rows as $row)

                          
                                <div class="project-items">
                                    <a href="{{ url('/dashboard/preferred-projects/show/' . $row->id . '?type=' . $type) }}">
                                        @if ($row->home_page_image)
                                            <img class="card-img-top responsive-img"
                                                src="{{ asset('uploads/' . $row->home_page_image) }}" alt="Project image"
                                                height="280px" width="374px">
                                        @else
                                            <img class="card-img-top responsive-img"
                                                src="{{ asset('assets/images/default/no-image.jpg') }}" alt="Image"
                                                height="280px" width="374px">
                                        @endif
                                    </a>
                                        <div class="card-content">

                                            <h5 class="showcase-header"> {{ $row->project_name }}</h5>

                                            <a href="{{ url('/dashboard/preferred-projects/show/' . $row->id . '?type=' . $type) }}"
                                                class="waves-effect waves-light btn btn-round golden">More</a>

                                            {{-- <a href="{{ url('/dashboard/preferred-projects/edit/' . $row->id.'?type='.$type) }}">Edit</a> --}}
                                        </div>
                                   
                                </div>
                            
                            @endforeach
                            <!-- Column -->
                        </div>



                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
