@extends('dashboard.layouts.app')
@section('css')

@endsection
@section('content')
<div class="page-titles">
  <div class="d-flex align-items-center">
      <h5 class="font-medium m-b-0">Project Block Management</h5>
      <div class="custom-breadcrumb ml-auto">
          <a href="{{url('/dashboard')}}" class="breadcrumb">Home</a>
          <a href="{{url('/dashboard/project-blocks/'.$row->preferred_project_id)}}" class="breadcrumb">Project Blocks</a>
      </div>
  </div>
</div>
<div class="container-fluid">
  <div class="row">
      <div class="col s12 l12">
          <div class="card">
              <div class="card-content">
                  <h5 class="card-title activator">Edit Project Block</h5>
                  @if ($message = Session::get('success'))
                  <div class="success-alert-bar p-15 m-b-20 green white-text">
                    {{ $message }}
                </div>
            
              @endif
              @if (count($errors) > 0)
        
        <div class="error-alert-bar p-15 m-b-20 red white-text">
          <strong>Whoops!</strong> There were some problems with your input.<br><br>
          <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
      </div>
      @endif
      <form method="post" action="{{url('dashboard/project-blocks/update')}}" enctype="multipart/form-data" class="projectForm" id="projectForm">
        {{csrf_field()}}
        <div class="row">
          <div class="input-field col s12">
              <input id="block_name" type="text" name="block_name" value="<?php echo $row->name;?>">
              <label for="block_name">Name</label>
              
          <span id="block_name_error" class="error"></span>
          </div>
        </div>


<div class="row">
                          <div class="input-field col s12">
                            <input type="hidden" name="id" value="{{$row->id}}">
                            <div class="success-alert-bar p-15 m-b-20 green white-text status" style="display: none;"></div>
                            <div class="loading" style="display:none"><img src="{{asset('assets/images/loading.gif')}}"></div>
                              <button class="btn cyan waves-effect waves-light right sub-btn" type="submit" name="action">Submit
                              </button>
                          </div>
                      </div>
                 
                  </form>
              </div>
          </div>
      </div>
  </div>
</div>
@endsection
@section('js')
<script>
</script>
@endsection









