@extends('dashboard.layouts.app')
@section('css')
    {{-- <style>
  .hide{ display: none;}
  label{ width:100%;}
</style> --}}
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Project Blocks @if ($pref_project)
                    of {{ $pref_project->project_name }}
                @endif
            </h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ url('/dashboard') }}" class="breadcrumb">Home</a>
                <a href="{{ url('/dashboard/preferred-projects') }}" class="breadcrumb">Project Management</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card">
                    <div class="card-content">
                        @if (\Auth::user()->checkPermission('create-project'))
                            <h5 class="card-title activator">
                                <a href="#add-block" class="waves-effect waves-light btn modal-trigger">Add Project
                                    Blocks</a>
                            </h5>
                        @endif
                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        <table id="zero_config" class="responsive-table display" style="width:100%">
                            <thead>
                                <tr>
                                    <th>
                                        #
                                    </th>
                                    {{-- <th>
                            Preferred Project
                       </th> --}}
                                    <th>
                                        Project Block
                                    </th>

                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                @if (count($rows) > 0)
                                    @php
                                        $i = 1;
                                    @endphp
                                    @foreach ($rows as $row)
                                        <tr id="project_{{ $row->id }}">
                                            <td>
                                                {{ $i }}
                                            </td>
                                            {{-- <td>
                            {{ $row->getProject->project_name}}
                         </td> --}}
                                            <td>
                                                <a>
                                                    {{ $row->name }}
                                                </a>

                                            </td>



                                            <td class="project-actions text-right" style="width:13%;">

                                                <a class='dropdown-trigger btn' href='#'
                                                    data-target='dropdown<?php echo $i; ?>'><i class="fa fa-cog"></i></a>


                                                <ul id='dropdown<?php echo $i; ?>' class='dropdown-content'>
                                                    <li><a href="{{ url('/dashboard/project-blocks/edit/' . $row->id) }}"
                                                            @if (!\Auth::user()->hasRole('super-admin') && !\Auth::user()->hasRole('management')) disabled @endif>Edit</a></li>
                                                    <li><a href="javascript:void(0)" class="deleteRecord"
                                                            data-id="{{ $row->id }}">Delete</a></li>

                                                    <li><a href="{{ url('/dashboard/project-units/' . $row->id) }}"
                                                            class="lead-view" data-id="{{ $row->id }}">Add Project
                                                            Units</a></li>

                                                </ul>

                                            </td>
                                        </tr>
                                        @php
                                            $i++;
                                        @endphp
                                    @endforeach
                                @endif

                            </tbody>
                        </table>





                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="add-block" class="modal">
        <form method="post" action="" enctype="multipart/form-data" class="formValidate" id="projectForm"
            name="formValidate">
            <div class="modal-content">
                <div class="modal-header">
                    {{-- <h5 class="modal-title">Create Lead</h5>
            <br> --}}
                </div>
                <div class="row">


                    {{ csrf_field() }}

                    <div class="increment">
                        <div class=" input-field col s10 ">

                            <label>Block</label>
                            <input type="text" name="block_name[]" required>
                            <span id="block_name_error_0" class="error"></span>


                        </div>
                        <div class="file-field1 input-field col s2 ">
                            <div class="input-group-btn">
                                <button class="btn btn-success btn-add" type="button"><i
                                        class="glyphicon glyphicon-plus"></i>Add</button>
                            </div>
                        </div>
                    </div>
                    <div class="clone hide">
                        <div class="control-group">
                            <div class=" input-field col s10">

                                <label>Block</label>
                                <input type="text" name="block_name[]" required>
                                <span id="block_name_error_1" class="error"></span>


                            </div>
                            <div class="file-field1 input-field col s2 ">
                                <div class="input-group-btn">
                                    <button class="btn btn-danger" type="button"><i class="glyphicon glyphicon-remove"></i>
                                        Remove</button>
                                </div>
                            </div>
                        </div>

                    </div>
                    <input type="hidden" name="project_id" id="project_id" value="{{ $preferred_project_id }}">
                </div>






            </div>
            <div class="modal-footer">

                <div class="success-alert-bar p-15 m-b-20 green white-text status" style="display: none;"></div>
                <div class="loading" style="display:none"><img src="{{ asset('assets/images/loading.gif') }}"></div>
                <button class="btn cyan waves-effect waves-light right sub-btn" type="submit" name="action">Submit
                </button>
                {{-- <a href="#!" class="btn modal-action modal-close waves-effect waves-light cyan">Save</a> --}}
                <a href="#!" class="btn modal-action modal-close waves-effect waves-light grey darken-4">Cancel</a>

            </div>
        </form>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {

            $(".btn-add").click(function() {
                var html = $(".clone").html();
                $(".increment").after(html);
            });

            $("body").on("click", ".btn-danger", function() {
                $(this).parents(".control-group").remove();
            });
            $('.sub-btn').on('click', function(e) {
                $('.status').hide();
                $('.red').html('');

                e.preventDefault();
                //var formData = new FormData($("#projectForm")[0]);
                $.ajax({
                    url: '{{ url('/dashboard/project-blocks/store') }}',
                    method: "post",
                    data: $("#projectForm").serialize(),
                    dataType: "json",

                    beforeSend: function() {
                        $('.loading').show();
                    },
                    success: function(response) {
                        $('.loading').hide();
                        var error = response.error;
                        if (error != '') {
                            //var errors = $.parseJSON(error);
                            console.log(error);
                            var i = 0;
                            $.each(error, function(key, val) {
                                $("#block_name_error_" + i).html(val[0]);
                                i++;
                            });
                        } else {
                            $("#projectForm")[0].reset();
                            $('.status').show();
                            $('.status').html(response.message);
                            window.location.reload();
                        }

                    }
                    // return false;
                });

            });

        });
        $(".card").on('click', '.deleteRecord', function(e) {
            e.preventDefault();

            var ele = $(this);
            var id = ele.attr("data-id");
            if (confirm("Are you sure you want to remove?")) {
                $.ajax({
                    url: '{{ url('/dashboard/project-blocks/delete') }}',
                    method: "DELETE",
                    data: {
                        _token: '{{ csrf_token() }}',
                        id: ele.attr("data-id")
                    },
                    success: function(response) {
                        //window.location.reload();
                        $('#project_' + id).remove();
                    }
                });
            }
        });
    </script>
@endsection
