@extends('dashboard.layouts.app')
@section('css')
    <style>
        label {
            top: -34px !important;
        }

        label.active {
            transform: translate(10px, 10px) !important;
        }

        input {
            width: 100%;
            height: 3rem;
        }

        .text-red {
            color: rgb(209, 28, 28);
        }
    </style>
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Create Project Unit</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ url('/dashboard') }}" class="breadcrumb">Home</a>
                <a href="{{ url('/dashboard/project-units/' . $preferred_project->id) }}" class="breadcrumb">Project Units</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card">
                    <div class="card-content">
                        {{-- <h5 class="card-title activator">Create Project Unit</h5> --}}
                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        @if ($message = Session::get('error'))
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                {{ $message }}
                            </div>
                        @endif
                        {{-- @if (count($errors) > 0)
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif --}}
                        <div class="row">
                            <form method="post" action="{{ route('unit.store') }}" enctype="multipart/form-data"
                                class="formValidate" id="proposalForm" name="proposalForm">
                                {{ csrf_field() }}
                                <input type="hidden" name="project_id" value="{{ $preferred_project->id }}">
                                <div class="row">
                                    <div class="col s12 l12">
                                        <div class="input-field col 13 m4 s12">
                                            <input id="preferred_project" name="preferred_project" type="text"
                                                value="{{ $preferred_project->project_name }}" readonly>

                                            <label for="preferred_project" class="active">Name of Project<span
                                                    class="red-star">*</span></label>
                                            <span id="preferred_project_error" class="error"></span>

                                            @if ($errors->has('preferred_project'))
                                                <span class="red-text">{{ $errors->first('preferred_project') }}</span>
                                            @endif


                                        </div>
                                        <div class="input-field col 13 m4 s12">
                                            <input id="floor" name="floor" type="text" value="{{old('floor',0)}}">
                                            <label for="floor">Floor<span class="red-star"></span></label>
                                            <span id="floor_error" class="error"></span>

                                            @if ($errors->has('floor'))
                                                <span class="red-text">{{ $errors->first('floor') }}</span>
                                            @endif

                                        </div>
                                        <div class="input-field col 13 m4 s12">
                                            <input id="apartment_type" name="apartment_type" type="text"
                                                value="{{ old('apartment_type') }}">
                                            <label for="apartment_type">Apartment Type<span class="red-star"></span></label>
                                            <span id="apartment_type_error" class="error"></span>

                                            @if ($errors->has('apartment_type'))
                                                <span class="red-text">{{ $errors->first('apartment_type') }}</span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col s12 l12">
                                        <div class="input-field col 13 m3 s12">
                                            <input id="ap_no" name="ap_no" type="text"
                                                value="{{ old('ap_no') }}">
                                            <label for="ap_no">Unit No<span class="red-star">*</span></label>
                                            <span id="ap_no_error" class="error"></span>
                                            @if ($errors->has('ap_no'))
                                                <span class="red-text">{{ $errors->first('ap_no') }}</span>
                                            @endif
                                        </div>
                                        <div class="input-field col 13 m3 s12">
                                            <input id="carpet_area" name="carpet_area" type="text"
                                                value="{{ old('carpet_area') }}">
                                            <label for="carpet_area1">CARPET AREA<span class="red-star">*</span></label>
                                            <span id="carpet_area_error" class="error"></span>

                                            @if ($errors->has('carpet_area'))
                                                <span class="red-text">{{ $errors->first('carpet_area') }}</span>
                                            @endif
                                        </div>
                                        <div class="input-field col 13 m3 s12">
                                            <input id="rate_per_sba" name="rate_per_sba" type="text" value="">
                                            <input id="rate_per_sba_total" name="rate_per_sba_total" type="hidden"
                                                value="{{ $preferred_project->preveling_rate ? $preferred_project->preveling_rate : 6000 }}">
                                            <label for="rate_per_sba">Rate Per SBA<span class="red-star"></span></label>
                                            <span id="rate_per_sba" class="error"></span>


                                            @if ($errors->has('sba_area'))
                                                <span class="red-text">{{ $errors->first('sba_area') }}</span>
                                            @endif
                                        </div>
                                        <div class="input-field col 13 m3 s12">
                                            <input id="sba_area" name="total_sba" type="text"
                                                value="{{ old('sba_area') }}">
                                            <input id="sba" name="sba" type="hidden" value="">
                                            <label for="sba_area">SBA<span class="red-star">*</span></label>
                                            <span id="sba_area_error" class="error"></span>


                                            @if ($errors->has('sba_area'))
                                                <span class="red-text">{{ $errors->first('sba_area') }}</span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col s12 l12">
                                        <div class="input-field col 13 m3 s12">
                                            <input id="extended_balcony_area" name="extended_balcony_area" type="text"
                                                value="{{ old('extended_balcony_area') }}">
                                            <label for="extended_balcony_area">Extended Balcony Area</label>
                                            <span id="extended_balcony_area_error" class="error"></span>

                                            @if ($errors->has('extended_balcony_area'))
                                                <span
                                                    class="red-text">{{ $errors->first('extended_balcony_area') }}</span>
                                            @endif
                                        </div>
                                        <div class="input-field col 13 m3 s12">
                                            <input id="total_sba" name="sba_area" type="text"
                                                value="{{ old('total_sba') }}"readonly>
                                            <label for="total_sba">Total SBA</label>
                                            <span id="total_sba" class="error"></span>

                                            @if ($errors->has('total_sba'))
                                                <span
                                                    class="red-text">{{ $errors->first('total_sba') }}</span>
                                            @endif
                                        </div>


                                        <div class="input-field col 13 m3 s12">
                                            <input id="car_parking" name="car_parking" type="text" value="0">
                                            <label for="car_parking" id="car_parking_lbl">Car Parking (Nos)</label>
                                            <span id="car_parking_error" class="error"></span>

                                            @if ($errors->has('car_parking'))
                                                <span class="red-text">{{ $errors->first('car_parking') }}</span>
                                            @endif
                                        </div>
                                        <div class="input-field col 13 m3 s12">
                                            <input id="carparking_amount" name="carparking_amount" type="text"
                                                value="{{ old('carparking_amount') }}">
                                            <label for="carparking_amount">Car Parking Amount </label>
                                            <span id="carparking_amount_error" class="error"></span>

                                            @if ($errors->has('carparking_amount'))
                                                <span class="red-text">{{ $errors->first('carparking_amount') }}</span>
                                            @endif
                                        </div>

                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col s12 l12">
                                        <div class="input-field col 13 m4 s12">
                                            <input id="sale_value" name="sale_value" type="text"
                                                value="{{ old('sale_value') }}" readonly>
                                            <label for="sale_value">Sale Value</label>
                                            <span id="sale_value_error" class="error"></span>

                                            @if ($errors->has('sale_value'))
                                                <span class="red-text">{{ $errors->first('sale_value') }}</span>
                                            @endif
                                        </div>
                                        <div class="input-field col 13 m4 s12">
                                            <input id="taxable_amount" name="taxable_amount" type="text"
                                                value="{{ old('taxable_amount') }}">
                                            <label for="taxable_amoun" id="taxable_amount">GST / CESS Prevailing
                                                Rate</label>
                                            <span id="taxable_amount_error" class="error"></span>
                                            @if ($errors->has('taxable_amount'))
                                                <span class="red-text">{{ $errors->first('taxable_amount') }}</span>
                                            @endif

                                        </div>


                                        <div class="input-field col 14 m4 s12">
                                            <input id="parking_number" name="parking_number" type="text"
                                                value="{{ old('parking_number') }}">
                                            <label for="parking_number">Parking Number</label>
                                            <span id="parking_number_error" class="error"></span>

                                            @if ($errors->has('parking_number'))
                                                <span class="red-text">{{ $errors->first('parking_number') }}</span>
                                            @endif
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col s12 l12">
                                        <div class="input-field col 13 m4 s12">
                                            <input id="rate_per_sqft" name="rate_per_sqft" type="text"
                                                value="{{ old('rate_per_sqft') }}">
                                            <label for="rate_per_sqft1">Rate Per (sq.ft carpet area) </label>
                                            <span id="rate_per_sqft_error" class="error"></span>


                                            @if ($errors->has('rate_per_sqft'))
                                                <span class="red-text">{{ $errors->first('rate_per_sqft') }}</span>
                                            @endif
                                        </div>
                                        <div class="input-field col 13 m4 s12">
                                            <input id="grand_total" name="grand_total" type="text"
                                                value="{{ old('grand_total') }}">
                                            <label for="grand_tota">Grand Total</label>
                                            <span id="grand_total_error" class="error"></span>

                                            @if ($errors->has('grand_total'))
                                                <span class="red-text">{{ $errors->first('grand_total') }}</span>
                                            @endif
                                        </div>


                                        <div class="file-field input-field col 13 m4 s12">
                                            <div class="btn">
                                                <span>Upload Layout Plan</span>
                                                <input type="file" name="layour_plan" id="layour_plan">
                                                <span id="layour_plan_error" class="error"></span>
                                            </div>
                                            <div class="file-path-wrapper">
                                                <input class="file-path validate" type="text">


                                            </div>
                                        </div>

                                        @if ($errors->has('layour_plan'))
                                            <span class="red-text">{{ $errors->first('layour_plan') }}</span>
                                        @endif
                                    </div>
                                </div>
                                <div class="col l12">
                                    <div class="success-alert-bar p-15 m-b-20 green white-text status"
                                        style="display: none;"></div>
                                </div>
                                <div class="loading" style="display:none"><img
                                        src="{{ asset('assets/images/loading.gif') }}"></div>
                                <button class="btn cyan waves-effect waves-light right  m-t-30 m-b-20" type="submit"
                                    name="action">Create
                                </button>
                        </div>
                        </form>
                        {{-- </form> --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {

            value();


        });
        $('.input-field').each(function() {
            $(this).change(function() {
                $(this).find('.error').html('');

            });
        });

        function value() {
            var floor = $('#floor').val();
            var sba_total = floor * 25;
            var extended_balcony = $('#extended_balcony_area').val();

            if (floor == 0) {
                var extended = extended_balcony / 4;

            } else {
                var extended = extended_balcony / 2;
            }
            var sba = $('#sba_area').val();
            var rate_per_sba = $('#rate_per_sba_total').val();
            var rate_floor = parseFloat(rate_per_sba) + (sba_total);
            $('#rate_per_sba').val(rate_floor);
            if (extended_balcony != '') {
            
                var total_sba = parseFloat(sba) + parseFloat(extended);

                $('#total_sba').val(total_sba);
            }
            else{
                $('#total_sba').val(sba);
            }

            var car_parking = $('#car_parking').val();
            var carpet = $('#carpet_area').val();
            var carparking_amount = $('#carparking_amount').val();
            var caramnt = car_parking * 300000;
           
            var total_sba = $('#total_sba').val();
            $('#carparking_amount').val(caramnt);
            var sale_value = (parseFloat(rate_floor)) * (total_sba) + (caramnt);
            $('#sale_value').val(sale_value);
            var gst = parseFloat(sale_value) * 6.05 / 100;
            $('#taxable_amount').val(gst);
            var cartotalnew = parseFloat(sale_value) / carpet;
            $('#rate_per_sqft').val(cartotalnew);
            var total = ((parseFloat(sale_value) + parseFloat(gst)));
            var grand = $('#grand_total').val(total);

        }

        $('#car_parking').keyup(function() {

            value();

        });
        $('#sba_area').keyup(function() {
            value();
        })
        $('#floor').keyup(function() {
            value();
        })
        $('#carpet_area').keyup(function() {
            value();
        })
        $('#sale_value').keyup(function() {
            value();


        });
        $('#rate_per_sba_').keyup(function() {
            value();
        })
        $('#extended_balcony_area').keyup(function() {
            value();
        })


        $('.select2').each(function() {

            $(this).select2({

                placeholder: "Choose your option",

                theme: "material",

                dropdownParent: $(this).parent()

            });

        });
    </script>
@endsection
