@extends('dashboard.layouts.app')
@section('css')
<style>
  label {
      top: -34px !important;
  }

  label.active {
      transform: translate(10px, 10px) !important;
  }

  input {
      width: 100%;
      height: 3rem;
  }

  .text-red {
      color: rgb(209, 28, 28);
  }
</style>
@endsection
@section('content')
<div class="page-titles">
  <div class="d-flex align-items-center">
    <h5 class="font-medium m-b-0">Project Unit Management</h5>
    <div class="custom-breadcrumb ml-auto">
      <a href="{{url('/dashboard')}}" class="breadcrumb">Home</a>
         <a href="{{url('/dashboard/project-units/'.$price_list->getProjects->id)}}" class="breadcrumb">Project Units</a>
    </div>
  </div>
</div>
<div class="container-fluid">
  <div class="row">
    <div class="col s12 l12">
      <div class="card">
        <div class="card-content">
          <h5 class="card-title activator">Edit Project Unit</h5>
          @if ($message = Session::get('success'))
          <div class="success-alert-bar p-15 m-b-20 green white-text">
            {{ $message }}
          </div>

          @endif
          @if (count($errors) > 0)

          <div class="error-alert-bar p-15 m-b-20 red white-text">
            <strong>Whoops!</strong> There were some problems with your input.<br><br>
            <ul>
              @foreach ($errors->all() as $error)
              <li>{{ $error }}</li>
              @endforeach
            </ul>
          </div>
          @endif
          <form method="post" action="{{route('retail.update')}}" enctype="multipart/form-data"
            class="projectForm" id="projectForm">
            {{csrf_field()}}
            <div class="row">
              <div class="col s12 l12">
                <div
                    class="input-field col 13 @if ($preferred_project->project_type == 2) m3 @else m4 @endif s12">
                    <input id="preferred_project" name="preferred_project" type="text"
                        value="{{ $price_list->getProjects->project_name }}" readonly>


                    <label for="preferred_project" class="active">Name of Project <span
                            class="red-star">*</span></label>
                    <span id="preferred_project_error" class="error"></span>

                    @if ($errors->has('preferred_project'))
                        <span class="red-text">{{ $errors->first('preferred_project') }}</span>
                    @endif


                </div>
                <div
                    class="input-field col 13 @if ($preferred_project->project_type == 2) m3 @else m4 @endif s12">
                    <input id="floor" name="floor" type="text" value="{{$price_list->floor}}">
                    <label for="floor">Floor<span class="red-star"></span></label>
                    <span id="floor_error" class="error"></span>

                    @if ($errors->has('floor'))
                        <span class="red-text">{{ $errors->first('floor') }}</span>
                    @endif

                </div>
                <div
                    class="input-field col 13 @if ($preferred_project->project_type == 2) m3 @else m4 @endif s12">

                    <input id="ap_no" name="ap_no" type="text"
                        value="{{$price_list->ap_no}}">
                    <label for="ap_no">Unit No<span class="red-star">*</span></label>
                    <span id="ap_no_error" class="error"></span>
                    @if ($errors->has('ap_no'))
                        <span class="red-text">{{ $errors->first('ap_no') }}</span>
                    @endif

                </div>
                @if ($preferred_project->project_type == 2)
                    <div class="input-field col 13 m3 s12">

                        <label>Type</label>
                        <select name="type" id="typeid" class="browser-default select2" required>

                            <option value="">Choose your option</option>
                            <option value="rental_commitment" @if ($price_list->type == 'rental_commitment') selected @endif>Rental Commitment
                            </option>
                            <option value="without_rental_commitment" @if ($price_list->type == 'without_rental_commitment') selected @endif>Without Rental Commitment
                            </option>
                        
                        </select>
                        @if ($errors->has('type'))
                            <span class="red-text">{{ $errors->first('type') }}</span>
                        @endif
                @endif

            
           </div>
           <div class="row">
            <div class="col s12 l12">


                <div class="input-field col 13 m4 s12">
                    <input id="sba_area" name="sba_area" type="text"
                        value="{{ old('sba_area',$price_list->sba_area) }}">
                    <label for="sba_area">SBA<span class="red-star">*</span></label>
                    <span id="sba_area_error" class="error"></span>


                    @if ($errors->has('sba_area'))
                        <span class="red-text">{{ $errors->first('sba_area') }}</span>
                    @endif
                </div>

                <div class="input-field col 13 m4 s12">
                    <input id="rate_per_sqft" name="rate_per_sqft" type="text"
                        value="{{ old('rate_per_sqft',$price_list->rate_per_sqft) }}">
                    <label for="rate_per_sqft1">Rate Per (sq.ft) </label>
                    <span id="rate_per_sqft_error" class="error"></span>


                    @if ($errors->has('rate_per_sqft'))
                        <span class="red-text">{{ $errors->first('rate_per_sqft') }}</span>
                    @endif
                </div>
                <div class="input-field col 13 m4 s12">
                    <input id="sale_value" name="sale_value" type="text"
                        value="{{ old('sale_value',$price_list->sale_value) }}">
                    <label for="sale_value">Sale Value</label>
                    <span id="sale_value_error" class="error"></span>

                    @if ($errors->has('sale_value'))
                        <span class="red-text">{{ $errors->first('sale_value') }}</span>
                    @endif
                </div>

             
            </div>
        </div>
     
           
  
          
          
           <div class="row">
              <div class="col s12 l12">
                 
                <div class="input-field col 16 m6 s12">
                    <input id="monthly_rental" name="monthly_rental" type="text"
                        value="{{ old('monthly_rental',$price_list->monthly_rental) }}">
                    <label for="monthly_rental">Monthly Rental </label>
                    <span id="monnthly_rental_error" class="error"></span>


                    @if ($errors->has('monthly_rental'))
                        <span class="red-text">{{ $errors->first('monthly_rental') }}</span>
                    @endif
                </div>

                 <div class="file-field input-field col l6 m6 s12">
                    <div class="btn">
                       <span>Browse Layout Plan</span>
                       <input type="file" name="layour_plan" id="layour_plan">
                       <span id="layour_plan_error" class="error"></span>
                    </div>
                    <div class="file-path-wrapper">
                       <input class="file-path validate" type="text">
                    </div>
                 </div>
              </div>
           </div>
           <input name ="id" type="hidden" value="{{$price_list->id}}">
            <input type="hidden" name="project_id" value="{{ $preferred_project->id }}">
            <div class="row">
              <div class="input-field col s12">
                <div class="success-alert-bar p-15 m-b-20 green white-text status" style="display: none;"></div>
                <div class="loading" style="display:none"><img src="{{asset('assets/images/loading.gif')}}"></div>
                <button class="btn cyan waves-effect waves-light right" type="submit" name="action">Submit
                </button>
              </div>
            </div>

          </form>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
@section('js')
<script>
  $('.input-field').each(function() {
      $(this).change(function() {
          $(this).find('.error').html('');

      });
  });
  $('.select2').each(function() {

      $(this).select2({

          placeholder: "Choose your option",

          theme: "material",

          dropdownParent: $(this).parent()

      });

  });
  $('#sba_area').keyup(function() {
      var sba = $('#sba_area').val();
      var rate = $('#rate_per_sqft').val();
      var sale_value = sba * rate;
      $('#sale_value').val(sale_value);
      var year = sale_value * 6 / 100;
      var month = year / 12;
      $('#monthly_rental').val(month);


  });
  $('#rate_per_sqft').keyup(function() {
      var sba = $('#sba_area').val();
      var rate = $('#rate_per_sqft').val();
      var sale_value = sba * rate;
      $('#sale_value').val(sale_value);
      var year = sale_value * 6 / 100;
      var month = year / 12;
      $('#monthly_rental').val(month);

  });
  $("#typeid").bind("change keyup", function(event) {
      var e = document.getElementById("typeid")
      var type = e.value;
      console.log(type);
      if (type == 'rental_commitment') {
          var sba = $('#sba_area').val();
          var rate = $('#rate_per_sqft').val();
          var sale_value = sba * rate;
          $('#sale_value').val(sale_value);
          var year = sale_value * 6 / 100;
          var month = year / 12;
          $('#monthly_rental').val(month);

      } else {
          var sba = $('#sba_area').val();
          var rate = $('#rate_per_sqft').val();
          var sale_value = sba * rate;
          $('#sale_value').val(sale_value);
          var year = sale_value * 6 / 100;
          var month = year / 12;
          $('#monthly_rental').val(0);
      }

  });
</script>
@endsection