@extends('dashboard.layouts.app')
@section('css')
    <style>
        label {
            top: -34px !important;
        }

        label.active {
            transform: translate(10px, 10px) !important;
        }

        input {
            width: 100%;
            height: 3rem;
        }

        .text-red {
            color: rgb(209, 28, 28);
        }
    </style>
@endsection
@section('content')
    <div class="page-titles">

        <div class="d-flex align-items-center">

            <h5 class="font-medium m-b-0">Registration Form</h5>

            <div class="custom-breadcrumb ml-auto">
                <a href="{{ url('/dashboard') }}" class="breadcrumb">Home</a>
                <a href="{{ url('dashboard/preferred-projects?type=' . $type) }}" class="breadcrumb">Projects</a>
                <a href="#" class="breadcrumb">Form</a>
            </div>

        </div>

    </div>
    @if ($message = Session::get('success'))
        <div class="success-alert-bar p-15 m-b-20 green white-text">
            {{ $message }}
        </div>
    @endif
    @if ($message = Session::get('error'))
        <div class="error-alert-bar p-15 m-b-20 red white-text">
            {{ $message }}
        </div>
    @endif
    <div class="container-fluid">

        <div class="row">

            <div class="col s12 l12">

                <div class="card">

                    <div class="card-content">



                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">

                                {{ $message }}

                            </div>
                        @endif

                        @if ($message = Session::get('error'))
                            <div class="error-alert-bar p-15 m-b-20 red white-text">

                                {{ $message }}

                            </div>
                        @endif



                        <div class="row">

                            <form method="post" action="{{ route('registration.form.store') }}"
                                enctype="multipart/form-data" class="formValidate" id="">

                                {{ csrf_field() }}



                                <div class="row m-t-40">

                                    <input type="hidden" name="type" value="{{ $type }}">

                                    <div class="input-field col s3">

                                        <select class="browser-default select2" name="project_id" id="project_id">
                                            <option value="{{ $project['projectId'] }}" selected>
                                                {{ $project['projectName'] }}</option>

                                        </select>
                                        <label class="materialize-red-text">Project</label>
                                        @error('project_name')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>


                                    <div class="input-field col s2">

                                        <select class="browser-default select2" name="unit_id" id="unit_id" required>
                                            <option value=""> Choose Unit</option>

                                        </select>
                                        <label class="materialize-red-text">Unit</label>
                                        @error('unit_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s1">

                                        <select class="browser-default select2" name="name_prefix" id="name_prefix"
                                            required>
                                            <option value="">Choose your option</option>
                                            <option value="Mr."
                                                @if (old('name_prefix') == 'Mr.') selected="selected" @endif>Mr
                                            </option>
                                            <option value="Mrs."
                                                @if (old('name_prefix') == 'Mrs.') selected="selected" @endif>
                                                Mrs</option>
                                            <option value="Ms."
                                                @if (old('name_prefix') == 'Ms.') selected="selected" @endif>
                                                Ms</option>

                                            <option value="Dr."
                                                @if (old('name_prefix') == 'Dr.') selected="selected" @endif>
                                                Dr</option>

                                        </select>
                                        <label class="materialize-red-text">Title</label>
                                        @error('name_prefix')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>


                                    <div class="input-field col s3 ">
                                        <input id="name" name="name" type="text" value="{{ old('name') }}"
                                            required>
                                        <label class="materialize-red-text">Name</label>
                                        @error('name')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s2">
                                        <input id="dob" type="text" name="dob" class="M_Datepicker"
                                            value="{{ old('dob') }}">


                                        <label for="dob">DOB</label>
                                        @error('dob')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror

                                    </div>



                                    <div class="input-field col s1 ">
                                        <input id="age" name="age" type="text" value="{{ old('age') }}">
                                        <label for="age" id="age_lbl">
                                            Age<span class="red-star"></span></label>
                                        @error('age')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>



                                    <div class="input-field col s3 ">
                                        <input id="guardian_name" name="guardian_name" type="text"
                                            value="{{ old('guardian_name') }}">
                                        <label for="guardian_name" id="guardian_name_lbl">
                                            Father/Husband Name<span class="red-star"></span></label>
                                        @error('guardian_name')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>



                                    <div class="input-field col s3 ">
                                        <input id="occupation" name="occupation" type="text"
                                            value="{{ old('occupation') }}">
                                        <label for="occupation" id="occupation_lbl">
                                            Occupation<span class="red-star"></span></label>
                                        @error('occupation')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s6">
                                        <textarea name="address" id="address" class="materialize-textarea">{{ old('address') }}</textarea>
                                        <label for="address">Permanent Address</label>
                                        @error('address')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror

                                    </div>

                                    <div class="input-field col s3 ">
                                        <input id="pin" name="pin" type="number" min="1"
                                            value="{{ old('pin') }}">
                                        <label for="pin" id="pin_lbl">Pin Code<span
                                                class="red-star"></span></label>
                                        @error('pin')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s3 ">
                                        <input id="amsom" name="amsom" type="text"
                                            value="{{ old('amsom') }}">
                                        <label for="amsom" id="amsom_lbl">Amsom<span class="red-star"></span></label>
                                        @error('amsom')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="input-field col s3 ">
                                        <input id="desom" name="desom" type="text"
                                            value="{{ old('desom') }}">
                                        <label for="desom" id="desom_lbl">Desom<span class="red-star"></span></label>
                                        @error('desom')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="input-field col s3 ">
                                        <input id="village" name="village" type="text"
                                            value="{{ old('village') }}">
                                        <label for="village" id="village_lbl">Village<span
                                                class="red-star"></span></label>
                                        @error('village')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="input-field col s3 ">
                                        <input id="taluk" name="taluk" type="text"
                                            value="{{ old('taluk') }}">
                                        <label for="taluk" id="taluk_lbl">Taluk<span class="red-star"></span></label>
                                        @error('taluk')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="input-field col s3 ">
                                        <input id="district" name="district" type="text"
                                            value="{{ old('district') }}">
                                        <label for="district" id="district_lbl">District<span
                                                class="red-star"></span></label>
                                        @error('district')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s6">
                                        <textarea name="present_address" id="present_address" class="materialize-textarea"
                                            value="{{ old('present_address') }}"></textarea>
                                        <label for="present_address">Present Address (if Any) </label>

                                        <span class="invalid-feedback red" role="alert" id="present_address_error">

                                        </span>


                                    </div>

                                    <div class="input-field col s3 ">
                                        <input id="present_pincode" name="present_pincode" type="number" min="1"
                                            value="{{ old('present_pincode') }}">
                                        <label for="present_pincode" id="present_pincode_lbl">Pin Code<span
                                                class="red-star"></span></label>
                                        @error('present_pincode')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s3 ">
                                        <input id="pancard" name="pancard" type="text"
                                            value="{{ old('pancard') }}">
                                        <label for="pancard" id="pancard_lbl">PAN<span class="red-star"></span></label>
                                        @error('pancard')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="input-field col s2 ">
                                        <input id="phone_no" name="phone_no" type="number" min="1"
                                            value="{{ old('phone_no') }}">
                                        <label for="phone_no" id="phone_no_lbl">Phone (land line)<span
                                                class="red-star"></span></label>
                                        @error('phone_no')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>


                                    <div class="input-field col s2">

                                        <select class="browser-default select2" name="phone_code" id="phone_code">
                                            <option value=""> Choose </option>
                                            @foreach ($country_codes as $code)
                                                <option value="{{ $code->phonecode }}"
                                                    @if (old('phone_code') == $code->phonecode) selected="selected" @endif>
                                                    {{ $code->phonecode }} </option>
                                            @endforeach

                                        </select>
                                        <label>Phone Code</label>
                                        @error('phone_code')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s2 ">
                                        <input id="mobile" name="mobile" type="number" min="1"
                                            value="{{ old('mobile') }}">
                                        <label for="mobile" id="mobile_lbl">Mobile<span
                                                class="red-star"></span></label>
                                        @error('mobile')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s3 ">
                                        <input id="email" name="email" type="email"
                                            value="{{ old('email') }}">
                                        <label for="email" id="email_lbl">Email<span class="red-star"></span></label>
                                        @error('email')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>




                                    <div class="input-field col s3">

                                        <select class="browser-default select2" name="identity_card" id="identity_card">
                                            <option value=""> Choose </option>
                                            <option value="Passport" @if (old('identity_card') == 'Passport') selected @endif>
                                                Passport</option>
                                            <option value="Voter ID" @if (old('identity_card') == 'Voter ID') selected @endif>
                                                Voter ID</option>
                                            <option value="Driving License"
                                                @if (old('identity_card') == 'Driving License') selected @endif> Driving License</option>

                                        </select>
                                        <label>Proof of Identity</label>
                                        @error('identity_card')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>


                                    <div class="input-field col s3 ">
                                        <input id="identity_card_no" name="identity_card_no" type="text"
                                            value="{{ old('identity_card_no') }}">
                                        <label for="identity_card_no" id="identity_card_no_lbl">ID Number<span
                                                class="red-star"></span></label>
                                        @error('identity_card_no')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                </div>


                                {{-- <h3>Co Owner</h3> --}}
                                <div class="row">

                                    <h5 class="ld-title col s12 "style="margin-top:15px;">

                                        <span
                                            style=" display:inline-block;border-bottom:1px solid black;padding-bottom:2px;">
                                            <b>Co Owner</b></span>
                                        {{-- <hr style="background-color:#152b52;border:1px solid; width:22%;"> --}}

                                    </h5>

                                </div>

                                <div class="row m-t-40">


                                    <div class="input-field col s3">

                                        <select class="browser-default select2" name="co_owner_name_prefix"
                                            id="co_owner_name_prefix">


                                            <option value=""> Choose </option>
                                            <option value="Mr."
                                                @if (old('co_owner_name_prefix') == 'Mr.') selected="selected" @endif>Mr
                                            </option>
                                            <option value="Mrs."
                                                @if (old('co_owner_name_prefix') == 'Mrs.') selected="selected" @endif>
                                                Mrs</option>
                                            <option value="Ms."
                                                @if (old('co_owner_name_prefix') == 'Ms.') selected="selected" @endif>
                                                Ms</option>

                                            <option value="Dr."
                                                @if (old('co_owner_name_prefix') == 'Dr.') selected="selected" @endif>
                                                Dr</option>

                                        </select>
                                        <label>Abbreviation</label>
                                        @error('co_owner_name_prefix')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>


                                    <div class="input-field col s3 ">
                                        <input id="co_owner_name" name="co_owner_name" type="text"
                                            value="{{ old('co_owner_name') }}">
                                        <label>Co Owner Name</label>
                                        @error('co_owner_name')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s3">
                                        <input id="co_owner_dob" type="text" name="co_owner_dob" class="M_Datepicker"
                                            value="{{ old('co_owner_dob') }}">


                                        <label for="co_owner_dob">DOB</label>
                                        @error('co_owner_dob')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror

                                    </div>



                                    <div class="input-field col s3 ">
                                        <input id="co_owner_age" name="co_owner_age" type="text"
                                            value="{{ old('co_owner_age') }}">
                                        <label for="co_owner_age" id="co_owner_age_lbl">
                                            Age<span class="red-star"></span></label>
                                        @error('co_owner_age')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s3 ">
                                        <input id="co_owner_guardian_name" name="co_owner_guardian_name" type="text"
                                            value="{{ old('co_owner_guardian_name') }}">
                                        <label for="co_owner_guardian_name" id="co_owner_guardian_name_lbl">
                                            Father/Husband Name<span class="red-star"></span></label>
                                        @error('co_owner_guardian_name')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>



                                    <div class="input-field col s3 ">
                                        <input id="co_owner_occupation" name="co_owner_occupation" type="text"
                                            value="{{ old('co_owner_occupation') }}">
                                        <label for="co_owner_occupation" id="co_owner_occupation_lbl">
                                            Occupation<span class="red-star"></span></label>
                                        @error('co_owner_occupation')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s6">
                                        <textarea name="co_owner_address" id="co_owner_address" class="materialize-textarea">{{ old('co_owner_address') }}</textarea>
                                        <label for="co_owner_address">Permanent Address</label>
                                        @error('co_owner_address')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror

                                    </div>

                                    <div class="input-field col s3 ">
                                        <input id="co_owner_pin" name="co_owner_pin" type="number" min="1"
                                            value="{{ old('co_owner_pin') }}">
                                        <label for="co_owner_pin" id="co_owner_pin_lbl">Pin Code<span
                                                class="red-star"></span></label>
                                        @error('co_owner_pin')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s3 ">
                                        <input id="co_owner_amsom" name="co_owner_amsom" type="text"
                                            value="{{ old('co_owner_amsom') }}">
                                        <label for="co_owner_amsom" id="co_owner_amsom_lbl">Amsom<span
                                                class="red-star"></span></label>
                                        @error('co_owner_amsom')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="input-field col s3 ">
                                        <input id="co_owner_desom" name="co_owner_desom" type="text"
                                            value="{{ old('co_owner_desom') }}">
                                        <label for="co_owner_desom" id="co_owner_desom_lbl">Desom<span
                                                class="red-star"></span></label>
                                        @error('co_owner_desom')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="input-field col s3 ">
                                        <input id="co_owner_village" name="co_owner_village" type="text"
                                            value="{{ old('co_owner_village') }}">
                                        <label for="co_owner_village" id="co_owner_village_lbl">Village<span
                                                class="red-star"></span></label>
                                        @error('co_owner_village')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="input-field col s3 ">
                                        <input id="co_owner_taluk" name="co_owner_taluk" type="text"
                                            value="{{ old('co_owner_taluk') }}">
                                        <label for="co_owner_taluk" id="co_owner_taluk_lbl">Taluk<span
                                                class="red-star"></span></label>
                                        @error('co_owner_taluk')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="input-field col s3 ">
                                        <input id="co_owner_district" name="co_owner_district" type="text"
                                            value="{{ old('co_owner_district') }}">
                                        <label for="co_owner_district" id="co_owner_district_lbl">District<span
                                                class="red-star"></span></label>
                                        @error('co_owner_district')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s6">
                                        <textarea name="co_owner_present_address" id="co_owner_present_address" class="materialize-textarea"
                                            value="{{ old('co_owner_present_address') }}"></textarea>
                                        <label for="co_owner_present_address">Present Address (if Any) </label>

                                        <span class="invalid-feedback red" role="alert"
                                            id="co_owner_present_address_error">

                                        </span>


                                    </div>

                                    <div class="input-field col s3 ">
                                        <input id="co_owner_present_pincode" name="co_owner_present_pincode"
                                            type="number" value="{{ old('co_owner_present_pincode') }}" min="1">
                                        <label for="co_owner_present_pincode" id="co_owner_present_pincode_lbl">Pin
                                            Code<span class="red-star"></span></label>
                                        @error('co_owner_present_pincode')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s3 ">
                                        <input id="co_owner_pancard" name="co_owner_pancard" type="text"
                                            value="{{ old('co_owner_pancard') }}">
                                        <label for="co_owner_pancard" id="co_owner_pancard_lbl">PAN<span
                                                class="red-star"></span></label>
                                        @error('co_owner_pancard')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s2">

                                        <select class="browser-default select2" name="co_owner_phone_code"
                                            id="co_owner_phone_code">
                                            <option value=""> Choose </option>
                                            @foreach ($country_codes as $code)
                                                <option value="{{ $code->phonecode }}"
                                                    @if (old('co_owner_phone_code') == $code->phonecode) selected="selected" @endif>
                                                    {{ $code->phonecode }} </option>
                                            @endforeach

                                        </select>
                                        <label>Phone Code</label>
                                        @error('co_owner_phone_code')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="input-field col s2 ">
                                        <input id="co_owner_mobile" name="co_owner_mobile" type="number" min="1"
                                            value="{{ old('co_owner_mobile') }}">
                                        <label for="co_owner_mobile" id="co_owner_mobile_lbl">Mobile<span
                                                class="red-star"></span></label>
                                        @error('co_owner_mobile')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s2 ">
                                        <input id="co_owner_email" name="co_owner_email" type="email"
                                            value="{{ old('co_owner_email') }}">
                                        <label for="co_owner_email" id="co_owner_email_lbl">Email<span
                                                class="red-star"></span></label>
                                        @error('co_owner_email')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>




                                    <div class="input-field col s3">

                                        <select class="browser-default select2" name="co_owner_identity_card"
                                            id="co_owner_identity_card">
                                            <option value=""> Choose </option>
                                            <option value="Passport" @if (old('co_owner_identity_card') == 'Passport') selected @endif>
                                                Passport</option>
                                            <option value="Voter ID" @if (old('co_owner_identity_card') == 'Voter ID') selected @endif>
                                                Voter ID</option>
                                            <option value="Driving License"
                                                @if (old('co_owner_identity_card') == 'Driving License') selected @endif> Driving License
                                            </option>

                                        </select>
                                        <label>Proof of Identity</label>
                                        @error('co_owner_identity_card')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>


                                    <div class="input-field col s3 ">
                                        <input id="co_owner_identity_card_no" name="co_owner_identity_card_no"
                                            type="text" value="{{ old('co_owner_identity_card_no') }}">
                                        <label for="co_owner_identity_card_no" id="co_owner_identity_card_no_lbl">ID
                                            Number<span class="red-star"></span></label>
                                        @error('co_owner_identity_card_no')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                </div>
                                {{-- <h3>Contact Person</h3> --}}


                                <div class="row">

                                    <h5 class="ld-title col s12 "style="margin-top:15px;">

                                        <span
                                            style=" display:inline-block;border-bottom:1px solid black;padding-bottom:2px;">
                                            <b>Contact Person</b></span>
                                        {{-- <hr style="background-color:#152b52;border:1px solid; width:22%;"> --}}

                                    </h5>

                                </div>


                                <div class="row m-t-40">




                                    <div class="input-field col s2">

                                        <select class="browser-default select2" name="contact_person_name_prefix"
                                            id="contact_person_name_prefix">
                                            <option value=""> Choose </option>

                                            <option value="Mr."
                                                @if (old('contact_person_name_prefix') == 'Mr.') selected="selected" @endif>Mr
                                            </option>
                                            <option value="Mrs."
                                                @if (old('contact_person_name_prefix') == 'Mrs.') selected="selected" @endif>
                                                Mrs</option>
                                            <option value="Ms."
                                                @if (old('contact_person_name_prefix') == 'Ms.') selected="selected" @endif>
                                                Ms</option>

                                            <option value="Dr."
                                                @if (old('contact_person_name_prefix') == 'Dr.') selected="selected" @endif>
                                                Dr</option>
                                        </select>
                                        <label>Abbreviation</label>
                                        @error('contact_person_name_prefix')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>


                                    <div class="input-field col s4 ">
                                        <input id="contact_person_name" name="contact_person_name" type="text"
                                            value="{{ old('contact_person_name') }}">
                                        <label>Contact Person Name</label>
                                        @error('contact_person_name')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s3">

                                        <select class="browser-default select2" name="contact_person_phone_code"
                                            id="contact_person_phone_code">
                                            <option value=""> Choose </option>
                                            @foreach ($country_codes as $code)
                                                <option value="{{ $code->phonecode }}"
                                                    @if (old('contact_person_phone_code') == $code->phonecode) selected="selected" @endif>
                                                    {{ $code->phonecode }} </option>
                                            @endforeach

                                        </select>
                                        <label>Phone Code</label>
                                        @error('contact_person_phone_code')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>


                                    <div class="input-field col s3 ">
                                        <input id="contact_person_mobile" name="contact_person_mobile" type="number"
                                            min="1" value="{{ old('contact_person_mobile') }}">
                                        <label for="contact_person_mobile" id="contact_person_mobile_lbl">Mobile<span
                                                class="red-star"></span></label>
                                        @error('contact_person_mobile')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>




                                    <div class="input-field col s4">
                                        <textarea name="contact_person_address" id="contact_person_address" class="materialize-textarea"
                                            value="{{ old('contact_person_address') }}"></textarea>
                                        <label for="contact_person_address">Present Address (if Any) </label>

                                        <span class="invalid-feedback red" role="alert"
                                            id="contact_person_address_error">

                                        </span>


                                    </div>

                                    <div class="input-field col s3 ">
                                        <input id="contact_person_pincode" name="contact_person_pincode" type="number"
                                            min="1" value="{{ old('contact_person_pincode') }}">
                                        <label for="contact_person_pincode" id="contact_person_pincode_lbl">Pin Code<span
                                                class="red-star"></span></label>
                                        @error('contact_person_pincode')
                                            <span class="invalid-feedback text-red" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>


                                </div>

                                <div class="col l12">

                                    <div class="success-alert-bar p-15 m-b-20 green white-text status"
                                        style="display: none;"></div>

                                </div>

                                <div class="loading" style="display:none"><img
                                        src="{{ asset('assets/images/loading.gif') }}">

                                </div>

                                <button
                                    class="btn cyan waves-effect waves-light left sub-btn-proposel-update m-t-40 m-b-20"
                                    type="submit">Register

                                </button>

                            </form>

                        </div>

                        {{-- </form> --}}

                    </div>

                </div>

            </div>

        </div>

    </div>

    </div>
@endsection

@section('js')
    <script>
        $(document).ready(function() {

            //    var a= {{ json_encode(session()->getOldInput('unit_id')) }};


            $('.select2').each(function() {
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent()
                });
            });

            var date = new Date();
            var today = new Date(date.getFullYear(), date.getMonth(), date.getDate());
            $('.M_Datepicker').datepicker({
                format: 'dd-mm-yyyy',
                maxDate: today,
                autoClose: true,
                yearRange: 100,
            });




            coOwnerAge();
            checkAge();
            getUnits();

            $('#project_id').change(function() {
                getUnits();
            });
        });



        function getUnits() {
            $('#unit_id').html('');

            var project_id = $('#project_id').val();
            if (project_id != '') {
                $.ajax({
                    url: '{{ route('registration.project.units') }}',
                    method: "POST",
                    data: {
                        _token: '{{ csrf_token() }}',
                        project_id: project_id
                    },
                    dataType: "json",
                    success: function(response) {
                        var data = response.data;

                        if (data.length > 0) {

                            $('#unit_id').val('2').trigger('change');

                            var unitOldValue = {!! json_encode(session()->getOldInput('unit_id')) !!};

                            $('#unit_id').append('<option value=""> Choose Unit</option>');
                            $.each(data, function(index, value) {
                                // $('#unit_id').append('<option value="' + value['id'] +
                                //     '">' +
                                //     value['ap_no'] + '</option>');

                                if (unitOldValue == value['id']) {
                                    $('#unit_id').append('<option value="' + value['id'] +
                                        '" selected>' +
                                        value['ap_no'] + '</option>');

                                } else {
                                    $('#unit_id').append('<option value="' + value['id'] +
                                        '">' +
                                        value['ap_no'] + '</option>');
                                }
                            });
                        } else {
                            $('#unit_id').append('<option value=""> Choose Unit</option>');

                        }
                        $('#unit_id').formSelect();
                    }
                });
            }
        };


        $('#dob').on('change', function(e) {
            checkAge();
        });

        function checkAge() {
            var dob = $('#dob').val();
            if (dob) {

                var reverseDate = dob.split("-").reverse().join("-");
                var newDate = new Date(reverseDate);
                var today = new Date();
                var age = Math.floor((today - newDate) / (365.25 * 24 * 60 * 60 * 1000));
                $('#age').val(age);
                $('#age').focus();

            }
        }
        $('#co_owner_dob').on('change', function(e) {
            coOwnerAge();
        });

        function coOwnerAge() {
            var dob = $('#co_owner_dob').val();
            if (dob) {
                var reverseDate = dob.split("-").reverse().join("-");
                var newDate = new Date(reverseDate);
                var today = new Date();
                var age = Math.floor((today - newDate) / (365.25 * 24 * 60 * 60 * 1000));
                $('#co_owner_age').val(age);
                $('#co_owner_age').focus();



            }
        }
    </script>
@endsection
