@extends('dashboard.layouts.app')
@section('css')
    <style>
        label {
            top: -34px !important;
        }

        /* label.active{ top:-34px !important;} */
        label.active {
            transform: translate(10px, 10px) !important;
        }

        input {
            width: 100%;
            height: 3rem;
        }

        .select2-container--material .select2-results>.select2-results__options {
            max-height: 100px;
            overflow-y: auto;
        }

        .red-text {
            color: rgba(255, 0, 0, 0.726);
        }

        /* .datepicker-controls .select-month input {
                        width: 80px;
                    } */
    </style>
@endsection
@section('content')
    <div class="page-titles">

        <h5 class="font-medium m-b-0">Registrations</h5><br>

        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0 leadbutton">
                {{-- @if (\Auth::user()->checkPermission(''))
                    <a class="waves-effect waves-light btn purple  export-btn m-l-5" id="export-btn">Export</a>
                @endif --}}
                <button class="waves-effect btn font-medium m-l-5" onclick="showAddFilters()" id="add_filter_btn">Add
                    Filters</button>
                <button class="waves-effect waves-light btn  clear-btn font-medium m-l-5"
                    style="background-color: #be9833;display:none;" id="clear_filter_btn" onclick="hideAddFilters()">Clear
                    Filters</button>
            </h5>
            {{-- <div class="custom-breadcrumb ml-auto">
                <a href="{{ url('/dashboard') }}" class="breadcrumb">Home</a>
                <a href="{{ url('/dashboard/leads/listing/' . $stage) }}" class="breadcrumb">Leads</a>
            </div> --}}
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div style="display: none;" id="add_filter_card">
                    <div class="card" style="">
                        <div class="card-body p-t-30">
                            <form name="s_search_form" id="s_search_form" action="" method="post">
                                {{ csrf_field() }}


                                <div class="col  s3">
                                    <div class="input-field">
                                        <label>From </label>
                                        <input type="text" name="s_from" id="s_from" class="datepicker1"
                                            placeholder="Date" autocomplete="off">
                                    </div>
                                </div>
                                <div class="col s3">
                                    <div class="input-field">
                                        <label>To </label>
                                        <input type="text" name="s_to" id="s_to" class="datepicker1"
                                            placeholder="Date" autocomplete="off">
                                    </div>
                                </div>

                                <div class="row ">
                                    {{-- <div class="col 12 m2 s12"> --}}
                                    <div class="input-field col s2" style="float: right;">
                                        <button type="" name="" id="btn_filter_clear"
                                            class="btn waves-effect waves-light">Clear</button>
                                    </div>
                                    <div class="input-field col s2" style="float: right;">
                                        <label>&nbsp;</label>
                                        <button type="submit" name="search_btn" id="search_btn"
                                            class="btn  waves-effect waves-light">Search</button>
                                    </div>
                                    {{-- 
                                    @if (\Auth::user()->checkPermission(''))
                                        <div class="input-field col s1 ">
                                            <div class=""><input type="button" id="export-btn"
                                                    value="Export" class="btn  export-btn"></div>
                                        </div>
                                    @endif --}}
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="card yjra">
                    <div class="card-content">

                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        @if ($message = Session::get('error'))
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                {{ $message }}
                            </div>
                        @endif

                        <table id="registrationTable" class="responsive-table compact  display nowrap "
                            style="width:100%;border-bottom:none;">
                            <thead class="">
                                <tr>
                                    <th>
                                        Name
                                    </th>
                                    <th>Project</th>
                                    <th>Unit</th>
                                    <th>
                                        Mobile
                                    </th>
                                    <th>
                                        Action
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>




                        {{-- pdf form  --}}

                        <form id="pdf_form_dowload" method="post"
                            action="{{ route('registration.project.form.download') }}" target="_blank">
                            {{ csrf_field() }}
                            <input type="hidden" name="registration_id" id="registration_id">
                        </form>


                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    {{-- <link href="//cdn.datatables.net/responsive/2.2.3/css/responsive.dataTables.min.css" rel="stylesheet">
<script src="//cdn.datatables.net/responsive/2.2.3/js/dataTables.responsive.min.js"></script> --}}
    <script>
        function formatDesign(item) {
            var selectionText = item.text.split(".");
            var $returnString = selectionText[0] + "," + selectionText[1];
            return $returnString;
        };
        $(document).ready(function() {
            // $('.slct2').select2({width: "100%"});
            //    $(".select2").select2({
            //     placeholder: "Choose your option",
            //     theme: "material"
            // });
            $('.select2').each(function() {
                width: "100%",
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent(),
                    format: formatDesign
                });
            });
            $(".select2-selection__arrow")
                .addClass("material-icons")
                .html("arrow_drop_down");

            var registrationTable = $('#registrationTable').DataTable({
                processing: true,
                serverSide: true,
                // pageLength: 10,
                paging: true,
                responsive: true,
                scrollX: false,
                autowidth: false,
                ajax: {
                    url: "{{ url('dashboard/registration-form/list') }}",
                    data: function(d) {

                        d.s_from = $('#s_from').val();
                        d.s_to = $('#s_to').val();

                    }
                },

                columns: [
                    //    {data: 'DT_RowIndex', name: 'DT_RowIndex'},
                    {
                        data: 'name',
                        name: 'name',
                        orderable: false
                    },
                    {
                        data: 'project',
                        name: 'project',
                        orderable: false
                    },
                    {
                        data: 'unit',
                        name: 'unit.ap_no',
                        orderable: false,
                        searchable:true
                    },


                    {
                        data: 'mobile',
                        name: 'mobile'
                    },

                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                "order": [
                    [1, "desc"]
                ],
                "drawCallback": function(settings) {

                    $('.dropdown-trigger').dropdown();
                },
                //dom: 'lBfrtip',//to hide lengthmenu dropdown use dom:Bfrtip

                lengthMenu: [
                    [10, 25, 50, 100, -1],
                    ['10 rows', '25 rows', '50 rows', '100 rows', 'Show all']
                ],
            });

            $('.input-field').each(function() {
                $(this).change(function() {
                    $(this).find('.red').html('');
                });
            });

            var date = new Date();
            var today = new Date(date.getFullYear(), date.getMonth(), date.getDate());
            $('.datepicker1').datepicker({
                // format: "dd-mm-yyyy",
                format: "yyyy-mm-dd",
                // maxDate: today,
                showClearBtn: true,
                container: 'body',
                autoClose: true,
            });
            $('#search_btn').click(function(e) {
                e.preventDefault();
                registrationTable.draw();
            });
            $('#btn_filter_clear').click(function(e) {
                $('#s_from').val('');
                $('#s_to').val('');
                e.preventDefault();
                registrationTable.draw();
            })
            $(".export-btn").click(function() {
                var action = site_url + '/dashboard/leads/export';
                $('#s_search_form').attr('action', action);
                // var s_from = $('#s_from').val();
                // var s_to = $('#s_to').val();
                // if (s_from == "") {
                //     alert("Please choose a from date");
                // } else if (s_to == "") {
                //     alert("Please choose a to date");
                // } else {
                //     $('#s_search_form').attr('action', action);
                //     $('#s_search_form').submit();
                // }
                $('#s_search_form').attr('action', action);
                $('#s_search_form').submit();
            });


        }); //end ready
        jQuery(".phno").keypress(function(e) {
            var value = jQuery(this).val();
            var charCode = (e.which) ? e.which : e.keyCode;
            if ((charCode < 48 || charCode > 57))
                return false;
            if (value != '') {
                if (value.length >= 12) {
                    e.preventDefault();
                }
            }
        });

        /*add-filters-btn-start*/
        function showAddFilters() {
            $('#add_filter_card').show();
            $('#add_filter_btn').hide();
            $('#clear_filter_btn').show();
            $('#s_from').val('');
            $('#s_to').val('');
        }

        function hideAddFilters() {
            $('#add_filter_card').hide();
            $('#add_filter_btn').show();
            $('#clear_filter_btn').hide();
            $('#btn_filter_clear').click();
        }



        function downloadPDF(id) {
            $("#registration_id").val(id);
            document.getElementById("pdf_form_dowload").submit();
        }
        /*add-filters-btn-end*/
    </script>
@endsection
