@extends('dashboard.layouts.app')
@section('css')
    {{-- <style>
  .hide{ display: none;}
  label{ width:100%;}
</style> --}}
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Roles</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ url('/dashboard') }}" class="breadcrumb">Home</a>
                <a href="{{ url('/dashboard/roles') }}" class="breadcrumb">Roles</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
         
                <div class="card">
                    <div class="card-content">
                        <h5 class="card-title activator">Add Role</h5>
                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        @if (count($errors) > 0)
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        <form method="post" action="{{ url('dashboard/roles/store') }}" enctype="multipart/form-data"
                            class="formValidate" id="formValidate">
                            {{ csrf_field() }}
                            <div class="row">
                                <div class="input-field col s12">
                                    <input id="name" type="text" name="name" value="{{ old('name') }}"
                                        required>
                                    <label for="name">Name</label>
                                    @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="row">
                                <div class="input-field col s12">
                                    <input id="slug" type="text" name="slug" value="{{ old('slug') }}"
                                        required>
                                    <label for="email">Slug</label>
                                    @error('slug')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="row ">
                                <div class="input-field col s4  ">
                                    <p class="">
                                        <label>
                                            <input type="checkbox" class="form-check-input right"
                                                name="main_permissions_checkbox" />
                                            <span>{{ 'Select All' }}</span>
                                        </label>
                                    </p>
                                </div>
                            </div>
                            <div class="row">
                                <h5><b>Leads</b></h5>
    
                            </div>

                            <label for="permission" class="active">Permissions</label>
                            <div class="row ">
                               
                                    @foreach ($leadsPermissions as $value)
                                    <div class="input-field col s4 ">
                                        <p>
                                            <label class="">
                                                <input type="checkbox" name="permission[]" value="{{ $value->id }}" />
                                                <span>{{ $value->name }}</span>
                                            </label>
                                        </p>
                                        {{-- <label><input type="checkbox" name="permission[]" value="{{$value->id}}"></label> --}}
                                        <br />
                                    </div>
                                    @endforeach

                                    @error('permission')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                           



<hr>
                              <!--CRM-PERMISSIONS-->
                        <div class="row">
                            <h5><b>CRM</b></h5>

                        </div>


                            <label for="permission" class="active">Permissions</label>
                            <div class="row ">
                                
                                    @foreach ($crmPermissions as $value)
                                    <div class="input-field col s4 ">
                                        <p>
                                            <label class="">
                                                <input type="checkbox" name="permission[]" value="{{ $value->id }}" />
                                                <span>{{ $value->name }}</span>
                                            </label>
                                        </p>
                                        {{-- <label><input type="checkbox" name="permission[]" value="{{$value->id}}"></label> --}}
                                        <br />
                                    </div>
                                    @endforeach

                                    @error('permission')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>



                            <div class="row">
                                <div class="input-field col s12">
                                    <button class="btn cyan waves-effect waves-light right" type="submit"
                                        name="action">Submit
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
           
        </div>
    </div>
@endsection
@section('js')
    <script>
        // Checkbox All Select 
        $(document).on('click', 'input[name="main_permissions_checkbox"]', function() {
            if (this.checked) {
                $('input[name="permission[]"]').each(function() {
                    this.checked = true;
                });
            } else {
                $('input[name="permission[]"]').each(function() {
                    this.checked = false;
                });
            }

        });


        $(document).on('change', 'input[name="permission[]"]', function() {
            if ($('input[name="permission[]"]').length == $('input[name="permission[]"]:checked').length) {
                $('input[name="main_permissions_checkbox"]').prop('checked', true);
            } else {
                $('input[name="main_permissions_checkbox"]').prop('checked', false);
            }


        });
        $(document).ready(function() {
            $('input[name="permission[]"]').change();
        });
    </script>
@endsection
