@extends('dashboard.layouts.app')
@section('css')
{{-- <style>
  .hide{ display: none;}
  label{ width:100%;}
</style> --}}
@endsection
@section('content')
<div class="page-titles">
  <div class="d-flex align-items-center">
      <h5 class="font-medium m-b-0">Roles</h5>
      {{-- <div class="custom-breadcrumb ml-auto">
          <a href="{{url('/dashboard')}}" class="breadcrumb">Home</a>
          <a href="{{url('/dashboard/roles')}}" class="breadcrumb">Roles</a>
      </div> --}}
  </div>
</div>
<div class="container-fluid">
  <div class="row">
      <div class="col s12 l12">
          <div class="card">
              <div class="card-content">
                @if(\Auth::user()->checkPermission('create-role'))
                <h5 class="card-title activator"><a class="waves-effect waves-light btn" href="{{url('/dashboard/roles/create')}}">Add Role</a></h5>
                @endif
                  @if ($message = Session::get('success') )
                  <div class="success-alert-bar p-15 m-b-20 green white-text">
                    {{ $message }}
                </div>
            
              @endif
              <table id="zero_config" class="responsive-table display" style="width:100%">
                <thead>
                    <tr>
                        <th>
                            #
                        </th>
                        <th>
                             Name
                        </th>
                        <th>
                            Slug
                        </th>
                        <th>
                            Permissions
                        </th>
                        @if (auth()->user()->checkPermission('edit-role') )
                        <th></th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @if(count($rows)>0)
                    @php
                    $i = 1;
                    @endphp
                    @foreach($rows as $row)
                    <tr id="role_{{$row->id}}">
                        <td>
                           {{ $i}}
                        </td>
                        <td>
                            <a>
                               {{$row->name}}
                            </a>
                            <br/>
                            <small>
                                Created {{ $row->created_at}}
                            </small>
                        </td>
                        <td>
                            {{ $row->slug}}
                         </td>
                         <td>
                            @if(isset($row->permissions) && count($row->permissions))
                            @php $ar = [];
                            @endphp
                            @foreach($row->permissions as $p)
                            @php $ar[] = $p->name;
                            @endphp
                            @endforeach
                            @php echo join(',',$ar);
                            @endphp

                            @endif
                         </td>
                         
                         @if (auth()->user()->checkPermission('edit-role') )
                        <td class="project-actions text-right">
                            
                            <a class="btn btn-info btn-sm" href="{{ url('/dashboard/roles/edit/'.$row->id)}}" @if(
                                !\Auth::user()->hasRole('super-admin')) disabled @endif>
                                <i class="fas fa-pencil-alt">
                                </i>
                                Edit
                            </a>
                            {{-- <a class="btn btn-danger btn-sm deleteRecord" href="javascript:void(0)" data-id="{{ $row->id }}" @if(!\Auth::user()->hasRole('super-admin')) disabled @endif> 
                                <i class="fas fa-trash">
                                </i>
                                Delete
                            </a>--}}
                        </td>
                        @endif
                    </tr>
                    @php
                        $i++;
                    @endphp
                    @endforeach
                    @endif
                    
                </tbody>
            </table>



      

              </div>
          </div>
      </div>
  </div>
</div>
@endsection
