@extends('dashboard.layouts.app')
@section('css')
    <style>
        .invalid-feedback {
            color: red;
        }
    </style>
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Users</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ url('/dashboard') }}" class="breadcrumb">Home</a>
                <a href="{{ url('/dashboard/users') }}" class="breadcrumb">Users</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card">
                    <div class="card-content">
                        <h5 class="card-title activator">Add User</h5>
                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        {{-- @if (count($errors) > 0)
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif --}}
                        <div class="row">
                            <form method="post" action="{{ url('dashboard/users/store') }}" enctype="multipart/form-data"
                                class="formValidate" id="formValidate">
                                <div class="col s12 l6">
                                    {{ csrf_field() }}
                                    <div class="row">
                                        <div class="input-field col s12">
                                            <input id="name" type="text" name="name" value="{{ old('name') }}"
                                                required>
                                            <label for="name">Name</label>
                                            @error('name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="input-field col s12">
                                            <input id="password" type="password" name="password"
                                                value="{{ old('password') }}" required>
                                            <label for="password">Password</label>
                                            @error('password')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="input-field col s12">
                                            <input id="mobile" type="text" name="mobile" value="{{ old('mobile') }}"
                                                required>
                                            <label for="mobile">Mobile</label>
                                            @error('mobile')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>


                                    <div class="row">



                                        <div class="input-field col l6 m6 s12">
                                            <select name="reporting_to" id="reporting_to" class="browser-default select2">
                                                <option value="">Choose your option</option>
                                                @foreach ($reporting_to as $r)
                                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                                @endforeach
                                            </select>
                                            <label for="reporting_to" class="active">Reporting To</label>
                                            @error('reporting_to')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror

                                        </div>

                                        <div class="input-field col l6 m6 s12">
                                            <select name="branch_id" id="branch_id" class="browser-default select2">
                                                <option value="">Choose your option</option>
                                                @foreach ($branches as $branch)
                                                    <option value="{{ $branch->id }}">
                                                        {{ $branch->name }}</option>
                                                @endforeach
                                            </select>
                                            <label for="branch_id" class="active">Branch</label>
                                            @error('branch_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror

                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="input-field col s12">
                                            <input id="designation" type="text" name="designation"
                                                value="{{ old('designation') }}" required>
                                            <label for="designation">Designation</label>
                                            @error('designation')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="input-field col s12">
                                            <button class="btn cyan waves-effect waves-light right" type="submit"
                                                name="action">Submit
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col s12 l6">
                                    <div class="row">
                                        <div class="input-field col s12">
                                            <input id="email" type="email" name="email" value="{{ old('email') }}"
                                                required>
                                            <label for="email">Email</label>
                                            @error('email')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="input-field col s12">
                                            <input id="password-confirm" type="password" name="password_confirmation"
                                                value="{{ old('password_confirmation') }}" required>
                                            <label for="password-confirm">Confirm Password</label>
                                            @error('password_confirmation')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="input-field col s12">
                                            <select name="role" id="role">
                                                <option value="" disabled selected>Choose your option</option>
                                                @foreach ($roles as $role)
                                                    <option value="{{ $role->id }}">{{ $role->name }}</option>
                                                @endforeach
                                            </select>
                                            <label for="role">Role</label>
                                            @error('role')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror

                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="file-field input-field col s12">
                                            <div class="btn">
                                                <span>Browse Image</span>
                                                <input type="file" name="file" id="file">
                                                <span id="file_error" class="error"></span>
                                            </div>
                                            <div class="file-path-wrapper">
                                                <input class="file-path validate" type="text">
                                            </div>
                                            @error('file')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror

                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="input-field col s12">
                                            <input id="username" type="text" name="username"
                                                value="{{ old('username') }}" required>
                                            <label for="username">Username</label>
                                            @error('username')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {
            $('.select2').each(function() {
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent()
                });
            });
            $(".select2-selection__arrow")
                .addClass("material-icons")
                .html("arrow_drop_down");
        });
    </script>
@endsection
