@extends('dashboard.layouts.app')
@section('css')
    <style>
        .invalid-feedback {
            color: #f00;
        }

        .text-danger {
            color: red;
        }
    </style>
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            {{-- <h5 class="font-medium m-b-0">Change Image</h5> --}}
            <h5 class="font-medium m-b-0">Update Profile</h5>

            <div class="custom-breadcrumb ml-auto">

                @if (auth()->user()->hasRole('lead-bank'))
                <a href="{{ url('/dashboard/leads/bank/listing') }}" class="breadcrumb">Home</a>
                @else
                <a href="{{ url('/dashboard') }}" class="breadcrumb">Home</a>
                @endif
                <a href="#" class="breadcrumb">Profile</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card" style="min-height: 70vh;">
                    <div class="card-content">
                        {{-- <h5 class="card-title activator">Add User</h5> --}}
                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif

                        @if ($message = Session::get('error'))
                        <div class="error-alert-bar p-15 m-b-20 red white-text">
                            {{ $message }}
                        </div>
                    @endif







                        <div class="row">
                            <div class="col s12">
                                <ul class="tabs">
                                    <li class="tab col s3"><a
                                            class="{{ $errors->has('current_password') || $errors->has('new_password') || $errors->has('new_confirm_password') || Session::get('password-change') ? '' : 'active' }}"
                                            href="#profile_details">Profile Details</a>
                                    </li>
                                    <li class="tab col s3"><a href="#password_change"
                                            class=" {{ $errors->has('current_password') || $errors->has('new_password') || $errors->has('new_confirm_password') || Session::get('password-change') ? 'active' : '' }}">Change
                                            Password</a></li>

                                </ul>
                            </div>


                            <div id="profile_details" class="col s12">

                                <div class="card" style="height:60vh;">
                                    <div class="row">


                                        <div id="settings" class="col s12">
                                            <div class="card-content">
                                                <form action="{{ route('user.updateProfile') }}"
                                                    enctype="multipart/form-data" method="POST">
                                                    @csrf
                                                    <div class="row">

                                                        <input type="hidden" value="{{ $user->id }}" name="user_id">
                                                        <div class="input-field col l6 m6 s12">
                                                            <input id="name" type="text" name="name"
                                                                value="{{ $user->name }}">
                                                            <label for="name" class="active">Name</label>

                                                            @error('name')
                                                                <span class="invalid-feedback text-red" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>

                                                        <div class="input-field col l6 m6 s12">
                                                            <input id="username" type="text" name="username"
                                                                value="{{ $user->username }}" readonly>
                                                            <label for="username" class="active">Username</label>

                                                            @error('username')
                                                                <span class="invalid-feedback text-red" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>



                                                    <div class="row">


                                                        <div class="input-field col s4 m2 l2">
                                                            <select name="phone_code" id="phone_code"
                                                                class="browser-default select2">
                                                                <option value="">Choose your option</option>
                                                                @foreach ($countries as $code)
                                                                    <option value="{{ $code->phonecode }}"
                                                                        @if ($code->phonecode == $user->phone_code) selected="selected" @endif>
                                                                        {{ $code->phonecode }}</option>
                                                                @endforeach
                                                            </select>
                                                            <label for="phone_code" class="active">Country Code</label>
                                                            @error('phone_code')
                                                                <span class="invalid-feedback text-red" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror

                                                        </div>


                                                        <div class="input-field col l4 m4 s12">
                                                            <input id="mobile" type="number"
                                                                value="{{ $user->mobile }}" name="mobile">
                                                            <label for="mobile" class="active">Mobile No.</label>

                                                            @error('mobile')
                                                                <span class="invalid-feedback text-red" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>


                                                        
                                                        <div class="input-field col l6 m6 s12">
                                                            <input id="designation" type="text"
                                                                value="{{ $user->designation }}" name="designation">
                                                            <label for="designation" class="active">Designation</label>

                                                            @error('designation')
                                                                <span class="invalid-feedback text-red" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>



                                                    </div>






                                                    <div class="row">
                                                        <div class="input-field col l6 m6 s12">
                                                            <input id="email" type="email"
                                                                value="{{ $user->email }}" name="email">
                                                            <label for="email" class="active">Gmail ID</label>

                                                            @error('email')
                                                                <span class="invalid-feedback text-red" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>

                                                        <div class="input-field col l6 m6 s12">
                                                            <input id="gmail_password" type="password" name="gmail_password"
                                                                value="{{ $user->email_password }}">
                                                            <label for="gmail_password" class="active">Gmail
                                                                Password</label>

                                                            @error('gmail_password')
                                                                <span class="invalid-feedback text-red" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>

                                                    </div>

                                                    <small class="text-danger"><b>*</b> For sending emails from your
                                                        account, you need to change your
                                                        Google account settings by following the links : </small>
                                                    <span class="m-l-10 m-r-10"> <a
                                                            href="https://www.google.com/settings/u/1/security/lesssecureapps"
                                                            target="_blank"> Link 1</a></span>
                                                    |
                                                    <span class="m-l-10"> <a
                                                            href="https://accounts.google.com/b/0/DisplayUnlockCaptcha"
                                                            target="_blank"> Link 2</a></span>



                                                    <div class="row m-t-20">
                                                        <div class="file-field input-field col l11 m11 s12">
                                                            <div class="btn">
                                                                <span>Upload Profile Image</span>
                                                                <input type="file" name="image" id="image">


                                                            </div>

                                                            <div class="file-path-wrapper">
                                                                <input class="file-path validate" type="text"
                                                                    placeholder="Min height and width 200*200 | Max height and width 250*250 ">
                                                            </div>
                                                        </div>

                                                        @if ($user->image)
                                                            <div class="col l1 m1 s12">
                                                                <img src="{{ asset('uploads/' . $user->image) }}"
                                                                    class="circle" width="60">
                                                            </div>
                                                        @endif



                                                    </div>
                                                    
                                                    @error('image')
                                                        <span class="invalid-feedback text-red" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror


                                                    <div class="row m-t-40 right m-b-40">
                                                        <div class="input-field col s12">
                                                            <button class="btn " type="submit" name="action">Update
                                                            </button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div id="password_change" class="col s12">
                                <div class="card" style="height:60vh;">
                                    <div class="row">


                                        <div id="" class="col s12">
                                            <div class="card-content">
                                                <form action="{{ route('user.changePassword') }}"
                                                    enctype="multipart/form-data" method="POST">
                                                    @csrf
                                                    <input type="hidden" value="{{ $user->id }}" name="user_id">

                                                    <div class="row">
                                                        <div class="input-field col l12 m12 s12">
                                                            <input id="current_password" type="password" value=""
                                                                name="current_password">
                                                            <label for="current_password" class="active">Current
                                                                Password</label>
                                                            @error('current_password')
                                                                <span class="invalid-feedback text-red" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>

                                                        <div class="input-field col l12 m12 s12">
                                                            <input id="new_password" type="password" value=""
                                                                name="new_password">
                                                            <label for="new_password" class="active">New Password</label>
                                                            @error('new_password')
                                                                <span class="invalid-feedback text-red" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>

                                                        <div class="input-field col l12 m12 s12">
                                                            <input id="new_confirm_password" type="password"
                                                                value="" name="new_confirm_password">
                                                            <label for="new_confirm_password" class="active">Confirm New
                                                                Password</label>

                                                            @error('new_confirm_password')
                                                                <span class="invalid-feedback text-red" role="alert">
                                                                    <strong>{{ $message }}</strong>
                                                                </span>
                                                            @enderror
                                                        </div>
                                                    </div>





                                                    <div class="row m-t-40 right m-b-40">
                                                        <div class="input-field col s12">
                                                            <button class="btn " type="submit" name="action">Update
                                                                Password
                                                            </button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="col s12">










                            </div>







                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection





@section('js')
    <script>
        $(document).ready(function() {
            // var urlParams = new URLSearchParams(window.location.search);
            // alert(urlParams.toString());

            $('.select2').each(function() {
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent()
                });
            });
        });
    </script>
@endsection
