@extends('dashboard.layouts.app')
@section('css')
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Bill Details Entry (Variable Charges)</h5>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                        </div>

                        <form method="post" action="" class="formValidate" id="formValidate" name="formValidate">
                            @csrf
                            <div class="row">
                                <div class="input-field col s12 m3 project-type-wrapper">
                                    <select name="project" id="project" class="browser-default select2" required>
                                        <option value="">---Select---</option>
                                        @foreach ($projects as $project)
                                            <option value="{{ $project->id }}">{{ $project->project_name }}</option>
                                        @endforeach
                                    </select>
                                    <label for="project" style="color: red" class="active">Project<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m3 project-type-wrapper">
                                    <select name="lessee" id="lessee" class="browser-default select2" required>
                                        <option value="">---Select---</option>
                                        @foreach ($lessees as $lessee)
                                            @if ($lessee->lessee_type == 'Individual')
                                                <option value="{{ $lessee->id }}">{{ $lessee->individual_name }}</option>
                                            @elseif($lessee->lessee_type == 'Company')
                                                <option value="{{ $lessee->id }}">{{ $lessee->company_name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    <label for="lessee" style="color: red" class="active">Lessee<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m3 project-type-wrapper">
                                    <select name="rate_item" id="rate_item" class="browser-default select2" required>
                                        <option value="">---Select---</option>
                                        @foreach ($rate_items as $rate_item)
                                            <option value="{{ $rate_item->id }}">{{ $rate_item->rate_item_name }}</option>
                                        @endforeach
                                    </select>
                                    <label for="rate_item" style="color: red" class="active">Rate Item<span
                                            class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m3 project-type-wrapper">
                                    <input type="text" name="quantity" id="quantity">
                                    <label for="quantity" style="color: red">Quantity<span class="red-star"></span></label>
                                </div>

                            </div>

                            <div class="row">
                                <div class="input-field col s12 m3 project-type-wrapper">
                                    <input type="submit" class="btn">
                                </div>
                            </div>

                        </form>
                    </div>
                    <hr>
                    <div class="card-content">
                        <table>
                            <thead>
                                <tr>
                                    <th>S No.</th>
                                    <th>Select</th>
                                    <th>Lessee Name</th>
                                    <th>Rate item</th>
                                    <th>Rate Calculation Method</th>
                                    <th>Total</th>
                                    <th>GST Rate</th>
                                    <th>GST Amount</th>
                                    <th>TDS Rate</th>
                                    <th>TDS Amount</th>
                                    <th>Other Taxes</th>
                                    <th>Net Amount</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#automatic_numbering_div').hide();
            $('.select2').each(function() {
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent()
                });
            });
        });
    </script>
@endsection
