@extends('dashboard.layouts.app')
@section('css')
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Lease Rental Agreement</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ route('dashboard.home') }}" class="breadcrumb">Home</a>
                <a href="#" class="breadcrumb">Lease and Rental</a>
                <a href="#" class="breadcrumb">Lease Rental Agreement</a>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                        </div>
                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        @if ($message = Session::get('error'))
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                {{ $message }}
                            </div>
                        @endif
                        <br>

                        <div>
                            <a href="{{ route('mall-software.lease_rental_agreement.create') }}" class="btn">Create</a>
                        </div>

                        <div class="table-responsive">
                            <table id="lease_rental_table" class="display nowrap" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>SL No.</th>
                                        <th>Agreement Number</th>
                                        <th>Lessee Name</th>
                                        <th>Project Name</th>
                                        <th>Project Unit</th>
                                        <th>Agreement Date</th>
                                        <th>Agreement Period From</th>
                                        <th>Agreement Period To</th>
                                        <th>Registration Charges</th>
                                        <th>Notice Period (in months)</th>
                                        <th>Rent Start Date</th>
                                        <th>Approval Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {
            var lease_rental_table = $('#lease_rental_table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10,
                paging: true,
                responsive: true,
                scrollX: false,
                ajax: {
                    url: "{{ route('mall-software.lease_rental_agreement.list') }}",
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'agreement_no',
                        name: 'agreement_no'
                    },
                    {
                        data: 'lessee_name',
                        name: 'lessee_name'
                    },
                    {
                        data: 'project_name',
                        name: 'project_name'
                    },
                    {
                        data: 'project_unit',
                        name: 'project_unit'
                    },
                    {
                        data: 'agreement_date',
                        name: 'agreement_date'
                    },
                    {
                        data: 'agreement_period_from',
                        name: 'agreement_period_from'
                    },
                    {
                        data: 'agreement_period_to',
                        name: 'agreement_period_to'
                    },
                    {
                        data: 'registration_charges',
                        name: 'registration_charges'
                    },
                    {
                        data: 'notice_period',
                        name: 'notice_period'
                    },
                    {
                        data: 'rent_start_date',
                        name: 'rent_start_date'
                    },
                    {
                        data: 'approval_status',
                        name: 'approval_status'
                    },
                    {
                        data: 'actions',
                        name: 'actions'
                    },
                ],
                // "order": [
                //     [1, "desc"]
                // ],
                "drawCallback": function(settings) {
                    //alert( 'DataTables has redrawn the table' );
                    $('.dropdown-trigger').dropdown();
                },
                //dom: 'lBfrtip',//to hide lengthmenu dropdown use dom:Bfrtip
                // Configure the drop down options.
                lengthMenu: [
                    [10, 25, 50, 100, -1],
                    ['10 rows', '25 rows', '50 rows', '100 rows', 'Show all']
                ],
            });
        });
    </script>
@endsection
