@extends('dashboard.layouts.app')
@section('css')
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Lease Agreement</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ route('dashboard.home') }}" class="breadcrumb">Home</a>
                <a href="#" class="breadcrumb">Lease and Rental</a>
                <a href="{{ route('mall-software.lease_rental_agreement') }}" class="breadcrumb">Lease Rental Agreement</a>
                <a href="#" class="breadcrumb">View Agreement Details</a>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                        </div>
                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        @if ($message = Session::get('error'))
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                {{ $message }}
                            </div>
                        @endif
                        <br>

                        {{-- <div>
                            <a href="{{ route('mall-software.lease_rental_agreement.create') }}" class="btn">Create</a>
                        </div> --}}

                        <div class="table-responsive">
                            <table id="lease_agreement_table" class="display nowrap" style="width:100%;">
                                <thead>
                                    <tr>
                                        <th>SL No.</th>
                                        <th>Type</th>
                                        <th>Rate Item Name</th>
                                        <th>Area</th>
                                        <th>Rate</th>
                                        <th>Total</th>
                                        <th>GST Rate</th>
                                        <th>GST Amount</th>
                                        <th>TDS Rate</th>
                                        <th>TDS Amount</th>
                                        <th>Net Amount</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {
            var lease_agreement_table = $('#lease_agreement_table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10,
                paging: true,
                responsive: true,
                scrollX: false,
                ajax: {
                    url: "{{ route('mall-software.lease_rental_agreement.viewAgreementList', $leaseRentalAgreement->id) }}",
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'rate_type',
                        name: 'rate_type'
                    },
                    {
                        data: 'rate_item_name',
                        name: 'rate_item_name'
                    },
                    {
                        data: 'area',
                        name: 'area'
                    },
                    {
                        data: 'rate',
                        name: 'rate'
                    },
                    {
                        data: 'total',
                        name: 'total'
                    },
                    {
                        data: 'gst_rate',
                        name: 'gst_rate'
                    },
                    {
                        data: 'gst_amount',
                        name: 'gst_amount'
                    },
                    {
                        data: 'tds_rate',
                        name: 'tds_rate'
                    },
                    {
                        data: 'tds_amount',
                        name: 'tds_amount'
                    },
                    {
                        data: 'net_amount',
                        name: 'net_amount'
                    },


                ],
                // "order": [
                //     [1, "desc"]
                // ],
                "drawCallback": function(settings) {
                    //alert( 'DataTables has redrawn the table' );
                    $('.dropdown-trigger').dropdown();
                },
                //dom: 'lBfrtip',//to hide lengthmenu dropdown use dom:Bfrtip
                // Configure the drop down options.
                lengthMenu: [
                    [10, 25, 50, 100, -1],
                    ['10 rows', '25 rows', '50 rows', '100 rows', 'Show all']
                ],
            });
        });
    </script>
@endsection
