@extends('dashboard.layouts.app')
@section('css')
    <style>
        #individualNationalityError,
        #companyNationalityError,
        #individual_pcountryError,
        #individual_pstateError,
        #individual_pdistrictError,
        #individual_ccountryError,
        #individual_cstateError,
        #individual_cdistrictError,
        #company_pcountryError,
        #company_pstateError,
        #company_pdistrictError,
        #company_ccountryError,
        #company_cstateError,
        #company_cdistrictError,
        .parsley-errors-list {
            margin-top: 8px;
            list-style-type: none;
            padding: 0;
            font-size: 1 rem;
        }
    </style>
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Edit Company Lessee Entry</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ route('dashboard.home') }}" class="breadcrumb">Home</a>
                <a href="#" class="breadcrumb">Lease and Rental</a>
                <a href="{{ route('mall-software.lessee_entry') }}" class="breadcrumb">Lessee Details</a>
                <a href="#" class="breadcrumb">Edit Company Lessee</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                        </div>
                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        @if ($message = Session::get('error'))
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                {{ $message }}
                            </div>
                        @endif

                        <div id="company_div">
                            <form method="post"
                                action="{{ route('mall-software.lessee_entry.companyLesseeUpdate', $lesseEntry->id) }}"
                                data-parsley-validate="">
                                @csrf
                                <input type="hidden" name="lessee_entry_type" value="Company">
                                <div class="row">
                                    <div class="input-field col s12 m4 project-type-wrapper">
                                        <input id="company_name" type="text" name="company_name"
                                            value="{{ $lesseEntry->company_name }}" required>
                                        <label for="company_name" class="active" style="color: red">Company
                                            Name<span class="red-star">*</span></label>
                                    </div>

                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input id="date_of_incorporation" type="date" name="date_of_incorporation"
                                            value="{{ $lesseEntry->company_date_of_incorporation }}" required>
                                        <label for="date_of_incorporation" class="active" style="color: red">Date
                                            of
                                            Incorporation<span class="red-star">*</span></label>
                                    </div>

                                    <div class="input-field col s12 m3 project-type-wrapper">
                                        <input id="company_contact" type="text" name="company_contact"
                                            value="{{ $lesseEntry->company_contact_number }}" required
                                            data-parsley-type="integer">
                                        <label for="company_contact" class="active" style="color: red">Company
                                            Contact Number<span class="red-star">*</span></label>
                                    </div>

                                    <div class="input-field col s12 m3 project-type-wrapper">
                                        <select name="company_nationality" id="company_nationality"
                                            data-parsley-errors-container="#companyNationalityError"
                                            class="browser-default select2" required>
                                            <option value="">---Select---</option>
                                            <option value="Indian" @if ($lesseEntry->company_nationality == 'Indian') selected @endif>Indian
                                            </option>
                                            <option value="NRI" @if ($lesseEntry->company_nationality = 'NRI') selected @endif>NRI
                                            </option>
                                        </select>
                                        <label for="company_nationality" style="color: red" class="active">Company
                                            Nationality<span class="red-star">*</span></label>
                                        <span id="companyNationalityError"></span>

                                    </div>
                                </div>

                                <div class="row">

                                    <div class="input-field col s12 m3 project-type-wrapper">
                                        <input id="company_pan_number" type="text" name="company_pan_number"
                                            value="{{ $lesseEntry->company_pan_number }}" required>
                                        <label for="company_pan_number" class="active" style="color: red">Company
                                            PAN
                                            Number<span class="red-star">*</span></label>
                                    </div>

                                    <div class="input-field col s12 m3 project-type-wrapper">
                                        <input id="company_gst_number" type="text" name="company_gst_number"
                                            value="{{ $lesseEntry->company_gst_number }}">
                                        <label for="company_gst_number" class="active">Company GST
                                            Number</label>
                                    </div>

                                </div>
                                <hr>

                                <div class="row">

                                    <div id="company_address_div">

                                        <div class="input-field col s12 m6 project-type-wrapper">
                                            <input id="company_permanent_address" type="text"
                                                value="{{ $lesseEntry->company_permanent_address }}"
                                                name="company_permanent_address" required />
                                            <label for="company_permanent_address" class="active"
                                                style="color: red">Permanent
                                                Address*</label>

                                            <div class="input-field col s12 m6 project-type-wrapper">
                                                <select name="company_paddress_country" id="company_paddress_country"
                                                    data-parsley-errors-container="#company_pcountryError"
                                                    class="browser-default select2" required>
                                                    <option value="">---Select Country---</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            @if ($lesseEntry->company_permanent_country_id == $country->id) selected @endif>
                                                            {{ $country->name }}</option>
                                                    @endforeach
                                                </select>
                                                <label for="company_paddress_country" style="color: red"
                                                    class="active">Country<span class="red-star">*</span></label>
                                                <span id="company_pcountryError"></span>

                                            </div>

                                            <div class="input-field col s12 m6 project-type-wrapper">
                                                <select name="company_paddress_state" id="company_paddress_state"
                                                    data-parsley-errors-container="#company_pstateError"
                                                    class="browser-default select2" required>
                                                    <option value="">---Select State---</option>
                                                    @foreach ($pstates as $state)
                                                        <option value="{{ $state->id }}"
                                                            @if ($state->id == $lesseEntry->company_permanent_state_id) selected @endif>
                                                            {{ $state->name }}</option>
                                                    @endforeach
                                                </select>
                                                <label for="company_paddress_state" style="color: red"
                                                    class="active">State<span class="red-star">*</span></label>
                                                <span id="company_pstateError"></span>
                                            </div>

                                            <div class="input-field col s12 m6 project-type-wrapper">
                                                <select name="company_paddress_district" id="company_paddress_district"
                                                    data-parsley-errors-container="#company_pdistrictError"
                                                    class="browser-default select2" required>
                                                    <option value="">---Select District---</option>
                                                    @if ($pdistricts != null)
                                                        @foreach ($pdistricts as $district)
                                                            <option value="{{ $district->id }}"
                                                                @if ($district->id == $lesseEntry->company_permanent_district_id) selected @endif>
                                                                {{ $district->name }}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                                <label for="company_paddress_district" style="color: red"
                                                    class="active">District<span class="red-star">*</span></label>
                                                <span id="company_pdistrictError"></span>

                                            </div>

                                            <div class="input-field col s12 m6 project-type-wrapper">
                                                <input id="company_paddress_pincode" type="text"
                                                    value="{{ $lesseEntry->company_permanent_pincode }}"
                                                    name="company_paddress_pincode" data-parsley-type="integer"
                                                    required />
                                                <label for="company_paddress_pincode" class="active"
                                                    style="color: red">Pin
                                                    code*</label>
                                            </div>

                                            <div class="input-field col s12 ">
                                                <label>
                                                    <input id="company_copy_address_checkbox" type="checkbox"
                                                        name="company_checkbox" value="1" />
                                                    <span style="font-weight: bold; color: black">Communication address is
                                                        same
                                                        as Permanent address</span>
                                                </label>
                                            </div>

                                        </div>

                                        <div
                                            class="input-field col s12 m6 project-type-wrapper company_communication_class">
                                            <input id="company_communication_address" name="company_communication_address"
                                                value="{{ $lesseEntry->company_communication_address }}" required />
                                            <label for="company_communication_address" class="active"
                                                style="color: red">Communication
                                                Address*</label>

                                            <div
                                                class="input-field col s12 m6 project-type-wrapper company_communication_class">
                                                <select name="company_caddress_country" id="company_caddress_country"
                                                    data-parsley-errors-container="#company_ccountryError"
                                                    class="browser-default select2" required>
                                                    <option value="">---Select Country---</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            @if ($lesseEntry->company_communication_country_id == $country->id) selected @endif>
                                                            {{ $country->name }}</option>
                                                    @endforeach
                                                </select>
                                                <label for="company_caddress_country" style="color: red"
                                                    class="active">Country<span class="red-star">*</span></label>
                                                <span id="company_ccountryError"></span>
                                            </div>

                                            <div
                                                class="input-field col s12 m6 project-type-wrapper company_communication_class">
                                                <select name="company_caddress_state" id="company_caddress_state"
                                                    data-parsley-errors-container="#company_cstateError"
                                                    class="browser-default select2" required>
                                                    <option value="">---Select State---</option>
                                                    @foreach ($cstates as $state)
                                                        <option value="{{ $state->id }}"
                                                            @if ($state->id == $lesseEntry->company_communication_state_id) selected @endif>
                                                            {{ $state->name }}</option>
                                                    @endforeach
                                                </select>
                                                <label for="company_caddress_state" style="color: red"
                                                    class="active">State<span class="red-star">*</span></label>
                                                <span id="company_cstateError"></span>

                                            </div>

                                            <div
                                                class="input-field col s12 m6 project-type-wrapper company_communication_class">
                                                <select name="company_caddress_district" id="company_caddress_district"
                                                    data-parsley-errors-container="#company_cdistrictError"
                                                    class="browser-default select2" required>
                                                    <option value="">---Select District---</option>
                                                    @if ($cdistricts != null)
                                                        @foreach ($cdistricts as $district)
                                                            <option value="{{ $district->id }}"
                                                                @if ($district->id == $lesseEntry->company_communication_district_id) selected @endif>
                                                                {{ $district->name }}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                                <label for="company_caddress_district" style="color: red"
                                                    class="active">District<span class="red-star">*</span></label>
                                                <span id="company_cdistrictError"></span>

                                            </div>

                                            <div
                                                class="input-field col s12 m6 project-type-wrapper company_communication_class">
                                                <input id="company_caddress_pincode" type="text"
                                                    value="{{ $lesseEntry->company_communication_pincode }}"
                                                    name="company_caddress_pincode" data-parsley-type="integer"
                                                    required />
                                                <label for="company_caddress_pincode" class="active"
                                                    style="color: red">Pin
                                                    code*</label>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                <div class="row">
                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input type="submit" class="btn" value="Update">
                                        <a href="{{ route('mall-software.lessee_entry') }}" class="btn">Cancel</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>

    <script>
        $(document).ready(function() {
            $('.select2').each(function() {
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent()
                });
            });

            $('.select2').each(function() {
                width: "100%",

                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent(),

                });
            });
            $(".select2-selection__arrow")
                .addClass("material-icons")
                .html("arrow_drop_down");

            // $('#company_copy_address_checkbox').on('change', function() {
            //     if ($(this).is(':checked')) {
            //         // Copy permanent address details to communication address fields
            //         $('#company_communication_address').val($('#company_permanent_address').val());
            //         $('#company_caddress_country').val($('#company_paddress_country').val()).trigger(
            //             'change');
            //         $('#company_caddress_state').val($('#company_paddress_state').val()).trigger('change');
            //         $('#company_caddress_district').val($('#company_paddress_district').val());
            //         $('#company_caddress_pincode').val($('#company_paddress_pincode').val());
            //     } else {
            //         // Clear communication address fields
            //         $('#company_communication_address').val('');
            //         $('#company_caddress_country').val('');
            //         $('#company_caddress_state').val('');
            //         $('#company_caddress_district').val('');
            //         $('#company_caddress_pincode').val('');
            //     }
            // });

            $('#company_copy_address_checkbox').on('change', function() {
                $('.company_communication_class').toggle();
                if ($(this).is(':checked')) {
                    $('.company_communication_class').find('input, select').each(function() {
                        $(this).removeAttr('required');
                    });
                } else {
                    $('.company_communication_class').find('input, select').each(function() {
                        $(this).attr('required', 'required');
                    });
                }
            });

            $(document).ready(function() {
                if ($('#company_copy_address_checkbox').is(':checked')) {
                    $('.company_communication_class').hide().find('input, select').each(function() {
                        $(this).removeAttr('required');
                    });
                }
            });

            $('#company_paddress_country').on('change', function() { // Company Permanent Address Country-select
                $('#company_paddress_state').empty();
                var country_id = $(this).val();
                let state_id = {{ $lesseEntry->company_permanent_state_id }};
                if (country_id !== '') {
                    $.ajax({
                        url: '{{ route('mall-software.lessee_entry.getStates') }}',
                        type: 'GET',
                        data: {
                            country_id: country_id
                        },
                        success: function(response) {
                            if (response.status) {
                                var html = '<option value="">Choose State</option>';
                                $.each(response.data, function(index, value) {
                                    var selected = state_id == value.id ? 'selected' :
                                        '';
                                    html += '<option value="' + value.id + '" ' +
                                        selected +
                                        '>' + value
                                        .name + '</option>';
                                });
                                $('#company_paddress_state').append(html);
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#company_paddress_state').html('<option value="">Choose State</option>');
                }
            });

            $('#company_paddress_state').on('change', function() { // Company Permanent Address District-select
                $('#company_paddress_district').empty();
                let state_id = $(this).val();
                if (state_id !== '') {
                    $.ajax({
                        url: '{{ route('mall-software.lessee_entry.getDistricts') }}',
                        type: 'GET',
                        data: {
                            state_id: state_id
                        },
                        success: function(response) {
                            if (response.status) {
                                var html = '<option value="">Choose State</option>';
                                $.each(response.data, function(index, value) {
                                    html += '<option value="' + value.id + '">' + value
                                        .district_title + '</option>';
                                });
                                $('#company_paddress_district').append(html);
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#company_paddress_district').html('<option value="">Choose State</option>');
                }
            });

            $('#company_caddress_country').on('change', function() { // Company Communication Address Country-select
                $('#company_caddress_state').empty();
                var country_id = $(this).val();
                if (country_id !== '') {
                    $.ajax({
                        url: '{{ route('mall-software.lessee_entry.getStates') }}',
                        type: 'GET',
                        data: {
                            country_id: country_id
                        },
                        success: function(response) {
                            if (response.status) {
                                var html = '<option value="">Choose State</option>';
                                $.each(response.data, function(index, value) {
                                    html += '<option value="' + value.id + '">' + value
                                        .name + '</option>';
                                });
                                $('#company_caddress_state').append(html);
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#company_caddress_state').html('<option value="">Choose State</option>');
                }
            });

            $('#company_caddress_state').on('change', function() { // Company Communication Address District-select
                $('#company_caddress_district').empty();
                let state_id = $(this).val();
                if (state_id !== '') {
                    $.ajax({
                        url: '{{ route('mall-software.lessee_entry.getDistricts') }}',
                        type: 'GET',
                        data: {
                            state_id: state_id
                        },
                        success: function(response) {
                            if (response.status) {
                                var html = '<option value="">Choose State</option>';
                                $.each(response.data, function(index, value) {
                                    html += '<option value="' + value.id + '">' + value
                                        .district_title + '</option>';
                                });
                                $('#company_caddress_district').append(html);
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#company_caddress_district').html('<option value="">Choose State</option>');
                }
            });
        });

        $(document).ready(function() {
            function togglePermanentCompanyDistrictRequirement() {
                var selectedCountry = $('#company_paddress_country option:selected').val();
                if (selectedCountry.trim() !== "101") {
                    $('#company_paddress_district').removeAttr('required').parsley().reset();
                    $('#company_paddress_district').val('').trigger('change');
                } else {
                    $('#company_paddress_district').attr('required', 'required').parsley();
                }
            }
            $('#company_paddress_country').change(function() {
                togglePermanentCompanyDistrictRequirement();
            });
            togglePermanentCompanyDistrictRequirement();

            function toggleCommunicationCompanyDistrictRequirement() {
                var selectedCountry = $('#company_caddress_country option:selected').val();
                if (selectedCountry.trim() !== "101") {
                    $('#company_caddress_district').removeAttr('required').parsley().reset();
                    $('#company_caddress_district').val('').trigger('change');
                } else {
                    $('#company_caddress_district').attr('required', 'required').parsley();
                }
            }
            $('#company_caddress_country').change(function() {
                toggleCommunicationCompanyDistrictRequirement();
            });
            toggleCommunicationCompanyDistrictRequirement();
        });
    </script>
@endsection
