@extends('dashboard.layouts.app')
@section('css')
    <style>
        #individualNationalityError,
        #companyNationalityError,
        #individual_pcountryError,
        #individual_pstateError,
        #individual_pdistrictError,
        #individual_ccountryError,
        #individual_cstateError,
        #individual_cdistrictError,
        #company_pcountryError,
        #company_pstateError,
        #company_pdistrictError,
        #company_ccountryError,
        #company_cstateError,
        #company_cdistrictError,
        .parsley-errors-list {
            margin-top: 8px;
            list-style-type: none;
            padding: 0;
            font-size: 1 rem;
        }
    </style>
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Lessee Entry Details</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ route('dashboard.home') }}" class="breadcrumb">Home</a>
                <a href="#" class="breadcrumb">Lease and Rental</a>
                <a href="#" class="breadcrumb">Lessee Details</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                        </div>
                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        @if ($message = Session::get('error'))
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                {{ $message }}
                            </div>
                        @endif
                        <br>
                        <div class="m-b-10">
                            <a href="{{ route('mall-software.lessee_entry.create') }}" class="btn">Create Lessee</a>
                        </div>
                        <br>

                        <div class="row">
                            <div class="col s12 l12">
                                <ul class="tabs tab-demo z-depth-1">
                                    <li class="tab"><a href="#individual_lessee">Individual Lessee</a></li>
                                    <li class="tab"><a href="#company_lessee">Company Lessee</a>
                                    </li>
                                </ul>
                                <div id="individual_lessee">
                                    <div class="row">
                                        <div class="col s12 l12">
                                            <p class="p-15 p-b-0">

                                            </p>
                                            <table id="individual_lessee_table" class="responsive-table display nowrap"
                                                style="width:100%">
                                                <thead>
                                                    <tr>
                                                        <th>
                                                            Sl.No.
                                                        </th>
                                                        <th>
                                                            Individual Name
                                                        </th>
                                                        <th>
                                                            Date of Birth
                                                        </th>
                                                        <th>
                                                            Individual Contact Number
                                                        </th>
                                                        <th>
                                                            Father's Name
                                                        </th>
                                                        <th>
                                                            Nationality
                                                        </th>
                                                        <th>
                                                            Aadhaar Number
                                                        </th>
                                                        <th>
                                                            PAN Number
                                                        </th>
                                                        <th>
                                                            GSTIN
                                                        </th>
                                                        <th>
                                                            Actions
                                                        </th>
                                                    </tr>
                                                </thead>

                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div id="company_lessee">
                                    <div class="row">
                                        <div class="col s12 l12">
                                            <p class="p-15 p-b-0">

                                            </p>
                                            <table id="company_lessee_table" class="responsive-table display"
                                                style="width:100%">
                                                <thead>
                                                    <tr>
                                                        <th>
                                                            Sl.No.
                                                        </th>
                                                        <th>
                                                            Company Name
                                                        </th>
                                                        <th>
                                                            Date of Incorporation
                                                        </th>
                                                        <th>
                                                            Company Contact Number
                                                        </th>
                                                        <th>
                                                            Company Nationality
                                                        </th>
                                                        <th>
                                                            Company PAN Number
                                                        </th>
                                                        <th>
                                                            Company GST Number
                                                        </th>
                                                        <th>
                                                            Actions
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody>

                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script>
        $(document).ready(function() {

            let individualLesseeTbl = $('#individual_lessee_table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10,
                paging: true,
                responsive: true,
                scrollX: false,
                ajax: {
                    url: "{{ route('mall-software.lessee_entry.individualLessee') }}",
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'individual_name',
                        name: 'individual_name'
                    },
                    {
                        data: 'date_of_birth',
                        name: 'date_of_birth'
                    },
                    {
                        data: 'individual_contact_number',
                        name: 'individual_contact_number'
                    },
                    {
                        data: 'fathers_name',
                        name: 'fathers_name'
                    },
                    {
                        data: 'individual_nationality',
                        name: 'individual_nationality'
                    },
                    {
                        data: 'aadhar_number',
                        name: 'aadhar_number'
                    },
                    {
                        data: 'individual_pan_number',
                        name: 'individual_pan_number'
                    },
                    {
                        data: 'individual_gstin',
                        name: 'individual_gstin'
                    },
                    {
                        data: 'actions',
                        name: 'actions'
                    },
                ],
                "order": [
                    [1, "desc"]
                ],
                "drawCallback": function(settings) {
                    //alert( 'DataTables has redrawn the table' );
                    $('.dropdown-trigger').dropdown();
                },
                lengthMenu: [
                    [10, 25, 50, 100, -1],
                    ['10 rows', '25 rows', '50 rows', '100 rows', 'Show all']
                ],
            });



            let companyLesseeTbl = $('#company_lessee_table').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 10,
                paging: true,
                responsive: true,
                scrollX: false,
                ajax: {
                    url: "{{ route('mall-software.lessee_entry.companyLessee') }}",
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'company_name',
                        name: 'company_name'
                    },
                    {
                        data: 'company_date_of_incorporation',
                        name: 'company_date_of_incorporation'
                    },
                    {
                        data: 'company_contact_number',
                        name: 'company_contact_number'
                    },
                    {
                        data: 'company_nationality',
                        name: 'company_nationality'
                    },
                    {
                        data: 'company_pan_number',
                        name: 'company_pan_number'
                    },
                    {
                        data: 'company_gst_number',
                        name: 'company_gst_number'
                    },
                    {
                        data: 'actions',
                        name: 'actions'
                    },
                ],
                "order": [
                    [1, "desc"]
                ],
                "drawCallback": function(settings) {
                    //alert( 'DataTables has redrawn the table' );
                    $('.dropdown-trigger').dropdown();
                },
                lengthMenu: [
                    [10, 25, 50, 100, -1],
                    ['10 rows', '25 rows', '50 rows', '100 rows', 'Show all']
                ],
            });

        });
    </script>
@endsection
