@extends('dashboard.layouts.app')
@section('css')
    <style>
        #individualNationalityError,
        #companyNationalityError,
        #individual_pcountryError,
        #individual_pstateError,
        #individual_pdistrictError,
        #individual_ccountryError,
        #individual_cstateError,
        #individual_cdistrictError,
        #company_pcountryError,
        #company_pstateError,
        #company_pdistrictError,
        #company_ccountryError,
        #company_cstateError,
        #company_cdistrictError,
        .parsley-errors-list {
            margin-top: 8px;
            list-style-type: none;
            padding: 0;
            font-size: 1 rem;
        }
    </style>
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Edit Individual Lessee Entry</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ route('dashboard.home') }}" class="breadcrumb">Home</a>
                <a href="#" class="breadcrumb">Lease and Rental</a>
                <a href="{{ route('mall-software.lessee_entry') }}" class="breadcrumb">Lessee Details</a>
                <a href="#" class="breadcrumb">Edit Individual Lessee</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                        </div>
                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        @if ($message = Session::get('error'))
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                {{ $message }}
                            </div>
                        @endif

                        <div id="individual_div">
                            <form method="post"
                                action="{{ route('mall-software.lessee_entry.individualLesseeUpdate', $lesseEntry->id) }}"
                                class="formValidate" id="formValidate" name="formValidate" data-parsley-validate="">
                                @csrf
                                <input type="hidden" name="lessee_entry_type" value="Individual">
                                <div class="row">
                                    <div class="input-field col s12 m4 project-type-wrapper">
                                        <input id="name" type="text" name="name"
                                            value="{{ $lesseEntry->individual_name }}" required>
                                        <label for="name" class="active" style="color: red">Name<span
                                                class="red-star">*</span></label>
                                    </div>

                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input id="date_of_birth" type="date" name="date_of_birth"
                                            value="{{ $lesseEntry->date_of_birth }}" required>
                                        <label for="date_of_birth" class="active" style="color: red">Date of Birth<span
                                                class="red-star">*</span></label>
                                    </div>

                                    <div class="input-field col s12 m3 project-type-wrapper">
                                        <input id="individual_contact" type="text" name="individual_contact"
                                            value="{{ $lesseEntry->individual_contact_number }}" required
                                            data-parsley-type="integer">
                                        <label for="individual_contact" class="active" style="color: red">Individual
                                            Contact Number<span class="red-star">*</span></label>
                                    </div>

                                    <div class="input-field col s12 m3 project-type-wrapper">
                                        <input id="fathers_name" type="text" name="fathers_name"
                                            value="{{ $lesseEntry->fathers_name }}" required>
                                        <label for="fathers_name" class="active" style="color: red">Father's Name<span
                                                class="red-star">*</span></label>
                                    </div>
                                </div>

                                <div class="row">

                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <select name="individual_nationality" id="individual_nationality"
                                            class="browser-default select2"
                                            data-parsley-errors-container="#individualNationalityError" required>
                                            <option value="">---Select---</option>
                                            <option value="Indian" @if ($lesseEntry->individual_nationality == 'Indian') selected @endif>Indian
                                            </option>
                                            <option value="NRI"@if ($lesseEntry->individual_nationality == 'NRI') selected @endif>NRI
                                            </option>
                                        </select>
                                        <label for="individual_nationality" style="color: red"
                                            class="active">Nationality<span class="red-star">*</span></label>
                                        <span id="individualNationalityError"></span>
                                    </div>

                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input id="aadhar_number" type="text" name="aadhar_number"
                                            value="{{ $lesseEntry->aadhar_number }}" data-parsley-type="integer">
                                        <label for="aadhar_number" class="active">Aadhar
                                            Number</label>
                                    </div>

                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input id="pan_number" type="text" name="pan_number"
                                            value="{{ $lesseEntry->individual_pan_number }}" required>
                                        <label for="pan_number" class="active" style="color: red">PAN Number<span
                                                class="red-star">*</span></label>
                                    </div>

                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input id="gstin" type="text" name="gstin"
                                            value="{{ $lesseEntry->individual_gstin }}">
                                        <label for="gstin" class="active">GSTIN</label>
                                    </div>

                                </div>
                                <hr>

                                <div class="row">
                                    <div id="individual_address_div">

                                        <div class="input-field col s12 m6 project-type-wrapper">
                                            <input id="individual_permanent_address" type="text"
                                                name="individual_permanent_address"
                                                value="{{ $lesseEntry->individual_permanent_address }}" required />
                                            <label for="individual_permanent_address" style="color: red">Permanent
                                                Address*</label>

                                            <div class="input-field col s12 m6 project-type-wrapper">
                                                <select name="individual_paddress_country"
                                                    data-parsley-errors-container="#individual_pcountryError"
                                                    id="individual_paddress_country" class="browser-default select2"
                                                    required>
                                                    <option value="">---Select Country---</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            @if ($lesseEntry->individual_permanent_country_id == $country->id) selected @endif>
                                                            {{ $country->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <label for="individual_paddress_country" style="color: red"
                                                    class="active">Country<span class="red-star">*</span></label>
                                                <span id="individual_pcountryError"></span>
                                            </div>

                                            <div class="input-field col s12 m6 project-type-wrapper">
                                                <select name="individual_paddress_state" id="individual_paddress_state"
                                                    data-parsley-errors-container="#individual_pstateError"
                                                    class="browser-default select2" required>
                                                    <option value="">---Select State---</option>
                                                    @foreach ($pstates as $state)
                                                        <option value="{{ $state->id }}"
                                                            @if ($state->id == $lesseEntry->individual_permanent_state_id) selected @endif>
                                                            {{ $state->name }}</option>
                                                    @endforeach
                                                </select>
                                                <label for="individual_paddress_state" style="color: red"
                                                    class="active">State<span class="red-star">*</span></label>
                                                <span id="individual_pstateError"></span>
                                            </div>

                                            <div class="input-field col s12 m6 project-type-wrapper">
                                                <select name="individual_paddress_district"
                                                    data-parsley-errors-container="#individual_pdistrictError"
                                                    class="browser-default select2" id="individual_paddress_district"
                                                    required>
                                                    <option value="">---Select District---</option>
                                                    @if ($pdistricts != null)
                                                        @foreach ($pdistricts as $district)
                                                            <option value="{{ $district->id }}"
                                                                @if ($district->id == $lesseEntry->individual_permanent_district_id) selected @endif>
                                                                {{ $district->name }}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                                <label for="individual_paddress_district" style="color: red"
                                                    class="active">District<span class="red-star">*</span></label>
                                                <span id="individual_pdistrictError"></span>

                                            </div>

                                            <div class="input-field col s12 m6 project-type-wrapper">
                                                <input id="individual_paddress_pincode" type="text"
                                                    name="individual_paddress_pincode" required
                                                    data-parsley-type="integer"
                                                    value="{{ $lesseEntry->individual_permanent_pincode }}" />
                                                <label for="individual_paddress_pincode" class="active"
                                                    style="color: red">Pin
                                                    code*</label>
                                            </div>

                                            <div class="input-field col s12 ">
                                                <label>
                                                    <input id="individual_copy_address_checkbox" type="checkbox"
                                                        name="individual_checkbox" value="1" />
                                                    <span style="font-weight: bold; color: black">Communication address
                                                        is same
                                                        as Permanent address</span>
                                                </label>
                                            </div>

                                        </div>

                                        <div
                                            class="input-field col s12 m6 project-type-wrapper individual_communication_class">
                                            <input id="individual_communication_address"
                                                value="{{ $lesseEntry->individual_communication_address }}"
                                                name="individual_communication_address" required />
                                            <label for="individual_communication_address" class="active"
                                                style="color: red">Communication
                                                Address*</label>

                                            <div
                                                class="input-field col s12 m6 project-type-wrapper individual_communication_class">
                                                <select name="individual_caddress_country" class="browser-default select2"
                                                    data-parsley-errors-container="#individual_ccountryError"
                                                    id="individual_caddress_country" required>
                                                    <option value="">---Select Country---</option>
                                                    @foreach ($countries as $country)
                                                        <option value="{{ $country->id }}"
                                                            @if ($lesseEntry->individual_communication_country_id == $country->id) selected @endif>
                                                            {{ $country->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <label for="individual_caddress_country" style="color: red"
                                                    class="active">Country<span class="red-star">*</span></label>
                                                <span id="individual_ccountryError"></span>
                                            </div>

                                            <div
                                                class="input-field col s12 m6 project-type-wrapper individual_communication_class">
                                                <select name="individual_caddress_state" id="individual_caddress_state"
                                                    data-parsley-errors-container="#individual_cstateError"
                                                    class="browser-default select2" required>
                                                    <option value="">---Select State---</option>
                                                    @foreach ($cstates as $state)
                                                        <option value="{{ $state->id }}"
                                                            @if ($state->id == $lesseEntry->individual_communication_state_id) selected @endif>
                                                            {{ $state->name }}</option>
                                                    @endforeach
                                                </select>
                                                <label for="individual_caddress_state" style="color: red"
                                                    class="active">State<span class="red-star">*</span></label>
                                                <span id="individual_cstateError"></span>

                                            </div>

                                            <div
                                                class="input-field col s12 m6 project-type-wrapper individual_communication_class">
                                                <select name="individual_caddress_district"
                                                    data-parsley-errors-container="#individual_cdistrictError"
                                                    class="browser-default select2" id="individual_caddress_district"
                                                    required>
                                                    <option value="">---Select District---</option>
                                                    @if ($cdistricts != null)
                                                        @foreach ($cdistricts as $district)
                                                            <option value="{{ $district->id }}"
                                                                @if ($district->id == $lesseEntry->individual_communication_district_id) selected @endif>
                                                                {{ $district->name }}</option>
                                                        @endforeach
                                                    @endif
                                                </select>
                                                <label for="individual_caddress_district" style="color: red"
                                                    class="active">District<span class="red-star">*</span></label>
                                                <span id="individual_cdistrictError"></span>

                                            </div>

                                            <div
                                                class="input-field col s12 m6 project-type-wrapper individual_communication_class">
                                                <input id="individual_caddress_pincode" type="text"
                                                    value="{{ $lesseEntry->individual_communication_pincode }}"
                                                    name="individual_caddress_pincode" required
                                                    data-parsley-type="integer" />
                                                <label for="individual_caddress_pincode" class="active"
                                                    style="color: red">Pin
                                                    code*</label>
                                            </div>
                                        </div>

                                    </div>
                                </div>

                                <div class="row">
                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input type="submit" class="btn" value="Update">
                                        <a href="{{ route('mall-software.lessee_entry') }}" class="btn">Cancel</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>

    <script>
        $(document).ready(function() {
            $('.select2').each(function() {
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent()
                });
            });

            $('.select2').each(function() {
                width: "100%",

                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent(),

                });
            });
            $(".select2-selection__arrow")
                .addClass("material-icons")
                .html("arrow_drop_down");

            // Function to update communication fields on keyup event
            function updateCommunicationFields() {
                if ($('#individual_copy_address_checkbox').is(':checked')) {
                    $('#individual_communication_address').val($('#individual_permanent_address').val());
                    $('#individual_caddress_country').val($('#individual_paddress_country').val());
                    $('#individual_caddress_state').val($('#individual_paddress_state').val()).trigger(
                        'change');
                    $('#individual_caddress_district').val($('#individual_paddress_district').val());
                    $('#individual_caddress_pincode').val($('#individual_paddress_pincode').val());
                }
            }
            // Event listener for keyup event on permanent address fields
            $('#individual_permanent_address, #individual_paddress_country, #individual_paddress_state, #individual_paddress_district, #individual_paddress_pincode')
                .on('keyup', function() {
                    updateCommunicationFields();
                });


            // $('#individual_copy_address_checkbox').on('change', function() {
            //     if ($(this).is(':checked')) {
            //         $('#individual_communication_address').val($('#individual_permanent_address').val());
            //         $('#individual_caddress_country').val($('#individual_paddress_country').val()).trigger(
            //             'change');
            //         $('#individual_caddress_state').val($('#individual_paddress_state').val()).trigger(
            //             'change');
            //         $('#individual_caddress_district').val($('#individual_paddress_district').val());
            //         $('#individual_caddress_pincode').val($('#individual_paddress_pincode').val());

            //     } else {
            //         $('#individual_communication_address').val('');
            //         $('#individual_caddress_country').val('');
            //         $('#individual_caddress_state').val('');
            //         $('#individual_caddress_district').val('');
            //         $('#individual_caddress_pincode').val('');
            //     }
            // });

            $('#individual_copy_address_checkbox').on('change', function() {
                $('.individual_communication_class').toggle();
                if ($(this).is(':checked')) {
                    $('.individual_communication_class').find('input, select').each(function() {
                        $(this).removeAttr('required');
                    });
                } else {
                    $('.individual_communication_class').find('input, select').each(function() {
                        $(this).attr('required', 'required');
                    });
                }
            });

            $(document).ready(function() {
                if ($('#individual_copy_address_checkbox').is(':checked')) {
                    $('.individual_communication_class').hide().find('input, select').each(function() {
                        $(this).removeAttr('required');
                    });
                }
            });

            $('#individual_paddress_country').on('change',
                function() { // Individual Permanent Address Country-select
                    $('#individual_paddress_state').empty();
                    let country_id = $(this).val();
                    if (country_id !== '') {
                        $.ajax({
                            url: '{{ route('mall-software.lessee_entry.getStates') }}',
                            type: 'GET',
                            data: {
                                country_id: country_id
                            },
                            success: function(response) {
                                if (response.status) {
                                    var html = '<option value="">Choose State</option>';
                                    $.each(response.data, function(index, value) {
                                        html += '<option value="' + value.id + '">' + value
                                            .name + '</option>';
                                    });
                                    $('#individual_paddress_state').append(html);
                                }
                            },
                            error: function(xhr) {
                                console.log(xhr.responseText);
                            }
                        });
                    } else {
                        $('#individual_paddress_state').html('<option value="">Choose State</option>');
                    }
                });

            $('#individual_paddress_state').on('change',
                function() { // Individual Permanent Address District-select
                    $('#individual_paddress_district').empty();
                    let state_id = $(this).val();
                    if (state_id !== '') {
                        $.ajax({
                            url: '{{ route('mall-software.lessee_entry.getDistricts') }}',
                            type: 'GET',
                            data: {
                                state_id: state_id
                            },
                            success: function(response) {
                                if (response.status) {
                                    var html = '<option value="">Choose State</option>';
                                    $.each(response.data, function(index, value) {
                                        html += '<option value="' + value.id + '">' + value
                                            .district_title + '</option>';
                                    });
                                    $('#individual_paddress_district').append(html);
                                }
                            },
                            error: function(xhr) {
                                console.log(xhr.responseText);
                            }
                        });
                    } else {
                        $('#individual_paddress_district').html('<option value="">Choose State</option>');
                    }
                });


            $('#individual_caddress_country').on('change',
                function() { // Individual Communication Address Country-select
                    $('#individual_caddress_state').empty();
                    let country_id = $(this).val();
                    if (country_id !== '') {
                        $.ajax({
                            url: '{{ route('mall-software.lessee_entry.getStates') }}',
                            type: 'GET',
                            data: {
                                country_id: country_id
                            },
                            success: function(response) {
                                if (response.status) {
                                    var html = '<option value="">Choose State</option>';
                                    $.each(response.data, function(index, value) {
                                        html += '<option value="' + value.id + '">' + value
                                            .name + '</option>';
                                    });
                                    $('#individual_caddress_state').append(html)
                                }
                            },
                            error: function(xhr) {
                                console.log(xhr.responseText);
                            }
                        });
                    } else {
                        $('#individual_caddress_state').html('<option value="">Choose State</option>');
                    }
                });

            $('#individual_caddress_state').on('change',
                function() { // Individual Permanent Address District-select
                    $('#individual_caddress_district').empty();
                    let state_id = $(this).val();
                    if (state_id !== '') {
                        $.ajax({
                            url: '{{ route('mall-software.lessee_entry.getDistricts') }}',
                            type: 'GET',
                            data: {
                                state_id: state_id
                            },
                            success: function(response) {
                                if (response.status) {
                                    var html = '<option value="">Choose State</option>';
                                    $.each(response.data, function(index, value) {
                                        html += '<option value="' + value.id + '">' + value
                                            .district_title + '</option>';
                                    });
                                    $('#individual_caddress_district').append(html);
                                }
                            },
                            error: function(xhr) {
                                console.log(xhr.responseText);
                            }
                        });
                    } else {
                        $('#individual_caddress_district').html('<option value="">Choose State</option>');
                    }
                });




            $('#company_paddress_country').on('change', function() { // Company Permanent Address Country-select
                $('#company_paddress_state').empty();
                var country_id = $(this).val();
                if (country_id !== '') {
                    $.ajax({
                        url: '{{ route('mall-software.lessee_entry.getStates') }}',
                        type: 'GET',
                        data: {
                            country_id: country_id
                        },
                        success: function(response) {
                            if (response.status) {
                                var html = '<option value="">Choose State</option>';
                                $.each(response.data, function(index, value) {
                                    html += '<option value="' + value.id + '">' + value
                                        .name + '</option>';
                                });
                                $('#company_paddress_state').append(html);
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#company_paddress_state').html('<option value="">Choose State</option>');
                }
            });

            $('#company_paddress_state').on('change', function() { // Company Permanent Address District-select
                $('#company_paddress_district').empty();
                let state_id = $(this).val();
                if (state_id !== '') {
                    $.ajax({
                        url: '{{ route('mall-software.lessee_entry.getDistricts') }}',
                        type: 'GET',
                        data: {
                            state_id: state_id
                        },
                        success: function(response) {
                            if (response.status) {
                                var html = '<option value="">Choose State</option>';
                                $.each(response.data, function(index, value) {
                                    html += '<option value="' + value.id + '">' + value
                                        .district_title + '</option>';
                                });
                                $('#company_paddress_district').append(html);
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#company_paddress_district').html('<option value="">Choose State</option>');
                }
            });

            $('#company_caddress_country').on('change', function() { // Company Communication Address Country-select
                $('#company_caddress_state').empty();
                var country_id = $(this).val();
                if (country_id !== '') {
                    $.ajax({
                        url: '{{ route('mall-software.lessee_entry.getStates') }}',
                        type: 'GET',
                        data: {
                            country_id: country_id
                        },
                        success: function(response) {
                            if (response.status) {
                                var html = '<option value="">Choose State</option>';
                                $.each(response.data, function(index, value) {
                                    html += '<option value="' + value.id + '">' + value
                                        .name + '</option>';
                                });
                                $('#company_caddress_state').append(html);
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#company_caddress_state').html('<option value="">Choose State</option>');
                }
            });

            $('#company_caddress_state').on('change', function() { // Company Communication Address District-select
                $('#company_caddress_district').empty();
                let state_id = $(this).val();
                if (state_id !== '') {
                    $.ajax({
                        url: '{{ route('mall-software.lessee_entry.getDistricts') }}',
                        type: 'GET',
                        data: {
                            state_id: state_id
                        },
                        success: function(response) {
                            if (response.status) {
                                var html = '<option value="">Choose State</option>';
                                $.each(response.data, function(index, value) {
                                    html += '<option value="' + value.id + '">' + value
                                        .district_title + '</option>';
                                });
                                $('#company_caddress_district').append(html);
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#company_caddress_district').html('<option value="">Choose State</option>');
                }
            });
        });

        $(document).ready(function() {
            function togglePermanentIndividualDistrictRequirement() {
                var pselectedCountry = $('#individual_paddress_country option:selected').val();
                if (pselectedCountry.trim() !== "101") {
                    $('#individual_paddress_district').removeAttr('required').parsley().reset();
                    $('#individual_paddress_district').val('').trigger('change');
                } else {
                    $('#individual_paddress_district').attr('required', 'required').parsley();
                }
            }

            $('#individual_paddress_country').change(function() {
                togglePermanentIndividualDistrictRequirement();
            });
            togglePermanentIndividualDistrictRequirement();

            function toggleCommunicationIndividualDistrictRequirement() {
                var cselectedCountry = $('#individual_caddress_country option:selected').val();
                if (cselectedCountry.trim() !== "101") {
                    $('#individual_caddress_district').removeAttr('required').parsley().reset();
                    $('#individual_caddress_district').val('').trigger('change');
                } else {
                    $('#individual_caddress_district').attr('required', 'required').parsley();
                }
            }

            $('#individual_caddress_country').change(function() {
                toggleCommunicationIndividualDistrictRequirement();
            });
            toggleCommunicationIndividualDistrictRequirement();
        });
    </script>
@endsection
