@extends('dashboard.layouts.app')
@section('css')
    <style>
        #rateTypeErrorContainer,
        #groupSelectErrorContainer,
        #ledgerSelectErrorContainer,
        #dueDaysErrorContainer,
        #rateItemErrorContainer,
        .parsley-errors-list {
            margin-top: 5px;
            list-style-type: none;
            padding: 0;
            font-size: 0.8rem;
        }
    </style>
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Create Rate Item Definition</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ route('dashboard.home') }}" class="breadcrumb">Home</a>
                <a href="#" class="breadcrumb">Lease and Rental</a>
                <a href="{{ route('mall-software.rate_item_definition') }}" class="breadcrumb">Rate Item Definitions</a>
                <a href="#" class="breadcrumb">Create Rate Item</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        {{-- <div class="row"> --}}
                        <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                        </div>

                        <form method="post" action="{{ route('mall-software.rate_item_definition.store') }}"
                            class="formValidate" id="form" name="formValidate" data-parsley-validate="">
                            @csrf

                            <div class="row">
                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <select name="rate_type" id="rate_type" required=""
                                        data-parsley-required-message="Rate Type is required"
                                        data-parsley-errors-container="#rateTypeErrorContainer"
                                        class="browser-default select2">
                                        <option value=""></option>
                                        <option value="Security Deposit">Security Deposit</option>
                                        <option value="Fixed Charges">Fixed Charges</option>
                                        <option value="Variable Charges">Variable Charges</option>
                                        <option value="Other Charges">Other Charges</option>
                                    </select>
                                    <label for="rate_type" style="color: red" class="active">Rate Type<span
                                            class="red-star">*</span></label>
                                    <span id="rateTypeErrorContainer"></span>
                                </div>

                                <div class="input-field col s12 m3 project-type-wrapper">
                                    <input id="rate_item_name" type="text" name="rate_item_name"
                                        value="{{ old('rate_item_name') }}" required=""
                                        data-parsley-required-message="Rate Item Name is required"
                                        data-parsley-errors-container="#rateItemErrorContainer">
                                    <label for="rate_item_name" class="active" style="color: red">Rate Item
                                        Name<span class="red-star">*</span></label>
                                    <span id="rateItemErrorContainer"></span>
                                </div>

                                <div class="input-field col s12 m4 project-type-wrapper" id="rate_calculation">
                                    <div class="input-field col s12 m4">
                                        <label>
                                            <input id="rate_calculation_method1" type="radio"
                                                name="rate_calculation_method" value="Area" />
                                            <span style="font-weight: bold; color: black">Area</span>
                                        </label>
                                    </div>

                                    <div class="input-field col s12 m4">
                                        <label>
                                            <input id="rate_calculation_method2" type="radio"
                                                name="rate_calculation_method" value="Quantity" />
                                            <span style="font-weight: bold; color: black">Quantity</span>
                                        </label>
                                    </div>

                                    <div class="input-field col s12 m4">
                                        <label>
                                            <input id="rate_calculation_method3" type="radio"
                                                name="rate_calculation_method" value="Lumpsum" />
                                            <span style="font-weight: bold; color: black">Lumpsum</span>
                                        </label>
                                    </div>

                                    <label for="rate_calculation" id="rate_calculation_label" class="active"
                                        style="color: red">Rate Calculation Method<span class="red-star">*</span></label>
                                </div>

                                <div class="input-field col s12 m3 project-type-wrapper">
                                    <input id="default_rate" type="text" name="default_rate"
                                        value="{{ old('default_rate') }}" data-parsley-type="number">
                                    <label for="default_rate" class="active">Default Rate</label>
                                </div>

                            </div>

                            <div class="row">
                                <div class="input-field col s12 m3">
                                    <input id="remarks" type="text" name="remarks" value="{{ old('remarks') }}">
                                    <label for="remarks">Remarks</label>
                                </div>

                                <div class="input-field col s12 m2">
                                    <select name="gst_percentage" id="gst_percentage" class="browser-default select2">
                                        <option value=""></option>
                                        <option value="5">5</option>
                                        <option value="12">12</option>
                                        <option value="18">18</option>
                                        <option value="28">28</option>
                                    </select>
                                    <label for="gst_percentage" class="active">GST %</label>
                                </div>

                                <div class="input-field col s12 m2">
                                    <select name="tds_percentage" id="tds_percentage" class="browser-default select2">
                                        <option value=""></option>
                                        <option value="1">1</option>
                                        <option value="2">2</option>
                                        <option value="10">10</option>
                                    </select>
                                    <label for="tds_percentage" class="active">TDS %</label>
                                </div>

                                <div class="input-field col s12 m2">
                                    <select name="other_taxes" id="other_taxes" class="browser-default select2">
                                        <option value="">---Select---</option>
                                    </select>
                                    <label for="other_taxes" class="active">Other Taxes %</label>
                                </div>

                                <div class="input-field col s12 m3">
                                    <input id="due_days" type="text" name="due_days" value="{{ old('due_days') }}"
                                        required="" data-parsley-type="integer"
                                        data-parsley-required-message="Due Days is required"
                                        data-parsley-errors-container="#dueDaysErrorContainer">
                                    <label for="due_days" style="color: red" class="active">Due days<span
                                            class="red-star">*</span></label>
                                    <span id="dueDaysErrorContainer"></span>
                                </div>

                                <div class="input-field col s12 m1">
                                    <label>
                                        <input id="due_days1" type="checkbox" checked name="active" value="1" />
                                        <span style="font-weight: bold; color: black">Active</span>
                                    </label>
                                </div>

                                <div class="input-field col s12 m3 project-type-wrapper">
                                    <input id="hsn-sac-code" type="text" name="hsn-sac-code"
                                        value="{{ old('hsn-sac-code') }}">
                                    <label for="hsn-sac-code"class="active">HSN/SAC Code</label>
                                </div>

                                <div class="input-field col s12 m3 project-type-wrapper">
                                    <select name="group_select" id="group_select" required=""
                                        data-parsley-required-message="COA is required"
                                        data-parsley-errors-container="#groupSelectErrorContainer"
                                        class="browser-default select2">
                                        <option value="">---Group Select---</option>
                                        @foreach ($ledgerGroups as $ledgerGroup)
                                            <option value="{{ $ledgerGroup->id }}">{{ $ledgerGroup->ledger_name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <label for="group_select" style="color: red" class="active">COA*</label>
                                    <span id="groupSelectErrorContainer"></span>
                                </div>

                                <div class="input-field col s12 m3 project-type-wrapper" id="individual_select_div">
                                    <select name="individual_ledger" id="individual_ledger" required=""
                                        data-parsley-required-message="Ledger is required"
                                        data-parsley-errors-container="#ledgerSelectErrorContainer"
                                        class="browser-default select2">
                                        <option value="">---Ledger Select---</option>
                                        {{-- <option value="1">Ledger 1</option> --}}
                                    </select>
                                    <label for="individual_ledger" style="color: red" class="active">Ledger</label>
                                    <span id="ledgerSelectErrorContainer"></span>
                                </div>
                            </div>

                            <div class="row">
                                <div class="input-field col s12 m3">
                                    <button class="btn" id="automatic_numbering_btn" type="button">Automatic
                                        Numbering</button>
                                </div>
                            </div>

                            <div class="" id="automatic_numbering_div">
                                <div class="row">
                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input type="text" name="prefix" id="prefix">
                                        <label for="" style="color: red" class="active">Prefix*</label>
                                    </div>
                                    <div class="input-field col s12 m2">
                                        <label>
                                            <input id="company_short_name" type="checkbox" name="company_short_name" />
                                            <span style="font-weight: bold; color: black">Company Short Name</span>
                                        </label>
                                    </div>

                                    <div class="input-field col s12 m2">
                                        <label>
                                            <input id="project_short_name" type="checkbox" name="project_short_name" />
                                            <span style="font-weight: bold; color: black">Project Short Name</span>
                                        </label>
                                    </div>

                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input type="text" name="financial_year" id="financial_year"
                                            value="2023-2024">
                                        <label for="financial_year" style="color: red" class="active">Financial
                                            year</label>
                                    </div>

                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input type="text" name="next_number" id="next_number"
                                            data-parsley-type="integer">
                                        <label for="next_number" class="active">Next
                                            number.</label>
                                    </div>

                                    <div class="input-field col s12 m2 project-type-wrapper">
                                        <input type="text" name="reset_number" id="reset_number"
                                            data-parsley-type="integer">
                                        <label for="reset_number" class="active">Reset number
                                            to.</label>
                                    </div>
                                </div>

                            </div>

                            <div class="row">
                                <div class="input-field col s12 m3">
                                    <button class="btn" type="submit">Save</button>
                                    <a href="{{ route('mall-software.rate_item_definition') }}" class="btn"
                                        type="btn">Cancel</a>
                                </div>
                            </div>

                        </form>
                        {{-- </div> --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#automatic_numbering_div').hide();
            $('.select2').each(function() {
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent()
                });
            });

            $('#form').parsley();
            $('#company_short_name').change(function() {
                if ($(this).is(":checked")) {
                    $('#company-separator-wrapper').show();
                } else {
                    $('#company-separator-wrapper').hide();
                }
            });

            $('#project_short_name').change(function() {
                if ($(this).is(":checked")) {
                    $('#project-separator-wrapper').show();
                } else {
                    $('#project-separator-wrapper').hide();
                }
            });

            $('#automatic_numbering_btn').click(function() {
                $('#automatic_numbering_div').toggle();

                if ($('#automatic_numbering_div').is(':visible')) {
                    $('#prefix').attr('required', '');
                    $('#prefix').attr('data-parsley-required-message',
                        'Prefix is required');
                    $('#prefix').parsley().reset();
                } else {
                    $('#prefix').removeAttr('required');
                    $('#prefix').parsley().reset();
                }
            });
        })
    </script>

    <script>
        $(document).ready(function() {
            $('#company_separator').on('input', function() {
                var inputValue = $(this).val();
                var sanitizedValue = inputValue.replace(/[^!@#$%^&*(),.?":{}|<>]/g, '');
                $(this).val(sanitizedValue);
            });

            window.Parsley.addValidator('alphaOnly', {
                validateString: function(value) {
                    return /^[A-Za-z]+$/.test(value);
                },
                messages: {
                    en: 'Please enter only alphabetical characters.'
                }
            });
            $('#prefix').parsley().addConstraint('alphaOnly');




            $('#group_select').on('change', function() {
                $('#individual_ledger').empty();
                let coa_id = $(this).val();
                if (coa_id !== '') {
                    $.ajax({
                        url: '{{ route('mall-software.rate_item_definition.getLedgers') }}',
                        type: 'GET',
                        data: {
                            coa_id: coa_id
                        },
                        success: function(response) {
                            if (response.status) {
                                var html = '<option value="">Choose State</option>';
                                $.each(response.data, function(index, value) {
                                    html += '<option value="' + value.id + '">' + value
                                        .ledger_name + '</option>';
                                });
                                $('#individual_ledger').append(html);
                            }
                        },
                        error: function(xhr) {
                            console.log(xhr.responseText);
                        }
                    });
                } else {
                    $('#individual_ledger').html('<option value="">Choose State</option>');
                }
            });
        });
    </script>
@endsection
