@extends('dashboard.layouts.app')
@section('css')
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Create Rent Receipt</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ route('dashboard.home') }}" class="breadcrumb">Home</a>
                <a href="#" class="breadcrumb">Lease and Rental</a>
                <a href="{{ route('mall-software.rent_receipt.index') }}" class="breadcrumb">Rent Receipt</a>
                <a href="#" class="breadcrumb">Create Rent Receipt</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                        </div>

                        <form method="post" action="" class="formValidate" id="formValidate" name="formValidate">
                            @csrf

                            <div class="row">
                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <select name="project" id="project" class="browser-default select2" required>
                                        <option value="">---Select---</option>
                                        @foreach ($projects as $project)
                                            <option value="{{ $project->id }}">{{ $project->project_name }}</option>
                                        @endforeach
                                    </select>
                                    <label for="project" style="color: red" class="active">Project<span
                                            class="red-star">*</span></label>
                                </div>
                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <select name="lessee" id="lessee" class="browser-default select2" required>
                                        <option value="">---Select---</option>
                                        @foreach ($lessees as $lessee)
                                            @if ($lessee->lessee_type == 'Individual')
                                                <option value="{{ $lessee->id }}">{{ $lessee->individual_name }}</option>
                                            @elseif($lessee->lessee_type == 'Company')
                                                <option value="{{ $lessee->id }}">{{ $lessee->company_name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    <label for="lessee" style="color: red" class="active">Lessee<span
                                            class="red-star">*</span></label>
                                </div>
                                <div class="input-field col s12 m2 project-type-wrapper">
                                    <input id="receipt_no" type="text" name="receipt_no" value="{{ old('receipt_no') }}"
                                        required>
                                    <label for="receipt_no" class="active" style="color: red">Receipt No<span
                                            class="red-star">*</span></label>
                                </div>
                                <div class="input-field col s12 m2">
                                    <input id="receipt_date" type="date" name="receipt_date"
                                        value="{{ old('receipt_date') }}" required>
                                    <label for="receipt_date" style="color: red">Receipt Date</label>
                                </div>
                                <div class="input-field col s12 m2">
                                    <input id="receipt_bill_amount" type="text" name="receipt_bill_amount"
                                        value="{{ old('receipt_bill_amount') }}" required>
                                    <label for="receipt_bill_amount" style="color: red" class="active">Receipt Bill
                                        Amount<span class="red-star">*</span></label>
                                </div>
                                <div class="input-field col s12 m2 project-type-wrapper" id="mode_of_payment">
                                    <select name="" id="" class="browser-default select2">
                                        <option value="">Choose option</option>
                                        <option value="1">Cash</option>
                                        <option value="2">Cheque</option>
                                        <option value="3">DD</option>
                                        <option value="4">Wire Transfer</option>
                                    </select>
                                    <label for="mode_of_payment" id="mode_of_payment_label" class="active"
                                        style="color: red">Mode Of Payment<span class="red-star">*</span></label>
                                </div>
                            </div>

                            <div class="row">
                                <div class="input-field col s12 m3">
                                    <input id="bank_name" type="text" name="bank_name" value="{{ old('bank_name') }}"
                                        required>
                                    <label for="bank_name" style="color: red" class="active">Bank Name</label>
                                </div>
                                <div class="input-field col s12 m2">
                                    <input id="cheque_date" type="date" name="cheque_date"
                                        value="{{ old('cheque_date') }}" required>
                                    <label for="cheque_date" style="color: red">Cheque Date</label>
                                </div>
                                <div class="input-field col s12 m2">
                                    <input id="cheque_no" type="text" name="cheque_no"
                                        value="{{ old('cheque_no') }}" required>
                                    <label for="cheque_no" style="color:red" class="active">Cheque No</label>
                                </div>

                                <div class="input-field col s12 m2 project-type-wrapper" id="cheque_account_type">
                                    <select name="" id="" class="browser-default select2">
                                        <option value="">Choose option</option>
                                        <option value="NRE">NRE</option>
                                        <option value="NRO">NRO</option>
                                    </select>
                                    <label for="cheque_account_type" id="cheque_account_type_label" class="active"
                                        style="color:red">Cheque Account Type</label>
                                </div>
                                <div class="input-field col s12 m2 project-type-wrapper" id="cheque_type">
                                    <select name="" id="" class="browser-default select2">
                                        <option value="">Choose option</option>
                                        <option value="Local">Local</option>
                                        <option value="Out Station">Out Station</option>
                                    </select>
                                    <label for="cheque_type" id="cheque_type_label" class="active"
                                        style="color: red">Cheque Type</label>
                                </div>
                            </div>

                            <div class="row">
                                <div class="input-field col s12 m3">
                                    <button type="submit" class="btn">Save</button>
                                    <a href="{{ route('mall-software.rent_receipt.index') }}" class="btn">Cancel</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#automatic_numbering_div').hide();
            $('.select2').each(function() {
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent()
                });
            });
        });
    </script>
@endsection
