@extends('dashboard.layouts.app')
@section('css')
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">All Bills</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ route('dashboard.home') }}" class="breadcrumb">Home</a>
                <a href="#" class="breadcrumb">Reports</a>
                <a href="#" class="breadcrumb">All Bills</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                        </div>
                        {{-- <div>
                            <a href="#" class="btn">Create Rent
                                Receipt</a>
                        </div> --}}
                        <br>
                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        @if ($message = Session::get('error'))
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                {{ $message }}
                            </div>
                        @endif

                        <div class="row">
                            <table id="unit_definitions_table" class="responsive-table display" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>SL No.</th>
                                        <th>Bill Number</th>
                                        <th>Lessee Name</th>

                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
{{-- @section('js')
    <script>
        //get all data to table
        $(function() {
            $('#unit_definitions_table').DataTable({
                retrieve: true,
                processing: true,
                serverSide: true,
                sScrollX: false,
                ajax: '{{ route('mall-software.unit_definitions.list') }}',
                scrollX: true,
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'unit_name',
                    },
                    {
                        data: 'projects',
                    },
                    {
                        data: 'block',
                    },
                    {
                        data: 'types',
                    },
                    {
                        data: 'floors',
                    },
                    {
                        data: 'actions',
                        name: 'actions',
                    },
                ]
            });
        });
    </script>
@endsection --}}
