@extends('dashboard.layouts.app')
@section('css')
    <style>
        .px-10 {
            padding-left: 30px;
            padding-right: 30px;
        }

        .row {
            margin-top: 10px;
        }
    </style>
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Edit Company</h5>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        @if ($message = Session::get('error'))
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                {{ $message }}
                            </div>
                        @endif

                        <div class="row">
                            <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                            </div>

                            <form method="post" action="" enctype="multipart/form-data" class="projectForm"
                                id="projectForm">
                                @csrf

                                <div class="row">
                                    <div class="input-field col s12 m3 l3">
                                        <input id="title" type="text" name="title" value="{{ $company->title }}">
                                        <label for="title" class="active" style="color: red">Title</label>
                                        <span id="title_error" class="error"></span>
                                    </div>
                                    <div class="input-field col s12 m3 l3">
                                        <input id="short_name" type="text" name="short_name"
                                            value="{{ $company->short_name }}">
                                        <label for="short_name" class="active" style="color: red">Short Name</label>
                                        <span id="short_name_error" class="error"></span>
                                    </div>
                                    <div class="input-field col s12 m3 l3">
                                        <input id="phone" type="text" name="phone" value="{{ $company->phone }}">
                                        <label for="phone" class="active" style="color: red">Phone</label>
                                        <span id="phone_error" class="error"></span>
                                    </div>
                                    <div class="input-field col s12 m3 l3">
                                        <input id="email" type="email" name="email" value="{{ $company->email }}">
                                        <label for="email" class="active" style="color: red">Email</label>
                                        <span id="email_error" class="error"></span>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="input-field col s12 m6 l6">
                                        <textarea id="address" name="address" class="materialize-textarea" style="height: 46px;">{{ $company->address }}</textarea>
                                        <label for="address" class="active">Address</label>
                                        <span id="address_error" class="error"></span>
                                    </div>
                                    <div class="input-field col s12 m2 l2">
                                        <input id="pincode" type="text" name="pincode" value="{{ $company->pincode }}">
                                        <label for="pincode" class="active">Pincode</label>
                                        <span id="pincode_error" class="error"></span>
                                    </div>
                                    <div class="input-field col s12 m2 l2">
                                        <select name="country_id" id="country_id" class="browser-default select2">
                                            <option value="">Choose your option</option>
                                            @foreach ($countries as $country)
                                                <option value="{{ $country->id }}"
                                                    @if ($company->country_id == $country->id) selected @endif>
                                                    {{ $country->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <label for="country_id" class="active">Country</label>
                                        <span id="country_id_error" class="error"></span>
                                    </div>
                                    <div class="input-field col s12 m2 l2">
                                        <select name="state_id" id="state_id" class="browser-default select2">
                                            @foreach ($states as $state)
                                                <option value="{{ $state->id }}"
                                                    @if ($company->state_id == $state->id) selected @endif>
                                                    {{ $state->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <label for="state_id" class="active">State</label>
                                        <span id="state_id_error" class="error"></span>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="input-field col s12 m2 l2">
                                        <input id="web_site" type="text" name="web_site"
                                            value="{{ $company->web_site }}">
                                        <label for="web_site" class="active">Web Site</label>
                                        <span id="web_site_error" class="error"></span>
                                    </div>
                                    <div class="input-field col s12 m2 l2">
                                        <input id="location" type="text" name="location"
                                            value="{{ $company->location }}">
                                        <label for="location" class="active">Location</label>
                                        <span id="location_error" class="error"></span>
                                    </div>
                                    <div class="input-field col s12 m2 l2">
                                        <input id="pan_no" type="text" name="pan_no"
                                            value="{{ $company->pan_no }}">
                                        <label for="pan_no" class="active">Pan No.</label>
                                        <span id="pan_no_error" class="error"></span>
                                    </div>
                                    <div class="input-field col s12 m2 l2">
                                        <input id="tan" type="text" name="tan"
                                            value="{{ $company->tan }}">
                                        <label for="tan" class="active">Tan</label>
                                        <span id="tan_error" class="error"></span>
                                    </div>
                                    <div class="input-field col s12 m2 l2">
                                        <input id="gst_in" type="text" name="gst_in"
                                            value="{{ $company->gst_in }}">
                                        <label for="gst_in" class="active">GST IN</label>
                                        <span id="gst_in_error" class="error"></span>
                                    </div>
                                    <div class="input-field col s12 m2 l2">
                                        <input id="pf_no" type="text" name="pf_no"
                                            value="{{ $company->pf_no }}">
                                        <label for="pf_no" class="active">PF No.</label>
                                        <span id="pf_no_error" class="error"></span>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="input-field col s12 m3 l3">
                                        <input id="cin" type="text" name="cin"
                                            value="{{ $company->cin }}">
                                        <label for="cin" class="active">CIN</label>
                                        <span id="cin_error" class="error"></span>
                                    </div>
                                    <div class="input-field col s12 m3 l3">
                                        <input id="contact_person" type="text" name="contact_person"
                                            value="{{ $company->contact_person }}">
                                        <label for="contact_person" class="active">Contact Person</label>
                                        <span id="contact_person_error" class="error"></span>
                                    </div>
                                    <div class="input-field col s12 m3 l3">
                                        <input id="contact_phone" type="text" name="contact_phone"
                                            value="{{ $company->contact_phone }}">
                                        <label for="contact_phone" class="active">Contact Phone</label>
                                        <span id="contact_phone_error" class="error"></span>
                                    </div>
                                    <div class="input-field col s12 m3 l3">
                                        <select name="parent_company_id" id="parent_company_id"
                                            class="browser-default select2">
                                            <option value="">Choose your option</option>
                                            @foreach ($parent_companies as $parent_company)
                                                <option value="{{ $parent_company->id }}"
                                                    @if ($company->parent_company_id == $parent_company->id) selected @endif>
                                                    {{ $parent_company->title }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <label for="parent_company_id" class="active">Parent Company</label>
                                        <span id="parent_company_id_error" class="error"></span>
                                    </div>
                                </div>
                                <div class="row m-t-40 m-b-20">
                                    <div class="input-field col s12">
                                        <input type="hidden" name="id" value="{{ $company->id }}">
                                        <div class="success-alert-bar p-15 m-b-20 green white-text status"
                                            id="success-msg" style="display: none;"></div>
                                        <div class="error-alert-bar p-15 m-b-20 red white-text status" id="error-msg"
                                            style="display: none;"></div>
                                        <div class="loading" style="display:none"><img
                                                src="{{ asset('assets/images/loading.gif') }}"></div>
                                        <button class="btn green waves-effect waves-light  sub-btn" type="submit"
                                            name="" id="add_project_btn"><b>Update</b>
                                        </button>
                                    </div>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        function clearForm() {
            document.getElementById("formValidate").reset();
        }

        $(document).ready(function() {
            //  var usersTable = $('#users_table_crm').DataTable({});

            $('.select2').each(function() {

                $(this).select2({

                    placeholder: "Choose your option",

                    theme: "material",

                    dropdownParent: $(this).parent()

                });

            });

            $('.sub-btn').on('click', function(e) {

                var company_id = '<?php echo $company->id; ?>';
                $('.status').hide();
                $('.red').html('');

                e.preventDefault();
                var formData = new FormData($("#projectForm")[0]);
                $.ajax({
                    url: '{{ url('/dashboard/finance/companies/update ') }}',
                    method: "post",
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    dataType: "json",

                    beforeSend: function() {
                        $('.loading').show();
                        $('#add_project_btn').prop('disabled', true);
                    },
                    success: function(response) {
                        $('.loading').hide();
                        $('#add_project_btn').prop('disabled', false);

                        if (response.status == true) {
                            $("#projectForm")[0].reset();
                            $('#success-msg').show();
                            $('#success-msg').html(response.message);
                            window.location = "/dashboard/finance/companies";
                        }
                        if (response.status == false) {
                            $("#projectForm")[0].reset();
                            $('#error-msg').show();
                            $('#error-msg').html(response.message);
                            window.location = "/dashboard/finance/companies/edit/" + type;
                        }
                    },
                    error: function(res) {
                        $('.loading').hide();
                        $('#add_project_btn').prop('disabled', false);
                        $.each(res.responseJSON.errors, function(key, value) {
                            $("#" + key + "_error").text(value[0]);
                        });
                    }
                });
            });

        });


        $('#country_id').change(function() {
            $('#state_id').html('');
            $('#state_id').html('<option value="" disabled selected>Choose your option</option>');
            var country_id = $(this).val();
            if (country_id != '') {
                $.ajax({
                    url: '',
                    method: "POST",
                    data: {
                        _token: '{{ csrf_token() }}',
                        country_id: country_id
                    },
                    dataType: "json",
                    success: function(response) {

                        var data = response.data;
                        // Add options
                        if (data.length > 0) {
                            $.each(data, function(index, value) {

                                $('#state_id').append('<option value="' + value['id'] +
                                    '">' + value['name'] + '</option>');
                                ind = index;
                            });
                        } else {
                            $('#state_id').html('');
                            $('#state_id').html(
                                '<option value="" disabled selected>Choose your option</option>');
                        }
                        //if(ind)
                        $('#state_id').formSelect();
                    }
                });
            } else {
                $('#state_id').html('');
                $('#state_id').html('<option value="" disabled selected>Choose your option</option>');
                $('#state_id').formSelect();
            }
        });
    </script>
@endsection
