@extends('dashboard.layouts.app')
@section('css')
    <script src="{{ asset('js/tree-view.js') }}"></script>
    <style>
        ul.treeview {
            text-transform: uppercase;
        }
    </style>
    <link rel="stylesheet" href="{{ asset('css/tree-view.css') }}">
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Companies</h5>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card">
                    <div class="card-content">
                        <div class="d-flex align-items-center">
                            <h5 class="card-title activator ">
                                <h5 class="card-title activator"><a class="waves-effect waves-light btn m-t-10"
                                        href="{{ route('mall-software.companies_create') }}">Add</a></h5>
                            </h5>
                        </div>

                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        @if ($message = Session::get('error'))
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                {{ $message }}
                            </div>
                        @endif
                        <table id="users_table_crm" class="responsive-table display" style="width:100%">
                            <thead>
                                <tr>
                                    <th>
                                        Sl.No.
                                    </th>
                                    <th>
                                        Name
                                    </th>
                                    <th>
                                        Phone
                                    </th>
                                    <th>
                                        Email
                                    </th>
                                    {{-- <th>
                                        Country
                                    </th>
                                    <th>
                                        State
                                    </th> --}}
                                    <th>
                                        Contact Phone
                                    </th>
                                    <th>
                                        Contact Person
                                    </th>
                                    <th>
                                        Actions
                                    </th>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col l3 s3">

            </div>
        </div>
    @endsection

    @section('js')
        <script>
            $(document).ready(function() {
                $('.select2').each(function() {
                    width: "100%",

                    $(this).select2({
                        placeholder: "Choose your option",
                        theme: "material",
                        dropdownParent: $(this).parent(),

                    });
                });
                $(".select2-selection__arrow")
                    .addClass("material-icons")
                    .html("arrow_drop_down");

                var projectUnitsTable = $('#users_table_crm').DataTable({
                    processing: true,
                    serverSide: true,
                    //  pageLength: 10,
                    paging: true,
                    responsive: true,
                    scrollX: false,
                    //autowidth:false,
                    ajax: {
                        url: "{{ route('mall-software.company_list') }}",
                        data: function(d) {
                            d.country_id = $('#filter_country_id').val();
                        }
                    },

                    columns: [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex',
                            orderable: false,
                            searchable: false
                        },

                        {
                            data: 'title',
                            name: 'title'
                        },
                        {
                            data: 'phone',
                            name: 'phone'
                        },
                        {
                            data: 'email',
                            name: 'email'
                        },
                        {
                            data: 'contact_person',
                            name: 'contact_person'
                        },
                        {
                            data: 'contact_phone',
                            name: 'contact_phone'
                        },
                        {
                            data: 'actions',
                            name: 'actions'
                        },
                    ],
                    "order": [
                        [1, "desc"]
                    ],
                    "drawCallback": function(settings) {
                        $('.dropdown-trigger').dropdown();
                    },
                    lengthMenu: [
                        [10, 25, 50, 100, -1],
                        ['10 rows', '25 rows', '50 rows', '100 rows', 'Show all']
                    ],
                });


                $('#btn_filter_clear').click(function(e) {

                    $('#filter_status').val('').change();
                    $('#filter_country_id').val('').change();

                    e.preventDefault();

                    projectUnitsTable.draw();

                });


                $('#search_btn').click(function(e) {

                    e.preventDefault();

                    projectUnitsTable.draw();



                });

                $('#filter_status').change(function(e) {
                    var status = $('#filter_status').val();
                    $('#availability_status').val(status);
                });

                $('#filter_country_id').change(function(e) {
                    var apartment_type = $('#filter_country_id').val();
                    $('#apartment_type_export').val(apartment_type);
                });

            });
        </script>
    @endsection
