@extends('dashboard.layouts.app')
@section('css')
    {{-- <style>
  .hide{ display: none;}
  label{ width:100%;}
</style> --}}
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Roles</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ route('home') }}" class="breadcrumb">Home</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card">
                    <div class="card-content">
                        {{-- @if (\Auth::user()->checkPermission('crm-create-role')) --}}
                        <h5 class="card-title activator"><a class="waves-effect waves-light btn"
                                href="{{ route('mall-software.roles.create') }}">Add Role</a></h5>
                        {{-- @endif
                  @if ($message = Session::get('success'))
                  <div class="success-alert-bar p-15 m-b-20 green white-text">
                    {{ $message }}
                </div>

              @endif --}}
                        <table id="roles_table" class="responsive-table display">
                            <thead>
                                <tr>
                                    <th>
                                        #
                                    </th>
                                    <th>
                                        Name
                                    </th>
                                    <th>
                                        Slug
                                    </th>
                                    {{-- <th>
                                        Permissions
                                    </th> --}}
                                    <th>
                                        Actions
                                    </th>
                                </tr>
                            </thead>

                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        //get all data to table
        $(function() {
            $('#roles_table').DataTable({
                retrieve: true,
                processing: true,
                serverSide: true,
                sScrollX: false,
                ajax: '{{ route("mall-software.roleslist") }}',
                scrollX: true,
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name',
                    },
                    {
                        data: 'slug',
                    },
                    // {
                    //     data: 'permissions',
                    // },
                    {
                        data: 'actions',
                        name: 'actions',
                    },
                ]
            });
        });
    </script>
@endsection
