@extends('dashboard.layouts.app')
@section('css')
    <style>
        .px-10 {
            padding-left: 30px;
            padding-right: 30px;
        }

        .row {
            margin-top: 10px;
        }
    </style>
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Users</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ route('dashboard.home') }}" class="breadcrumb">Home</a>
                <a href="{{ route('mall-software.users.index') }}" class="breadcrumb">Users</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card">
                    <div class="card-content">
                        <h5 class="card-title activator">Edit User</h5>
                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        <div class="row">
                            <form method="post" action="{{ route('mall-software.users.update', $user) }}"
                                enctype="multipart/form-data" class="formValidate" id="formValidate">
                                {{ csrf_field() }}
                                <div class="row">
                                    <input type="hidden" name="id" value="{{ $user->id }}">
                                    <div class="input-field col s6">
                                        <input id="name" type="text" name="name" value="{{ $user->name }}">
                                        <label for="name">Name</label>
                                        @error('name')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s6">
                                        <input id="full_name" type="text" name="full_name"
                                            value="{{ $user->full_name }}">
                                        <label for="full_name">Full name</label>
                                        @error('full_name')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="input-field col s6">
                                        <input id="username" type="text" name="username" value="{{ $user->username }}">
                                        <label for="username">Username</label>
                                        @error('username')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s6">
                                        <input id="email" type="email" name="email" value="{{ $user->email }}">
                                        <label for="email">Email</label>
                                        @error('email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="input-field col s6">
                                        <input id="password" type="password" name="password" value="">
                                        <label for="password">Password</label>
                                        @error('password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s6">
                                        <input id="confirm_password" type="password" name="confirm_password"
                                            value="{{ old('confirm_password') }}">
                                        <label for="confirm_password">Confirm Password</label>
                                        @error('confirm_password')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="input-field col s6">
                                        <input id="mobile" type="text" name="mobile" value="{{ $user->mobile }}">
                                        <label for="mobile">Mobile</label>
                                        @error('mobile')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s6">
                                        <input id="designation" type="text" name="designation"
                                            value="{{ $user->designation }}">
                                        <label for="designation">Designation</label>
                                        @error('designation')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="input-field col s6">
                                        <select name="reporting_to" id="reporting_to" class="browser-default select2">
                                            <option value="">Choose your option</option>
                                            @foreach ($reporting_to as $r)
                                                <option
                                                    value="{{ $r->id }} @if ($user->reporting_to == $r->id) selected @endif">
                                                    {{ $r->name }}</option>
                                            @endforeach
                                        </select>
                                        <label for="reporting_to" class="active">Reporting To</label>
                                        @error('reporting_to')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s6">
                                        <select name="role" id="role">
                                            <option value="">Choose your option</option>
                                            @foreach ($roles as $role)
                                                <option value="{{ $role->id }}">{{ $role->name }}</option>
                                            @endforeach
                                        </select>
                                        <label for="role">Role</label>
                                        @error('role')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                {{-- <div class="input-field col l6 m6 s12">
                                        <select name="branch_id" id="branch_id" class="browser-default select2">
                                            <option value="">Choose your option</option>
                                            @foreach ($branches as $branch)
                                                <option value="{{ $branch->id }}">
                                                    {{ $branch->name }}</option>
                                            @endforeach
                                        </select>
                                        <label for="branch_id" class="active">Branch</label>
                                        @error('branch_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror

                                    </div> --}}

                                <div class="row">
                                    <div class="input-field col s6">
                                        <input id="blood_group" type="text" name="blood_group"
                                            value="{{ $user->blood_group }}">
                                        <label for="blood_group">Blood Group</label>
                                        @error('blood_group')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s6">
                                        <input id="date_of_birth" type="text" name="date_of_birth"
                                            value="{{ $user->date_of_birth }}" class="M_datepicker">
                                        <label for="date_of_birth">Date Of Birth</label>
                                        @error('date_of_birth')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                {{-- <div class="row">
                                    <div class="input-field col s12">
                                        <input id="salary" type="number" name="salary"
                                            value="{{ old('salary') }}">
                                        <label for="salary">salary</label>
                                        @error('salary')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div> --}}

                                {{-- <div class="row">
                                    <div class="input-field col s12">
                                        <input id="emergency_contact_number" type="number"
                                            name="emergency_contact_number"
                                            value="{{ old('emergency_contact_number') }}">
                                        <label for="emergency_contact_number">Emergency Contact Number</label>
                                        @error('emergency_contact_number')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div> --}}

                                {{-- <div class="row">
                                    <div class="input-field col s12">
                                        <input id="uan_number" type="number" name="uan_number"
                                            value="{{ old('uan_number') }}">
                                        <label for="uan_number">UAN Number</label>
                                        @error('uan_number')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div> --}}

                                {{-- <div class="row">
                                    <div class="input-field col s12">
                                        <input id="lwf_details" type="text" name="lwf_details" class="datepicker"
                                            value="{{ old('lwf_details') }}">
                                        <label for="lwf_details">LWF Details</label>
                                        @error('lwf_details')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div> --}}

                                {{-- <div class="row">
                                    <div class="input-field col s12">
                                        <input id="remarks" type="text" name="remarks"
                                            value="{{ old('remarks') }}">
                                        <label for="remarks">Remarks</label>
                                        @error('remarks')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div> --}}


                                {{-- </div> --}}
                                {{-- <div class="col s12 l6"> --}}
                                {{-- <div class="row">
                                    <div class="input-field col s12">
                                        <input id="email" type="email" name="email" value="{{ old('email') }}"
                                            required>
                                        <label for="email">Email</label>
                                        @error('email')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div> --}}
                                <div class="row">

                                </div>
                                <div class="row">
                                    <div class="file-field input-field col s6">
                                        <div class="btn">
                                            <span>Browse Image</span>
                                            <input type="file" name="file" id="file">
                                            <span id="file_error" class="error"></span>
                                        </div>
                                        <div class="file-path-wrapper">
                                            <input class="file-path validate" type="text">
                                        </div>
                                        @error('file')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s6">
                                        <select name="gender" id="gender" class="browser-default select2">
                                            <option value="">Choose your option</option>
                                            <option value="M" @if ($user->gender == 'M') selected @endif>Male
                                            </option>
                                            <option value="F"@if ($user->gender == 'F') selected @endif>Female
                                            </option>
                                        </select>
                                        <label for="gender" class="active">Gender</label>
                                        @error('gender')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="input-field col s12">
                                        <input id="address" type="text" name="address"
                                            value="{{ $user->address }}">
                                        <label for="address">Address</label>
                                        @error('address')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                {{-- <div class="row">
                                    <div class="input-field col s12">
                                        <input id="username" type="text" name="username"
                                            value="{{ old('username') }}" required>
                                        <label for="username">Username</label>
                                        @error('username')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>

                                    <div class="input-field col s12">
                                        <input id="joining_date" type="text" name="joining_date"
                                            value="{{ old('joining_date') }}" class="datepicker" required>
                                        <label for="joining_date">Joining Date</label>
                                        @error('joining_date')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror

                                    </div>

                                </div> --}}

                                {{-- <div class="row">
                                    <div class="input-field col s12">
                                        <input id="resignation_date" type="text" name="resignation_date"
                                            value="" class="datepicker">
                                        <label for="resignation_date">Resignation Date</label>
                                        @error('resignation_date')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div> --}}


                                {{-- <div class="row">
                                    <div class="input-field col s12">
                                        <input id="personal_phone_number" type="number" name="personal_phone_number" value="{{ old('personal_phone_number') }}">
                                        <label for="personal_phone_number">Personal Phone Number</label>
                                        @error('personal_phone_number')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div> --}}

                                {{-- <div class="row">
                                    <div class="input-field col s12">
                                        <input id="department" type="text" name="department" value="{{ old('department') }}">
                                        <label for="department">Department</label>
                                        @error('department')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div> --}}

                                {{-- <div class="row">
                                    <div class="input-field col s12">
                                        <input id="marriage_anniversary" type="text" name="marriage_anniversary" class="datepicker" value="{{ old('marriage_anniversary') }}">
                                        <label for="marriage_anniversary">Marriage Anniversary</label>
                                        @error('marriage_anniversary')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div> --}}

                                {{-- <div class="input-field col s12">
                                    <input id="account_number" type="number" name="account_number" value="{{ old('account_number') }}">
                                    <label for="account_number">Account Number</label>
                                    @error('account_number')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div> --}}

                                {{-- <div class="row">
                                    <div class="input-field col s12">
                                        <input id="aadhaar_number" type="number" name="aadhaar_number" value="{{ old('aadhaar_number') }}">
                                        <label for="aadhaar_number">Aadhaar Number</label>
                                        @error('aadhaar_number')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div> --}}

                                {{-- <div class="row">
                                    <div class="input-field col s12">
                                        <input id="uniform_given" type="text" name="uniform_given" class="datepicker" value="{{ old('uniform_given') }}">
                                        <label for="uniform_given">Uniform Given</label>
                                        @error('uniform_given')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div> --}}

                                <div class="row">
                                    <div class="input-field col s6">
                                        <button class="btn cyan waves-effect waves-light" type="submit"
                                            name="action">Submit
                                        </button>
                                        <a href="{{ route('mall-software.users.index') }}" class="btn">Cancel</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(document).ready(function() {
            $('.select2').each(function() {
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent()
                });
            });
            $(".select2-selection__arrow")
                .addClass("material-icons")
                .html("arrow_drop_down");

            $('.M_datepicker').datepicker({
                format: 'yyyy-mm-dd',
                yearRange: 100
            });
        });
    </script>
@endsection
