@extends('dashboard.layouts.app')
@section('css')
    <script src="{{ asset('js/tree-view.js') }}"></script>
    <style>
        ul.treeview {
            text-transform: uppercase;
        }
    </style>
    <link rel="stylesheet" href="{{ asset('css/tree-view.css') }}">
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Users</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ route('home') }}" class="breadcrumb">Home</a>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card">
                    <div class="card-content">
                        <div class="d-flex align-items-center">
                            <h5 class="card-title activator ">
                                <h5 class="card-title activator"><a class="waves-effect waves-light btn m-t-10"
                                        href="{{ route('mall-software.users.create') }}">Add User</a></h5>
                            </h5>
                        </div>

                        @if ($message = Session::get('success'))
                            <div class="success-alert-bar p-15 m-b-20 green white-text">
                                {{ $message }}
                            </div>
                        @endif
                        @if ($message = Session::get('error'))
                            <div class="error-alert-bar p-15 m-b-20 red white-text">
                                {{ $message }}
                            </div>
                        @endif
                        <table id="users_table" class="responsive-table display" style="width:100%">
                            <thead>
                                <tr>
                                    <td>
                                        Sl.No.
                                    </td>
                                    <th>
                                        Name
                                    </th>
                                    <th>
                                        Email ID
                                    </th>
                                    {{-- <th>
                                        Branch
                                    </th> --}}
                                    <th>
                                        Status
                                    </th>
                                    <th>
                                        Gender
                                    </th>
                                    <th>
                                        Actions
                                    </th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col l3 s3">

            </div>
        </div>
    @endsection
    @section('js')
        <script>
            //get all data to table
            $(function() {
                $('#users_table').DataTable({
                    retrieve: true,
                    processing: true,
                    serverSide: true,
                    sScrollX: false,
                    ajax: '{{ route('mall-software.users.list') }}',
                    scrollX: true,
                    columns: [{
                            data: 'DT_RowIndex',
                            name: 'DT_RowIndex',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'name',
                        },
                        {
                            data: 'email',
                        },
                        // {
                        //     data: 'branch_name',
                        // },
                        {
                            data: 'status',
                        },
                        {
                            data: 'gender',
                        },
                        {
                            data: 'actions',
                            name: 'actions',
                        },
                    ]
                });
            });
        </script>
    @endsection
