@extends('dashboard.layouts.app')
@section('css')
@endsection
@section('content')
    <div class="page-titles">
        <div class="d-flex align-items-center">
            <h5 class="font-medium m-b-0">Edit Unit Definitions</h5>
            <div class="custom-breadcrumb ml-auto">
                <a href="{{ route('dashboard.home') }}" class="breadcrumb">Home</a>
                <a href="#" class="breadcrumb">Lease and Rental</a>
                <a href="{{ route('mall-software.unit_definitions.index') }}" class="breadcrumb">Unit Definitions</a>
                <a href="#" class="breadcrumb">Edit Unit Definitions</a>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col s12 l12">
                <div class="card px-10">
                    <div class="card-content">
                        <div class="success-alert-bar p-15 m-b-20 green white-text statuse" style="display: none;">
                        </div>

                        <form method="post"
                            action="{{ route('mall-software.unit_definitions.update', $unitDefinition->id) }}"
                            class="formValidate" id="formValidate" name="formValidate" data-parsley-validate>
                            @csrf
                            <div class="row">
                                <div class="input-field col s13 m3 project-type-wrapper">
                                    <select name="project" id="project" class="browser-default select2" required>
                                        <option value="">---Select---</option>
                                        @foreach ($projects as $project)
                                            <option value="{{ $project->id }}"
                                                @if ($unitDefinition->project_id == $project->id) selected @endif>
                                                {{ $project->project_name }}</option>
                                        @endforeach
                                    </select>
                                    <label for="project" style="color: red" class="active">Project<span
                                            class="red-star">*</span></label>
                                    @error('project')
                                        <span style="color:red">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="input-field col s13 m3 project-type-wrapper">
                                    <input type="text" name="unit_name" id="prefix"
                                        value="{{ $unitDefinition->unit_name }}" required>
                                    <label for="unit_name" style="color: red" class="active">Unit Name<span
                                            class="red-star">*</span></label>
                                </div>


                                <div class="input-field col s13 m2 project-type-wrapper">
                                    <select name="blocks" id="blocks" class="browser-default select2" required>
                                        <option value="">---Select---</option>
                                        @foreach ($blocks as $block)
                                            <option value="{{ $block->id }}"@if ($unitDefinition->block_id ==  $block->id)
                                                selected
                                            @endif>{{ $block->block_name }}</option>
                                        @endforeach
                                    </select>
                                    <label for="blocks" style="color: red" class="active">Blocks<span
                                            class="red-star">*</span></label>
                                    @error('blocks')
                                        <span style="color:red">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="input-field col s13 m2 project-type-wrapper">
                                    <select name="type" id="type" class="browser-default select2" required>
                                        <option value="">---Select Type---</option>
                                        @foreach ($types as $type)
                                            <option value="{{ $type->id }}"
                                                @if ($unitDefinition->type_id == $type->id) selected @endif>{{ $type->type }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <label for="type" style="color: red" class="active">Type<span
                                            class="red-star">*</span></label>
                                    @error('type')
                                        <span style="color:red">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="input-field col s13 m2 project-type-wrapper">
                                    <select name="floor" id="floor" class="browser-default select2" required>
                                        <option value="">---Select Floor---</option>
                                        @foreach ($floors as $floor)
                                            <option value="{{ $floor->id }}"
                                                @if ($unitDefinition->floor_id == $floor->id) selected @endif>{{ $floor->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <label for="floor" style="color: red" class="active">Floor<span
                                            class="red-star">*</span></label>
                                    @error('floor')
                                        <span style="color:red">{{ $message }}</span>
                                    @enderror
                                </div>

                            </div>
                            <div class="row">
                                {{-- <div class="input-field col s13 m2 project-type-wrapper">
                                    <input type="text" name="prefix" id="prefix"
                                        value="{{ $unitDefinition->prefix }}">
                                    <label for="prefix">Prefix</label>
                                </div>
                                <div class="input-field col s13 m2 project-type-wrapper">
                                    <input type="text" name="suffix" id="suffix"
                                        value="{{ $unitDefinition->suffix }}">
                                    <label for="suffix">Suffix</label>
                                </div> --}}
                                <div class="input-field col s13 m2 project-type-wrapper">
                                    <input type="text" name="start_number" id="start_number"
                                        value="{{ $unitDefinition->start_number }}" data-parsley-type="integer">
                                    <label for="start_number" class="active">Start Number</label>
                                </div>
                                <div class="input-field col s13 m2 project-type-wrapper">
                                    <input type="text" name="number_units" id="number_units"
                                        value="{{ $unitDefinition->number_units }}">
                                    <label for="number_units" class="active">Number Units</label>
                                </div>

                            </div>

                            <div class="row">
                                <div class="input-field col s12 m6 project-type-wrapper">
                                    <button type="submit" class="btn">Update</button>
                                    <a href="{{ route('mall-software.unit_definitions.index') }}" class="btn">Cancel</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/parsley.js/2.9.2/parsley.min.js"></script>
    <script>
        $(document).ready(function() {
            $('#formValidate').parsley();
            $('.select2').each(function() {
                $(this).select2({
                    placeholder: "Choose your option",
                    theme: "material",
                    dropdownParent: $(this).parent()
                });
            });
        });
    </script>
@endsection
